/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.UserValues;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.MailTestManager;
import com.openexchange.ajax.mail.TestMail;
import com.openexchange.exception.OXException;
import java.io.IOException;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class CopyMailTest
extends AbstractMailTest {
    private UserValues values;

    public CopyMailTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.values = this.getClient().getValues();
    }

    @Override
    protected void tearDown() throws Exception {
        this.clearFolder(this.values.getSentFolder());
        this.clearFolder(this.values.getInboxFolder());
        this.clearFolder(this.values.getDraftsFolder());
        super.tearDown();
    }

    public void testShouldCopyFromSentToDrafts() throws OXException, IOException, SAXException, JSONException {
        MailTestManager manager = new MailTestManager(this.client, false);
        String mail = this.values.getSendAddress();
        this.sendMail(this.createEMail(mail, "Copy a mail", "ALTERNATE", "Copy from sent to drafts").toString());
        String origin = this.values.getInboxFolder();
        String destination = this.values.getDraftsFolder();
        TestMail myMail = new TestMail(this.getFirstMailInFolder(origin));
        myMail.getId();
        TestMail copiedMail = manager.copy(myMail, destination);
        String newID = copiedMail.getId();
        System.out.println("***** newID : " + newID);
        manager.get(destination, newID);
        CopyMailTest.assertTrue((String)"Should produce no errors when getting copied e-mail", (!manager.getLastResponse().hasError() ? 1 : 0) != 0);
        CopyMailTest.assertTrue((String)"Should produce no conflicts when getting copied e-mail", (!manager.getLastResponse().hasConflicts() ? 1 : 0) != 0);
    }
}

