/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.ClearRequest;
import com.openexchange.ajax.mail.actions.SendRequest;
import com.openexchange.exception.OXException;
import java.io.IOException;
import javax.mail.internet.AddressException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.xml.sax.SAXException;

public class ClearTest
extends AbstractMailTest {
    private static final Log LOG = LogFactory.getLog(ClearTest.class);
    private String mailObject_25kb;

    public ClearTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        super.tearDown();
    }

    public void testClearingOneFolder() throws OXException, IOException, SAXException, JSONException, AddressException, OXException {
        int numOfMails = 5;
        LOG.info((Object)"Sending 5 mails to fill emptied INBOX");
        for (int i = 0; i < 5; ++i) {
            this.getClient().execute(new SendRequest(this.mailObject_25kb));
            LOG.info((Object)("Sent " + (i + 1) + ". mail of " + 5));
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            ClearTest.fail((String)allR.getException().toString());
        }
        ClearTest.assertEquals((String)"There should be 5 messages in the folder", (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length, (int)5);
        String[] array = new String[]{this.getInboxFolder()};
        this.getClient().execute(new ClearRequest(array));
        allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            ClearTest.fail((String)allR.getException().toString());
        }
        ClearTest.assertEquals((String)"There should be no messages in the folder", (int)allR.getMailMessages(COLUMNS_DEFAULT_LIST).length, (int)0);
    }
}

