/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.importexport.AbstractVCardTest;
import com.openexchange.ajax.importexport.ICalImportTest;
import com.openexchange.groupware.container.Contact;
import com.openexchange.webdav.xml.ContactTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCardExportTest
extends AbstractVCardTest {
    final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Log LOG = LogFactory.getLog(ICalImportTest.class);

    public VCardExportTest(String name) {
        super(name);
        this.simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testExportVCard() throws Exception {
        Date lastModified;
        String surname = "testImportVCard" + System.currentTimeMillis();
        Contact contactObj = new Contact();
        contactObj.setSurName(surname);
        contactObj.setGivenName("givenName");
        contactObj.setBirthday(this.simpleDateFormat.parse("2007-04-04"));
        contactObj.setParentFolderID(this.contactFolderId);
        int objectId = ContactTest.insertContact(this.getWebConversation(), contactObj, this.getHostName(), this.getLogin(), this.getPassword(), "");
        Contact[] contactArray = this.exportContact(this.getWebConversation(), this.contactFolderId, this.emailaddress, this.timeZone, this.getHostName(), this.getSessionId());
        boolean found = false;
        for (int a = 0; a < contactArray.length; ++a) {
            if (contactArray[a].getSurName() == null || !contactArray[a].getSurName().equals(surname)) continue;
            found = true;
            ContactTest.compareObject(contactObj, contactArray[a]);
        }
        VCardExportTest.assertTrue((String)("contact with surname: " + surname + " not found"), (boolean)found);
        AJAXClient client = new AJAXClient(AJAXClient.User.User1);
        GetRequest getRequest = new GetRequest(this.contactFolderId, objectId, client.getValues().getTimeZone(), false);
        try {
            lastModified = client.execute(getRequest).getContact().getLastModified();
        }
        catch (Exception e) {
            lastModified = new Date(System.currentTimeMillis() + 10000L);
        }
        DeleteRequest del = new DeleteRequest(client.getValues().getPrivateContactFolder(), objectId, lastModified, false);
        client.execute(del);
    }
}

