/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.FolderTestManager;
import java.util.Date;

public class ExemplaryFolderTestManagerTest
extends AbstractAJAXSession {
    private FolderTestManager manager;
    private AJAXClient client;
    FolderObject folderObject1;
    FolderObject folderObject2;

    public ExemplaryFolderTestManagerTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.manager = new FolderTestManager(this.getClient());
        this.folderObject1 = new FolderObject();
        this.folderObject1.setFolderName("ExemplaryFolderTestManagerTest-folder1" + System.currentTimeMillis());
        this.folderObject1.setType(2);
        this.folderObject1.setParentFolderID(this.client.getValues().getPrivateInfostoreFolder());
        this.folderObject1.setModule(8);
        OCLPermission perm1 = new OCLPermission();
        perm1.setEntity(this.client.getValues().getUserId());
        perm1.setGroupPermission(false);
        perm1.setFolderAdmin(true);
        perm1.setAllPermission(128, 128, 128, 128);
        this.folderObject1.setPermissionsAsArray(new OCLPermission[]{perm1});
        this.manager.insertFolderOnServer(this.folderObject1);
        this.folderObject2 = new FolderObject();
        this.folderObject2.setFolderName("ExemplaryFolderTestManagerTest-folder2" + System.currentTimeMillis());
        this.folderObject2.setType(2);
        this.folderObject2.setParentFolderID(this.client.getValues().getPrivateInfostoreFolder());
        this.folderObject2.setModule(8);
        OCLPermission perm2 = new OCLPermission();
        perm2.setEntity(this.client.getValues().getUserId());
        perm2.setGroupPermission(false);
        perm2.setFolderAdmin(true);
        perm2.setAllPermission(128, 128, 128, 128);
        this.folderObject2.setPermissionsAsArray(new OCLPermission[]{perm2});
        this.manager.insertFolderOnServer(this.folderObject2);
    }

    @Override
    public void tearDown() throws Exception {
        this.manager.cleanUp();
    }

    public void testCreatedFoldersAreReturnedByGetRequest() throws Exception {
        FolderObject fo = this.manager.getFolderFromServer(this.folderObject1.getObjectID());
        ExemplaryFolderTestManagerTest.assertEquals((String)"The folder was not returned.", (String)fo.getFolderName(), (String)this.folderObject1.getFolderName());
    }

    public void testCreatedFoldersAppearInListRequest() throws Exception {
        boolean found1 = false;
        boolean found2 = false;
        FolderObject[] allFolders = this.manager.listFoldersOnServer(this.client.getValues().getPrivateInfostoreFolder());
        for (int i = 0; i < allFolders.length; ++i) {
            FolderObject fo = allFolders[i];
            if (fo.getObjectID() == this.folderObject1.getObjectID()) {
                found1 = true;
            }
            if (fo.getObjectID() != this.folderObject2.getObjectID()) continue;
            found2 = true;
        }
        ExemplaryFolderTestManagerTest.assertTrue((String)"First folder was not found.", (boolean)found1);
        ExemplaryFolderTestManagerTest.assertTrue((String)"Second folder was not found.", (boolean)found2);
    }

    public void testCreatedFoldersAppearAsUpdatedSinceYesterday() throws Exception {
        boolean found1 = false;
        boolean found2 = false;
        Date date = new Date();
        date.setDate(date.getDate() - 1);
        FolderObject[] allFolders = this.manager.getUpdatedFoldersOnServer(this.client.getValues().getPrivateInfostoreFolder(), date);
        for (int i = 0; i < allFolders.length; ++i) {
            FolderObject co = allFolders[i];
            if (co.getObjectID() == this.folderObject1.getObjectID()) {
                found1 = true;
            }
            if (co.getObjectID() != this.folderObject2.getObjectID()) continue;
            found2 = true;
        }
        ExemplaryFolderTestManagerTest.assertTrue((String)"First folder was not found.", (boolean)found1);
        ExemplaryFolderTestManagerTest.assertTrue((String)"Second folder was not found.", (boolean)found2);
    }
}

