/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.AbstractManagedContactTest;
import com.openexchange.ajax.contact.action.AllRequest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonAllResponse;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.Contact;
import com.openexchange.tools.arrays.Arrays;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.junit.Assert;

public class AllTest
extends AbstractManagedContactTest {
    public AllTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
    }

    public void testAll() throws Exception {
        int[] columnIDs = new int[]{1, 20};
        Contact[] contacts = this.manager.allAction(6, columnIDs);
        AllTest.assertNotNull((String)"got no contacts", (Object)contacts);
        AllTest.assertTrue((String)"got no contacts", (0 < contacts.length ? 1 : 0) != 0);
    }

    public void testLastModifiedUTC() throws Exception {
        this.manager.newAction(this.generateContact("testLastModifiedUTC1"), this.generateContact("testLastModifiedUTC2"), this.generateContact("testLastModifiedUTC3"));
        int[] columnIDs = new int[]{1, 20, 6};
        Contact[] contacts = this.manager.allAction(this.folderID, columnIDs);
        AllTest.assertNotNull((String)"got no contacts", (Object)contacts);
        AllTest.assertTrue((String)"got no contacts", (0 < contacts.length ? 1 : 0) != 0);
        JSONArray arr = (JSONArray)this.manager.getLastResponse().getData();
        AllTest.assertNotNull((String)"no json array in response data", (Object)arr);
        int size = arr.length();
        AllTest.assertTrue((String)"no data in json array", (0 < arr.length() ? 1 : 0) != 0);
        for (int i = 0; i < size; ++i) {
            JSONArray objectData = arr.optJSONArray(i);
            AllTest.assertNotNull((Object)objectData);
            AllTest.assertNotNull((String)"no last modified utc found in contact data", (Object)objectData.opt(2));
        }
    }

    public void testExcludeAdmin() throws Exception {
        int[] columnIDs = new int[]{1, 20, 524};
        Object[] allContactsDefault = this.manager.allAction(6, columnIDs);
        AllTest.assertNotNull((String)"got no contacts", (Object)allContactsDefault);
        AllTest.assertTrue((String)"got no contacts", (0 < allContactsDefault.length ? 1 : 0) != 0);
        Object[] allContactsWithAdmin = this.allAction(6, columnIDs, true);
        AllTest.assertNotNull((String)"got no contacts", (Object)allContactsWithAdmin);
        AllTest.assertTrue((String)"got no contacts", (0 < allContactsWithAdmin.length ? 1 : 0) != 0);
        Contact[] allContactsWithoutAdmin = this.allAction(6, columnIDs, false);
        AllTest.assertNotNull((String)"got no contacts", (Object)allContactsWithoutAdmin);
        AllTest.assertTrue((String)"got no contacts", (0 < allContactsWithoutAdmin.length ? 1 : 0) != 0);
        Assert.assertArrayEquals((String)"'admin=true' differs from default result", (Object[])allContactsDefault, (Object[])allContactsWithAdmin);
        AllTest.assertEquals((String)"unexpected number of contacts in result", (int)allContactsWithAdmin.length, (int)(allContactsWithoutAdmin.length + 1));
    }

    private Contact[] allAction(int folderId, int[] columns, Boolean admin) throws OXException, IOException, JSONException {
        List<Object> allContacts = new LinkedList();
        AllRequestWithAdmin request = new AllRequestWithAdmin(folderId, columns, admin);
        CommonAllResponse response = this.getClient().execute(request, this.manager.getSleep());
        JSONArray data = (JSONArray)response.getResponse().getData();
        allContacts = this.manager.transform(data, columns);
        return allContacts.toArray(new Contact[0]);
    }

    private static final class AllRequestWithAdmin
    extends AllRequest {
        private final Boolean admin;

        public AllRequestWithAdmin(int folderId, int[] columns, Boolean admin) {
            super(folderId, columns);
            this.admin = admin;
        }

        @Override
        public AJAXRequest.Parameter[] getParameters() {
            Object[] params = super.getParameters();
            return null != this.admin ? (AJAXRequest.Parameter[])Arrays.add((Object[])params, (Object[])new AJAXRequest.Parameter[]{new AJAXRequest.Parameter("admin", this.admin)}) : params;
        }
    }
}

