/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.user.UserResolver;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.Changes;
import com.openexchange.groupware.container.Expectations;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.ldap.User;
import com.openexchange.resource.Resource;
import java.util.Arrays;

public class TestsForCreatingChangeExceptions
extends ManagedAppointmentTest {
    private Changes generateDefaultChangeException() {
        Changes changes = new Changes();
        changes.put(207, (Object)2);
        changes.put(201, (Object)this.D("31/12/2008 1:00", this.utc));
        changes.put(202, (Object)this.D("31/12/2008 2:00", this.utc));
        return changes;
    }

    public TestsForCreatingChangeExceptions(String name) {
        super(name);
    }

    public void testShouldAllowMovingAnExceptionBehindEndOfSeries() throws OXException {
        Appointment app = this.generateMonthlyAppointment();
        app.setOccurrence(3);
        Changes changes = new Changes();
        changes.put(207, (Object)2);
        changes.put(201, (Object)this.D("1/5/2008 1:00"));
        changes.put(202, (Object)this.D("1/5/2008 2:00"));
        this.positiveAssertionOnChangeException.check(app, changes, new Expectations(changes));
    }

    public void testShouldAllowMovingTheFirstAppointmentTo2359TheSameDay() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = new Changes();
        changes.put(207, (Object)1);
        changes.put(201, (Object)this.D("1/1/2008 23:00", this.utc));
        changes.put(202, (Object)this.D("1/1/2008 23:59", this.utc));
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
    }

    public void testShouldAllowMovingTheSecondAppointmentBeforeTheFirst() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = this.generateDefaultChangeException();
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
    }

    public void testShouldAllowMovingTheSecondAppointmentTo2359TheDayBefore() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = new Changes();
        changes.put(207, (Object)2);
        changes.put(201, (Object)this.D("1/1/2008 23:00", this.utc));
        changes.put(202, (Object)this.D("1/1/2008 23:59", this.utc));
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
    }

    public void testShouldAllowMovingTheSecondAppointmentTo2359OnTheSameDay() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = new Changes();
        changes.put(207, (Object)2);
        changes.put(201, (Object)this.D("2/1/2008 1:00", this.utc));
        changes.put(202, (Object)this.D("2/1/2008 2:00", this.utc));
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
    }

    public void testShouldAllowMovingTheSecondAppointmentToTheSamePlaceAsTheThirdOne() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = new Changes();
        changes.put(207, (Object)2);
        changes.put(201, (Object)this.D("3/1/2008 1:00", this.utc));
        changes.put(202, (Object)this.D("3/1/2008 2:00", this.utc));
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
    }

    public void testShouldNotMixUpWholeDayChangeExceptionAndNormalSeries() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        app.setFullTime(true);
        Changes changes = this.generateDefaultChangeException();
        changes.put(401, (Object)false);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
        Appointment series = this.positiveAssertionOnChangeException.getSeries();
        TestsForCreatingChangeExceptions.assertTrue((String)"Series should stay full time even if exception does not", (boolean)series.getFullTime());
    }

    public void testShouldKeepChangeInConfirmationLimitedToException() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = this.generateDefaultChangeException();
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
        Appointment exception = this.positiveAssertionOnChangeException.getChangeException();
        Appointment series = this.positiveAssertionOnChangeException.getSeries();
        this.calendarManager.confirm(exception, 3, "Changing change exception only");
        exception = this.calendarManager.get(exception);
        series = this.calendarManager.get(series);
        int actualConfirmationForException = exception.getUsers()[0].getConfirm();
        int actualConfirmationForSeries = series.getUsers()[0].getConfirm();
        TestsForCreatingChangeExceptions.assertEquals((String)"Should change confirmation status for exception", (int)3, (int)actualConfirmationForException);
        TestsForCreatingChangeExceptions.assertTrue((String)"Should not change confirmation status for series", (3 != actualConfirmationForSeries ? 1 : 0) != 0);
    }

    public void testShouldKeepChangeToFulltimeLimitedToException() throws Exception {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = this.generateDefaultChangeException();
        changes.put(401, (Object)false);
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
        app = this.positiveAssertionOnChangeException.getSeries();
        Appointment exception = this.positiveAssertionOnChangeException.getChangeException();
        changes = new Changes();
        changes.put(401, (Object)true);
        this.positiveAssertionOnUpdate.check(exception, changes, new Expectations(changes));
        Appointment actual = this.calendarManager.get(app);
        TestsForCreatingChangeExceptions.assertFalse((String)"Making an exception a whole-day-appointment should not make the series that, too", (boolean)actual.getFullTime());
    }

    public void testShouldKeepChangeInResourcesLimitedToException() throws Exception {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = this.generateDefaultChangeException();
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
        Appointment series = this.positiveAssertionOnChangeException.getSeries();
        Appointment exception = this.positiveAssertionOnChangeException.getChangeException();
        changes = new Changes();
        Resource res = this.resourceManager.search("*").get(0);
        ResourceParticipant resParticipant = new ResourceParticipant(res);
        ResourceParticipant[] participants = new ResourceParticipant[]{resParticipant};
        changes.put(220, (Object)participants);
        this.positiveAssertionOnUpdate.check(exception, changes, new Expectations());
        exception = this.calendarManager.get(exception);
        series = this.calendarManager.get(series);
        TestsForCreatingChangeExceptions.assertTrue((String)"Should contain the resource in the change exception", (boolean)Arrays.asList(exception.getParticipants()).contains(resParticipant));
        TestsForCreatingChangeExceptions.assertFalse((String)"Should not contain the resource in the whole series", (boolean)Arrays.asList(series.getParticipants()).contains(resParticipant));
    }

    public void testShouldKeepChangeInParticipantsLimitedToException() throws Exception {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        Changes changes = this.generateDefaultChangeException();
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
        Appointment series = this.positiveAssertionOnChangeException.getSeries();
        Appointment exception = this.positiveAssertionOnChangeException.getChangeException();
        changes = new Changes();
        UserResolver resolver = new UserResolver(this.getClient());
        User[] resolveUser = resolver.resolveUser(this.getAJAXProperty("seconduser") + "*");
        TestsForCreatingChangeExceptions.assertTrue((String)"Precondition: Cannot start without having another user ready", (resolveUser.length > 0 ? 1 : 0) != 0);
        UserParticipant userParticipant = new UserParticipant(resolveUser[0].getId());
        UserParticipant[] participants = new UserParticipant[]{userParticipant};
        changes.put(220, (Object)participants);
        this.positiveAssertionOnUpdate.check(exception, changes, new Expectations());
        exception = this.calendarManager.get(exception);
        series = this.calendarManager.get(series);
        TestsForCreatingChangeExceptions.assertTrue((String)"Should contain the participant in the change exception", (boolean)Arrays.asList(exception.getParticipants()).contains(userParticipant));
        TestsForCreatingChangeExceptions.assertFalse((String)"Should not contain the participant in the whole series", (boolean)Arrays.asList(series.getParticipants()).contains(userParticipant));
    }

    public void testShouldFailIfTryingToCreateADeleteExceptionOnTopOfAChangeException() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        int recurrencePos = 2;
        Changes changes = new Changes();
        changes.put(207, (Object)recurrencePos);
        changes.put(201, (Object)this.D("3/1/2008 0:00", this.utc));
        changes.put(202, (Object)this.D("3/1/2008 24:00", this.utc));
        Expectations expectations = new Expectations(changes);
        this.positiveAssertionOnChangeException.check(app, changes, expectations);
        Appointment series = this.positiveAssertionOnChangeException.getSeries().clone();
        this.calendarManager.createDeleteException(this.folder.getObjectID(), series.getObjectID(), recurrencePos);
        TestsForCreatingChangeExceptions.assertTrue((String)"Should get exception when trying to get create delete exception on top of change exception", (boolean)this.calendarManager.hasLastException());
        OXException expected = new OXException(11);
        OXException actual = (OXException)((Object)this.calendarManager.getLastException());
        TestsForCreatingChangeExceptions.assertTrue((String)("Expecting " + (Object)((Object)expected) + ", but got " + (Object)((Object)actual)), (boolean)expected.similarTo(actual));
    }

    public void testShouldFailChangeExceptionIfCreatingOneOnADeleteException() {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        this.calendarManager.insert(app);
        int recurrencePos = 2;
        this.calendarManager.createDeleteException(app, recurrencePos);
        Changes changes = new Changes();
        changes.put(207, (Object)recurrencePos);
        changes.put(201, (Object)this.D("3/1/2008 0:00", this.utc));
        changes.put(202, (Object)this.D("3/1/2008 24:00", this.utc));
        this.negativeAssertionOnChangeException.check(app, changes, OXCalendarExceptionCodes.UNABLE_TO_CALCULATE_POSITION.create());
    }

    public void testShouldSilentlyIgnoreNumberOfAttachmentsOnExceptionCreation() throws OXException {
        Appointment app = this.generateDailyAppointment();
        app.setOccurrence(3);
        this.calendarManager.insert(app);
        Appointment changeEx = this.calendarManager.createIdentifyingCopy(app);
        changeEx.setNumberOfAttachments(23);
        changeEx.setRecurrencePosition(2);
        changeEx.setTitle("Bla");
        changeEx.setRecurrenceType(0);
        this.calendarManager.update(changeEx);
        Appointment loaded = this.calendarManager.get(changeEx);
        TestsForCreatingChangeExceptions.assertEquals((int)0, (int)loaded.getNumberOfAttachments());
    }
}

