/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.bugtests;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.appointment.action.AppointmentInsertResponse;
import com.openexchange.ajax.appointment.action.DeleteRequest;
import com.openexchange.ajax.appointment.action.GetRequest;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.appointment.action.InsertRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.preferences.ServerUserSetting;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.test.FolderTestManager;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;
import org.xml.sax.SAXException;

public class Bug16089Test
extends AbstractAJAXSession {
    private FolderTestManager manager;
    private AJAXClient client;
    FolderObject folderObject1;
    Appointment appointment;
    TimeZone timezone;
    Calendar cal;

    public Bug16089Test(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.manager = new FolderTestManager(this.getClient());
        this.timezone = this.client.getValues().getTimeZone();
        this.cal = Calendar.getInstance(this.timezone);
        this.folderObject1 = new FolderObject();
        this.folderObject1.setFolderName("Bug16089Testfolder");
        this.folderObject1.setType(2);
        this.folderObject1.setParentFolderID(2);
        this.folderObject1.setModule(2);
        OCLPermission perm1 = new OCLPermission();
        perm1.setEntity(this.client.getValues().getUserId());
        perm1.setGroupPermission(false);
        perm1.setFolderAdmin(true);
        perm1.setAllPermission(128, 128, 128, 128);
        this.folderObject1.setPermissionsAsArray(new OCLPermission[]{perm1});
        this.manager.insertFolderOnServer(this.folderObject1);
        this.appointment = this.createAppointment();
    }

    public void testConfirmation() throws Exception {
        GetResponse getAppointmentResp = this.client.execute(new GetRequest(this.appointment));
        Appointment testApp = getAppointmentResp.getAppointment(this.timezone);
        Participant[] participants = testApp.getParticipants();
        boolean found = false;
        for (Participant p : participants) {
            ConfirmableParticipant[] confirmations;
            if (p.getIdentifier() != this.client.getValues().getUserId()) continue;
            found = true;
            for (ConfirmableParticipant c : confirmations = testApp.getConfirmations()) {
                if (c.getIdentifier() != this.client.getValues().getUserId()) continue;
                int ctx = this.getContextID(this.client);
                int publicConfig = ServerUserSetting.getInstance().getDefaultStatusPublic(ctx, this.client.getValues().getUserId());
                Bug16089Test.assertEquals((String)"Confirm status isn't equal with user setting.", (int)c.getConfirm(), (int)publicConfig);
            }
        }
        if (!found) {
            Bug16089Test.fail((String)"User not found as Participant");
        }
    }

    private int getContextID(AJAXClient client) throws IOException, SAXException {
        String url = "http://" + client.getHostname() + "/ajax/config/context_id?session=" + client.getSession().getId();
        GetMethodWebRequest request = new GetMethodWebRequest(url);
        WebResponse response = client.getSession().getConversation().getResponse((WebRequest)request);
        String text = response.getText();
        String sub = text.substring(8, text.length() - 1);
        return Integer.parseInt(sub);
    }

    @Override
    public void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.appointment, false));
        this.manager.cleanUp();
        super.tearDown();
    }

    private Appointment createAppointment() throws Exception {
        Calendar cal = (Calendar)this.cal.clone();
        cal.add(11, 1);
        Appointment app = new Appointment();
        app.setTitle("Bug16089Appointment");
        app.setIgnoreConflicts(true);
        app.setStartDate(cal.getTime());
        cal.add(11, 1);
        app.setEndDate(cal.getTime());
        app.setParentFolderID(this.folderObject1.getObjectID());
        app.setRecurrenceType(0);
        InsertRequest insApp = new InsertRequest(app, this.timezone, false);
        AppointmentInsertResponse execute = this.client.execute(insApp);
        execute.fillAppointment(app);
        return app;
    }
}

