/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.action;

import com.openexchange.ajax.appointment.action.AbstractAppointmentRequest;
import com.openexchange.ajax.appointment.action.GetParser;
import com.openexchange.ajax.appointment.action.GetResponse;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonInsertResponse;
import com.openexchange.groupware.container.Appointment;
import java.util.ArrayList;

public class GetRequest
extends AbstractAppointmentRequest<GetResponse> {
    private final int folderId;
    private final int objectId;
    private final int recurrencePosition;
    private final boolean failOnError;

    public GetRequest(int folderId, int objectId) {
        this(folderId, objectId, 0, true);
    }

    public GetRequest(int folderId, int objectId, boolean failOnError) {
        this(folderId, objectId, 0, failOnError);
    }

    public GetRequest(int folderId, int objectId, int recurrencePosition) {
        this(folderId, objectId, recurrencePosition, true);
    }

    public GetRequest(int folderId, int objectId, int recurrencePosition, boolean failOnError) {
        this.folderId = folderId;
        this.objectId = objectId;
        this.recurrencePosition = recurrencePosition;
        this.failOnError = failOnError;
    }

    public GetRequest(int folderId, CommonInsertResponse insert) {
        this(folderId, insert.getId());
    }

    public GetRequest(Appointment appointment) {
        this(appointment.getParentFolderID(), appointment.getObjectID());
    }

    public GetRequest(Appointment appointment, boolean failOnError) {
        this(appointment.getParentFolderID(), appointment.getObjectID(), failOnError);
    }

    @Override
    public Object getBody() {
        return null;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.GET;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        ArrayList<AJAXRequest.Parameter> parameterList = new ArrayList<AJAXRequest.Parameter>(4);
        parameterList.add(new AJAXRequest.Parameter("action", "get"));
        parameterList.add(new AJAXRequest.Parameter("folder", String.valueOf(this.folderId)));
        parameterList.add(new AJAXRequest.Parameter("id", String.valueOf(this.objectId)));
        if (this.recurrencePosition > 0) {
            parameterList.add(new AJAXRequest.Parameter("recurrence_position", String.valueOf(this.recurrencePosition)));
        }
        return parameterList.toArray(new AJAXRequest.Parameter[parameterList.size()]);
    }

    public GetParser getParser() {
        return new GetParser(this.failOnError);
    }
}

