/*
 * Decompiled with CFR 0.152.
 */
package org.json.hash;

public final class HashKey {
    private static final int DEFAULT_HASH = 5381;
    private static final int MULTIPLICATION_CONSTANT = 33;
    private final char[] value;
    private final int count;
    private final int hash;

    public static HashKey valueOf(String key) {
        return new HashKey(key);
    }

    private static int calcSafeHashCode(char[] val) {
        int h = 5381;
        int len = val.length;
        if (len > 0) {
            int fac = 33;
            int i = 0;
            while (i < len) {
                h = 33 * h + val[i];
                ++i;
            }
        }
        return h;
    }

    private HashKey(String key) {
        this.value = key.toCharArray();
        this.count = this.value.length;
        this.hash = HashKey.calcSafeHashCode(this.value);
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HashKey)) {
            return false;
        }
        HashKey other = (HashKey)obj;
        if (this.count != other.count) {
            return false;
        }
        int n = this.count;
        char[] v1 = this.value;
        char[] v2 = other.value;
        int i = 0;
        while (n-- != 0) {
            if (v1[i] == v2[i++]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return new String(this.value);
    }
}

