/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.user.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.api2.ContactInterfaceFactory;
import com.openexchange.contact.ContactService;
import com.openexchange.contacts.json.mapping.ContactMapper;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.ldap.User;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.user.UserService;
import com.openexchange.user.json.Utility;
import com.openexchange.user.json.actions.AbstractUserAction;
import com.openexchange.user.json.field.UserField;
import com.openexchange.user.json.mapping.UserMapper;
import com.openexchange.user.json.parser.ParsedUser;
import com.openexchange.user.json.parser.UserParser;
import com.openexchange.user.json.services.ServiceRegistry;
import java.util.Date;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

@Action(method=RequestMethod.PUT, name="update", description="Update a user.", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated user."), @Parameter(name="timestamp", type=Type.NUMBER, description="Timestamp of the updated user. If the user was modified after the specified timestamp, then the update must fail.")}, requestBody="User object as described in Common object data, Detailed contact data and Detailed user data. Only modified fields are present. Note: \"timezone\" and \"locale\" are the only fields from Detailed user data which are allowed to be updated.", responseDescription="Response with timestamp: An empty object.")
public final class UpdateAction
extends AbstractUserAction {
    public static final String ACTION = "update";
    private static ContactField[] CONTACT_FIELDS = new ContactField[]{ContactField.DISTRIBUTIONLIST, ContactField.LINKS, ContactField.CATEGORIES, ContactField.COLOR_LABEL, ContactField.PRIVATE_FLAG, ContactField.NUMBER_OF_ATTACHMENTS, ContactField.FOLDER_ID, ContactField.OBJECT_ID, ContactField.INTERNAL_USERID, ContactField.CREATED_BY, ContactField.CREATION_DATE, ContactField.MODIFIED_BY, ContactField.LAST_MODIFIED, ContactField.STATE_HOME, ContactField.COMPANY, ContactField.CELLULAR_TELEPHONE1, ContactField.STREET_HOME, ContactField.STREET_BUSINESS, ContactField.TELEPHONE_HOME1, ContactField.STATE_BUSINESS, ContactField.DISPLAY_NAME, ContactField.SUR_NAME, ContactField.CITY_HOME, ContactField.MIDDLE_NAME, ContactField.BIRTHDAY, ContactField.FAX_BUSINESS, ContactField.GIVEN_NAME, ContactField.POSTAL_CODE_HOME, ContactField.POSTAL_CODE_BUSINESS, ContactField.TELEPHONE_BUSINESS1, ContactField.CITY_BUSINESS};
    private static UserField[] USER_FIELDS = new UserField[]{UserField.ID, UserField.LOCALE, UserField.TIME_ZONE};

    public AJAXRequestResult perform(AJAXRequestData request, ServerSession session) throws OXException {
        String displayName;
        User parsedUser;
        Contact parsedUserContact;
        int id = UpdateAction.checkIntParameter("id", request);
        Date clientLastModified = new Date(UpdateAction.checkLongParameter("timestamp", request));
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        User storageUser = userService.getUser(id, session.getContext());
        int contactId = storageUser.getContactId();
        JSONObject jData = (JSONObject)request.getData();
        try {
            parsedUserContact = (Contact)ContactMapper.getInstance().deserialize(jData, (Enum[])CONTACT_FIELDS);
            jData.put(UserField.ID.getName(), id);
            parsedUser = (User)UserMapper.getInstance().deserialize(jData, USER_FIELDS);
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        ContactService contactService = (ContactService)ServiceRegistry.getInstance().getService(ContactService.class, true);
        if (parsedUserContact.containsDisplayName() && null != (displayName = parsedUserContact.getDisplayName())) {
            if (UpdateAction.isEmpty(displayName)) {
                parsedUserContact.removeDisplayName();
            } else {
                Contact storageContact = contactService.getUser((Session)session, id);
                if (displayName.equals(storageContact.getDisplayName())) {
                    parsedUserContact.removeDisplayName();
                }
            }
        }
        contactService.updateContact((Session)session, Integer.toString(6), Integer.toString(contactId), parsedUserContact, clientLastModified);
        String parsedTimeZone = parsedUser.getTimeZone();
        Locale parsedLocale = parsedUser.getLocale();
        if (null != parsedTimeZone || null != parsedLocale) {
            if (null == parsedTimeZone) {
                UserMapper.getInstance().get(UserField.TIME_ZONE).copy((Object)storageUser, (Object)parsedUser);
            }
            if (null == parsedLocale) {
                UserMapper.getInstance().get(UserField.LOCALE).copy((Object)storageUser, (Object)parsedUser);
            }
            userService.updateUser(parsedUser, session.getContext());
        }
        return new AJAXRequestResult((Object)new JSONObject(), parsedUserContact.getLastModified());
    }

    public AJAXRequestResult performOLD(AJAXRequestData request, ServerSession session) throws OXException {
        int id = UpdateAction.checkIntParameter("id", request);
        Date clientLastModified = new Date(UpdateAction.checkLongParameter("timestamp", request));
        UserService userService = (UserService)ServiceRegistry.getInstance().getService(UserService.class, true);
        User storageUser = userService.getUser(id, session.getContext());
        int contactId = storageUser.getContactId();
        JSONObject jData = (JSONObject)request.getData();
        Contact parsedUserContact = UserParser.parseUserContact(jData, Utility.getTimeZone(session.getUser().getTimeZone()));
        parsedUserContact.setObjectID(contactId);
        ContactInterface contactInterface = ((ContactInterfaceFactory)ServiceRegistry.getInstance().getService(ContactInterfaceFactory.class, true)).create(6, (Session)session);
        contactInterface.updateUserContact(parsedUserContact, clientLastModified);
        ParsedUser parsedUser = UserParser.parseUserData(jData, id);
        String parsedTimeZone = parsedUser.getTimeZone();
        Locale parsedLocale = parsedUser.getLocale();
        if (null != parsedTimeZone || null != parsedLocale) {
            if (null == parsedTimeZone) {
                parsedUser.setTimeZone(storageUser.getTimeZone());
            }
            if (null == parsedLocale) {
                parsedUser.setLocale(storageUser.getLocale());
            }
            userService.updateUser((User)parsedUser, session.getContext());
        }
        Date lastModified = contactInterface.getUserById(id, false).getLastModified();
        return new AJAXRequestResult((Object)new JSONObject(), lastModified);
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }
}

