/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.parser;

import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.subscribe.parser.AbstractMicroformatSAXHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class MicroformatAppointmentSAXHandler
extends AbstractMicroformatSAXHandler<CalendarDataObject> {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd, HH:mm:ss z");
    private final List<Exception> exceptions = new LinkedList<Exception>();

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) {
        String className = atts.getValue("class");
        if (null == className) {
            return;
        }
        if (className.equals("ox-appointment")) {
            this.newObjectEncountered();
        } else {
            this.currentlyReading = className.equals("title") ? "title" : (className.equals("note") ? "note" : (className.equals("location") ? "location" : (className.equals("startDate") ? "startDate" : (className.equals("endDate") ? "endDate" : null))));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        super.characters(ch, start, length);
        if (this.currentlyReading == null) {
            return;
        }
        if (this.currentlyReading.equals("ox-appointment")) {
            this.newObjectEncountered();
        } else if (this.currentlyReading.equals("title")) {
            ((CalendarDataObject)this.currentObject).setTitle(this.stringArray(ch, start, start + length));
        } else if (this.currentlyReading.equals("note")) {
            ((CalendarDataObject)this.currentObject).setNote(this.stringArray(ch, start, start + length));
        } else if (this.currentlyReading.equals("location")) {
            ((CalendarDataObject)this.currentObject).setLocation(this.stringArray(ch, start, start + length));
        } else if (this.currentlyReading.equals("startDate")) {
            try {
                ((CalendarDataObject)this.currentObject).setStartDate(dateFormat.parse(this.stringArray(ch, start, start + length)));
            }
            catch (ParseException e) {
                this.exceptions.add(e);
            }
        } else if (this.currentlyReading.equals("endDate")) {
            try {
                ((CalendarDataObject)this.currentObject).setEndDate(dateFormat.parse(this.stringArray(ch, start, start + length)));
            }
            catch (ParseException e) {
                this.exceptions.add(e);
            }
        }
    }

    @Override
    public CalendarDataObject instantiate() {
        return new CalendarDataObject();
    }
}

