/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.subscribe.internal;

import com.openexchange.api2.ContactSQLInterface;
import com.openexchange.api2.FinalContactInterface;
import com.openexchange.api2.RdbContactSQLImpl;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contact.ContactInterface;
import com.openexchange.groupware.contact.ContactInterfaceDiscoveryService;
import com.openexchange.groupware.contact.OverridingContactInterface;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.generic.TargetFolderDefinition;
import com.openexchange.groupware.search.Order;
import com.openexchange.log.LogFactory;
import com.openexchange.session.Session;
import com.openexchange.subscribe.TargetFolderSession;
import com.openexchange.subscribe.internal.FolderUpdaterStrategy;
import com.openexchange.subscribe.osgi.SubscriptionServiceRegistry;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;

public class ContactFolderMultipleUpdaterStrategy
implements FolderUpdaterStrategy<Contact> {
    private static final int SQL_INTERFACE = 1;
    private static final int TARGET = 2;
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ContactFolderMultipleUpdaterStrategy.class));
    private static final int[] COMPARISON_COLUMNS = Contact.CONTENT_COLUMNS;

    @Override
    public int calculateSimilarityScore(Contact original, Contact candidate, Object session) throws OXException {
        int score = 0;
        int threshhold = this.getThreshold(session);
        FinalContactInterface contactStore = (FinalContactInterface)this.getFromSession(1, session);
        if ((this.isset(original.getGivenName()) || this.isset(candidate.getGivenName())) && this.eq(original.getGivenName(), candidate.getGivenName())) {
            score += 5;
        }
        if ((this.isset(original.getSurName()) || this.isset(candidate.getSurName())) && this.eq(original.getSurName(), candidate.getSurName())) {
            score += 5;
        }
        if ((this.isset(original.getDisplayName()) || this.isset(candidate.getDisplayName())) && this.eq(original.getDisplayName(), candidate.getDisplayName())) {
            score += 10;
        }
        if (this.eq(original.getEmail1(), candidate.getEmail1())) {
            score += 10;
        }
        if (this.eq(original.getEmail2(), candidate.getEmail2())) {
            score += 10;
        }
        if (this.eq(original.getEmail3(), candidate.getEmail3())) {
            score += 10;
        }
        if (original.containsBirthday() && candidate.containsBirthday() && this.eq(original.getBirthday(), candidate.getBirthday())) {
            score += 5;
        }
        if (score < threshhold && original.equalsContentwise((Object)candidate)) {
            score += threshhold + 1;
        }
        try {
            if (score >= threshhold && original.equalsContentwise((Object)candidate)) {
                List idsOfAlreadyAssociatedContacts = contactStore.getAssociatedContacts(original);
                boolean alreadyAssociated = false;
                for (UUID uuid : idsOfAlreadyAssociatedContacts) {
                    Contact contact = contactStore.getContactByUUID(uuid);
                    if (!contact.equals((Object)candidate)) continue;
                    alreadyAssociated = true;
                }
                if (!alreadyAssociated) {
                    contactStore.associateTwoContacts(original, candidate);
                }
            }
        }
        catch (OXException e) {
            LOG.error((Object)e);
        }
        return score;
    }

    private boolean isset(String s) {
        return s == null || s.length() > 0;
    }

    protected boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void closeSession(Object session) throws OXException {
    }

    @Override
    public Collection<Contact> getData(TargetFolderDefinition target, Object session) throws OXException {
        RdbContactSQLImpl contacts = (RdbContactSQLImpl)this.getFromSession(1, session);
        int folderId = target.getFolderIdAsInt();
        int numberOfContacts = contacts.getNumberOfContacts(folderId);
        SearchIterator contactsInFolder = contacts.getContactsInFolder(folderId, 0, numberOfContacts, 1, Order.ASCENDING, null, COMPARISON_COLUMNS);
        ArrayList<Contact> retval = new ArrayList<Contact>();
        while (contactsInFolder.hasNext()) {
            retval.add((Contact)contactsInFolder.next());
        }
        return retval;
    }

    @Override
    public int getThreshold(Object session) throws OXException {
        return 9;
    }

    @Override
    public boolean handles(FolderObject folder) {
        return folder.getModule() == 3;
    }

    @Override
    public void save(Contact newElement, Object session) throws OXException {
        OverridingContactInterface contacts = (OverridingContactInterface)this.getFromSession(1, session);
        TargetFolderDefinition target = (TargetFolderDefinition)this.getFromSession(2, session);
        newElement.setParentFolderID(target.getFolderIdAsInt());
        newElement.setUserField20(UUID.randomUUID().toString());
        contacts.forceInsertContactObject(newElement);
    }

    private Object getFromSession(int key, Object session) {
        return ((Map)session).get(key);
    }

    @Override
    public Object startSession(TargetFolderDefinition target) throws OXException {
        HashMap<Integer, Object> userInfo = new HashMap<Integer, Object>();
        TargetFolderSession session = new TargetFolderSession(target);
        int folderID = target.getFolderIdAsInt();
        ContactInterface contactInterface = ((ContactInterfaceDiscoveryService)SubscriptionServiceRegistry.getInstance().getService(ContactInterfaceDiscoveryService.class)).newContactInterface(folderID, (Session)session);
        userInfo.put(1, contactInterface);
        userInfo.put(2, target);
        return userInfo;
    }

    @Override
    public void update(Contact original, Contact update, Object session) throws OXException {
        int[] columns;
        ContactSQLInterface contactStore = (ContactSQLInterface)this.getFromSession(1, session);
        for (int field : columns = Contact.CONTENT_COLUMNS) {
            if (original.get(field) != null || update.get(field) == null) continue;
            original.set(field, update.get(field));
        }
        contactStore.updateContactObject(original, original.getParentFolderID(), original.getLastModified());
    }
}

