/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.container.CommonObject;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorException;
import com.openexchange.webdav.xml.FolderChildWriter;
import com.openexchange.webdav.xml.XmlServlet;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jdom2.Content;
import org.jdom2.Element;

public abstract class CommonWriter
extends FolderChildWriter {
    protected void writeCommonElements(CommonObject commonobject, Element e_prop) throws OXException, SearchIteratorException, UnsupportedEncodingException {
        if (commonobject.containsParentFolderID() && commonobject.getParentFolderID() == 0) {
            CommonWriter.addElement("personal_folder_id", commonobject.getParentFolderID(), e_prop);
            commonobject.setParentFolderID(-1);
        }
        if (commonobject.getNumberOfAttachments() > 0) {
            this.writeElementAttachments(commonobject, e_prop);
        }
        this.writeFolderChildElements(commonobject, e_prop);
        CommonWriter.addElement("categories", commonobject.getCategories(), e_prop);
        CommonWriter.addElement("private_flag", commonobject.getPrivateFlag(), e_prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeElementAttachments(CommonObject commonobject, Element e_prop) throws OXException, SearchIteratorException, UnsupportedEncodingException {
        Element e_attachments = new Element("attachments", XmlServlet.NS);
        SearchIterator it = null;
        try {
            XmlServlet.attachmentBase.startTransaction();
            TimedResult<AttachmentMetadata> tResult = XmlServlet.attachmentBase.getAttachments(commonobject.getParentFolderID(), commonobject.getObjectID(), this.getModule(), this.ctx, this.userObj, UserConfigurationStorage.getInstance().getUserConfigurationSafe(this.sessionObj.getUserId(), this.ctx));
            it = tResult.results();
            while (it.hasNext()) {
                AttachmentMetadata attachmentMeta = (AttachmentMetadata)it.next();
                Element e = new Element("attachment", XmlServlet.NS);
                String filename = attachmentMeta.getFilename();
                if (filename != null) {
                    filename = URLEncoder.encode(filename, "UTF-8");
                }
                e.addContent(CommonWriter.correctCharacterData(filename));
                e.setAttribute("id", Integer.toString(attachmentMeta.getId()), XmlServlet.NS);
                e.setAttribute("last_modified", Long.toString(attachmentMeta.getCreationDate().getTime()), XmlServlet.NS);
                e.setAttribute("mimetype", attachmentMeta.getFileMIMEType(), XmlServlet.NS);
                e.setAttribute("rtf_flag", String.valueOf(attachmentMeta.getRtfFlag()), XmlServlet.NS);
                e_attachments.addContent((Content)e);
            }
        }
        finally {
            if (it != null) {
                it.close();
            }
            XmlServlet.attachmentBase.commit();
            XmlServlet.attachmentBase.finish();
        }
        e_prop.addContent((Content)e_attachments);
    }

    protected abstract int getModule();
}

