/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.protocol;

import com.openexchange.exception.Category;
import com.openexchange.exception.LogLevel;
import com.openexchange.webdav.protocol.WebdavPath;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import java.util.Collection;

public class WebdavMultistatusException
extends WebdavProtocolException {
    private static final long serialVersionUID = 1L;
    private static final WebdavProtocolException.Code CODE = WebdavProtocolException.Code.GENERAL_ERROR;
    private final WebdavProtocolException[] exceptions;

    public static WebdavMultistatusException create(WebdavPath url, WebdavProtocolException ... exceptions) {
        WebdavMultistatusException ret;
        Category category = CODE.getCategory();
        if (category.getLogLevel().implies(LogLevel.DEBUG)) {
            ret = new WebdavMultistatusException(url, exceptions, CODE.getNumber(), CODE.getMessage(), null, new Object[0]);
        } else {
            ret = new WebdavMultistatusException(url, exceptions, CODE.getNumber(), Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "An error occurred. Please try again later." : "A severe error occurred.", null, new Object[0]);
            ret.setLogMessage(CODE.getMessage());
        }
        ret.addCategory(category);
        ret.setPrefix(CODE.getPrefix());
        return ret;
    }

    public static WebdavMultistatusException create(WebdavPath url, Collection<WebdavProtocolException> exceptions) {
        WebdavMultistatusException ret;
        Category category = CODE.getCategory();
        if (category.getLogLevel().implies(LogLevel.DEBUG)) {
            ret = new WebdavMultistatusException(url, exceptions, CODE.getNumber(), CODE.getMessage(), null, new Object[0]);
        } else {
            ret = new WebdavMultistatusException(url, exceptions, CODE.getNumber(), Category.EnumType.TRY_AGAIN.equals((Object)category.getType()) ? "An error occurred. Please try again later." : "A severe error occurred.", null, new Object[0]);
            ret.setLogMessage(CODE.getMessage());
        }
        ret.addCategory(category);
        ret.setPrefix(CODE.getPrefix());
        return ret;
    }

    protected WebdavMultistatusException(WebdavPath url, WebdavProtocolException[] exceptions, int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(207, url, code, displayMessage, cause, displayArgs);
        this.exceptions = exceptions;
    }

    protected WebdavMultistatusException(WebdavPath url, Collection<WebdavProtocolException> exceptions, int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(207, url, code, displayMessage, cause, displayArgs);
        this.exceptions = exceptions.toArray(new WebdavProtocolException[exceptions.size()]);
    }

    public WebdavProtocolException[] getExceptions() {
        return this.exceptions;
    }
}

