/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action.behaviour;

import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.behaviour.RequestSpecificBehaviourRegistry;

public class BehaviourLookup {
    private static final BehaviourLookup INSTANCE = new BehaviourLookup();
    private final ThreadLocal<WebdavRequest> requestHolder = new ThreadLocal();
    private RequestSpecificBehaviourRegistry registry = null;

    public static BehaviourLookup getInstance() {
        return INSTANCE;
    }

    public void setRequest(WebdavRequest req) {
        this.requestHolder.set(req);
    }

    public void unsetRequest() {
        this.requestHolder.set(null);
    }

    public void setRegistry(RequestSpecificBehaviourRegistry reg) {
        this.registry = reg;
    }

    public <T> T get(Class<T> clazz) {
        if (null == this.registry) {
            return null;
        }
        WebdavRequest req = this.requestHolder.get();
        if (req == null) {
            return null;
        }
        return this.registry.get(req, clazz);
    }
}

