/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.timeout;

import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class Timeout
implements Runnable {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(Timeout.class));
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Thread target;
    private long timeoutMillis;
    private final Thread watcher;
    private boolean loop;
    private boolean enabled;

    public Timeout(long timeoutMillis) {
        this(Thread.currentThread(), timeoutMillis);
    }

    public Timeout(Thread target, long timeoutMillis) {
        this.target = target;
        this.timeoutMillis = timeoutMillis;
        this.enabled = true;
        this.watcher = new Thread(this);
        this.watcher.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done() {
        this.lock.lock();
        try {
            this.loop = false;
            this.enabled = false;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.lock.lock();
        try {
            this.loop = true;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset(long timeoutMillis) {
        this.lock.lock();
        try {
            this.timeoutMillis = timeoutMillis;
            this.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.lock.lock();
        try {
            Thread current = Thread.currentThread();
            current.setPriority(10);
            if (this.enabled) {
                do {
                    this.loop = false;
                    try {
                        this.condition.await(this.timeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                } while (this.enabled && this.loop);
            }
            if (this.enabled && this.target.isAlive()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Timeout.run(): Stopping thread " + this.target.getName()));
                }
                this.target.interrupt();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

