/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.impl;

import com.drew.imaging.ImageMetadataReader;
import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.jpeg.JpegDirectory;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ResampleOp;
import com.openexchange.exception.Log;
import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.images.ImageScalingService;
import com.openexchange.tools.images.ScaleType;
import com.openexchange.tools.images.impl.AutoDimensionConstrain;
import com.openexchange.tools.images.impl.ContainDimensionConstrain;
import com.openexchange.tools.images.impl.CoverDimensionConstrain;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.imageio.ImageIO;

public class JavaImageScalingService
implements ImageScalingService {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(JavaImageScalingService.class));
    private static final String CT_JPEG = "image/jpeg";
    private static final String CT_JPG = "image/jpg";
    private static final String CT_TIFF = "image/tiff";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream scale(InputStream pictureData, int maxWidth, int maxHeight, ScaleType scaleType) throws IOException {
        DimensionConstrain constrain;
        BufferedImage image;
        if (null == pictureData) {
            throw new IOException("pictureData == null!");
        }
        try {
            image = ImageIO.read(pictureData);
        }
        finally {
            Streams.close((Closeable)pictureData);
        }
        switch (scaleType) {
            case COVER: {
                constrain = new CoverDimensionConstrain(maxWidth, maxHeight);
                break;
            }
            case CONTAIN: {
                constrain = new ContainDimensionConstrain(maxWidth, maxHeight);
                break;
            }
            default: {
                constrain = new AutoDimensionConstrain(maxWidth, maxHeight);
            }
        }
        ResampleOp op = new ResampleOp(constrain);
        BufferedImage scaled = op.filter(image, null);
        UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream(8192);
        if (!ImageIO.write((RenderedImage)scaled, "png", (OutputStream)baos)) {
            throw new IOException("Couldn't scale image");
        }
        return Streams.newByteArrayInputStream((byte[])baos.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream rotateAccordingExif(InputStream pictureData, String contentType) throws IOException, OXException {
        String fileType;
        String lcct;
        String string = lcct = null == contentType ? "" : contentType.toLowerCase(Locale.ENGLISH);
        if (lcct.startsWith(CT_JPEG)) {
            fileType = "jpeg";
        } else if (lcct.startsWith(CT_JPG)) {
            fileType = "jpg";
        } else if (lcct.startsWith(CT_TIFF)) {
            fileType = "tiff";
        } else {
            return pictureData;
        }
        if (null == pictureData) {
            return pictureData;
        }
        ManagedFile managedFile = null;
        try {
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            managedFile = mfm.createManagedFile(pictureData);
            ImageInformation imageInformation = this.readImageInformation(managedFile.getInputStream());
            if (imageInformation == null) {
                ByteArrayInputStream byteArrayInputStream = Streams.newByteArrayInputStream((InputStream)managedFile.getInputStream());
                return byteArrayInputStream;
            }
            AffineTransform exifTransformation = this.getExifTransformation(imageInformation);
            if (exifTransformation == null) {
                ByteArrayInputStream byteArrayInputStream = Streams.newByteArrayInputStream((InputStream)managedFile.getInputStream());
                return byteArrayInputStream;
            }
            AffineTransformOp op = new AffineTransformOp(exifTransformation, 3);
            BufferedImage image = ImageIO.read(managedFile.getInputStream());
            ColorModel cm = image.getType() == 10 ? image.getColorModel() : null;
            BufferedImage destinationImage = op.createCompatibleDestImage(image, cm);
            Graphics2D g = destinationImage.createGraphics();
            g.setBackground(Color.WHITE);
            g.clearRect(0, 0, destinationImage.getWidth(), destinationImage.getHeight());
            destinationImage = op.filter(image, destinationImage);
            UnsynchronizedByteArrayOutputStream baos = new UnsynchronizedByteArrayOutputStream();
            if (!ImageIO.write((RenderedImage)destinationImage, fileType, (OutputStream)baos)) {
                throw new IOException("Couldn't rotate image");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            if (managedFile != null) {
                managedFile.delete();
            }
        }
    }

    @Override
    public InputStream crop(InputStream pictureData, int x, int y, int width, int height, String contentType) throws IOException {
        BufferedImage sourceImage = ImageIO.read(pictureData);
        BufferedImage targetImage = this.crop(sourceImage, x, y, width, height);
        UnsynchronizedByteArrayOutputStream outputStream = new UnsynchronizedByteArrayOutputStream();
        if (!ImageIO.write((RenderedImage)targetImage, JavaImageScalingService.getImageFormat(contentType), (OutputStream)outputStream)) {
            throw new IOException("Couldn't write cropped image");
        }
        outputStream.flush();
        return new ByteArrayInputStream(outputStream.toByteArray());
    }

    @Override
    public BufferedImage crop(BufferedImage sourceImage, int x, int y, int width, int height) throws IOException {
        BufferedImage targetImage = null;
        if (0 <= x && sourceImage.getWidth() > x && sourceImage.getWidth() >= x + width && 0 <= y && sourceImage.getHeight() > y && sourceImage.getHeight() >= y + height) {
            targetImage = sourceImage.getSubimage(x, y, width, height);
        } else {
            targetImage = new BufferedImage(width, height, sourceImage.getType());
            Graphics2D graphics = targetImage.createGraphics();
            graphics.setBackground(new Color(255, 255, 255, 0));
            graphics.clearRect(0, 0, width, height);
            graphics.drawImage((Image)sourceImage, x, y, null);
        }
        return targetImage;
    }

    private static String getImageFormat(String contentType) {
        return null != contentType && contentType.toLowerCase().startsWith("image/") ? contentType.substring(6) : contentType;
    }

    private AffineTransform getExifTransformation(ImageInformation info) {
        AffineTransform t = new AffineTransform();
        switch (info.orientation) {
            default: {
                return null;
            }
            case 2: {
                t.scale(-1.0, 1.0);
                t.translate(-info.width, 0.0);
                break;
            }
            case 3: {
                t.translate(info.width, info.height);
                t.rotate(Math.PI);
                break;
            }
            case 4: {
                t.scale(1.0, -1.0);
                t.translate(0.0, -info.height);
                break;
            }
            case 5: {
                t.rotate(-1.5707963267948966);
                t.scale(-1.0, 1.0);
                break;
            }
            case 6: {
                t.translate(info.height, 0.0);
                t.rotate(1.5707963267948966);
                break;
            }
            case 7: {
                t.scale(-1.0, 1.0);
                t.translate(-info.height, 0.0);
                t.translate(0.0, info.width);
                t.rotate(4.71238898038469);
                break;
            }
            case 8: {
                t.translate(0.0, info.width);
                t.rotate(4.71238898038469);
            }
        }
        return t;
    }

    public ImageInformation readImageInformation(InputStream imageFile) throws IOException {
        int orientation = 1;
        int width = 0;
        int height = 0;
        try {
            JpegDirectory jpegDirectory;
            Metadata metadata = ImageMetadataReader.readMetadata((BufferedInputStream)new BufferedInputStream(imageFile), (boolean)false);
            Directory directory = metadata.getDirectory(ExifIFD0Directory.class);
            if (null != directory) {
                orientation = directory.getInt(274);
            }
            if (null != (jpegDirectory = (JpegDirectory)metadata.getDirectory(JpegDirectory.class))) {
                width = jpegDirectory.getImageWidth();
                height = jpegDirectory.getImageHeight();
            }
        }
        catch (MetadataException e) {
            LOG.debug((Object)"Unable to retrieve image information.", (Throwable)e);
            return null;
        }
        catch (ImageProcessingException e) {
            LOG.debug((Object)"Unable to retrieve image information.", (Throwable)e);
            return null;
        }
        return new ImageInformation(orientation, width, height);
    }

    private class ImageInformation {
        public final int orientation;
        public final int width;
        public final int height;

        public ImageInformation(int orientation, int width, int height) {
            this.orientation = orientation;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return String.format("%dx%d,%d", this.width, this.height, this.orientation);
        }
    }
}

