/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.java.util.UUIDs;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.logging.Log;

public class HashingFileStorage
implements FileStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(HashingFileStorage.class));
    private final File storage;

    public HashingFileStorage(File storage) {
        this.storage = storage;
    }

    protected File file(String identifier) {
        return new File(this.storage, identifier);
    }

    @Override
    public boolean deleteFile(String identifier) throws OXException {
        return this.file(identifier).delete();
    }

    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        HashSet<String> notDeleted = new HashSet<String>();
        for (String identifier : identifiers) {
            if (this.deleteFile(identifier)) continue;
            notDeleted.add(identifier);
        }
        return notDeleted;
    }

    @Override
    public InputStream getFile(String name) throws OXException {
        try {
            return new BufferedInputStream(new FileInputStream(this.file(name)));
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(name);
        }
    }

    @Override
    public SortedSet<String> getFileList() throws OXException {
        final TreeSet<String> files = new TreeSet<String>();
        final int beginIndex = this.storage.getAbsolutePath().length() + 1;
        this.visit(new Visitor(){

            @Override
            public void visit(File f) {
                if (f.isFile()) {
                    files.add(f.getAbsolutePath().substring(beginIndex));
                }
            }
        });
        return files;
    }

    @Override
    public long getFileSize(String name) throws OXException {
        return this.file(name).length();
    }

    @Override
    public String getMimeType(String name) throws OXException {
        MimetypesFileTypeMap map = new MimetypesFileTypeMap();
        return map.getContentType(this.file(name));
    }

    @Override
    public void recreateStateFile() throws OXException {
    }

    @Override
    public void remove() throws OXException {
        this.visit(new Visitor(){

            @Override
            public void visit(File f) {
                f.delete();
            }
        });
    }

    @Override
    public String saveNewFile(InputStream file) throws OXException {
        String[] filestorePath = this.generateName();
        File path = new File(this.storage, filestorePath[0]);
        if (!(path.exists() || path.mkdirs() || path.exists())) {
            throw FileStorageCodes.CREATE_DIR_FAILED.create(path.toString());
        }
        FilterOutputStream bufOut = null;
        BufferedInputStream bufIn = null;
        File filePath = new File(path, filestorePath[1]);
        try {
            bufIn = new BufferedInputStream(file);
            bufOut = new BufferedOutputStream(new FileOutputStream(filePath));
            int i = 0;
            while ((i = bufIn.read()) != -1) {
                ((BufferedOutputStream)bufOut).write(i);
            }
        }
        catch (FileNotFoundException e) {
            throw FileStorageCodes.FILE_NOT_FOUND.create(filePath.toString());
        }
        catch (IOException e) {
            throw FileStorageCodes.IOERROR.create(e.toString());
        }
        finally {
            if (bufIn != null) {
                try {
                    bufIn.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (bufOut != null) {
                try {
                    bufOut.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        return filestorePath[0] + "/" + filestorePath[1];
    }

    public String[] generateName() {
        int i;
        String uuid = UUIDs.getUnformattedString((UUID)UUID.randomUUID());
        String prefix = Integer.toHexString(uuid.hashCode());
        StringBuilder b = new StringBuilder();
        for (i = 0; i < prefix.length() && i < 6; ++i) {
            b.append(prefix.charAt(i));
            if (i % 2 != 1 || i <= 0) continue;
            b.append('/');
        }
        while (i < 6) {
            b.append('0');
            if (i % 2 == 1 && i > 0) {
                b.append('/');
            }
            ++i;
        }
        b.setLength(b.length() - 1);
        return new String[]{b.toString(), uuid};
    }

    @Override
    public boolean stateFileIsCorrect() throws OXException {
        return true;
    }

    protected void visit(Visitor visitor) {
        this.recurse(this.storage, visitor);
    }

    protected void recurse(File f, Visitor visitor) {
        if (f.isFile()) {
            visitor.visit(f);
            return;
        }
        File[] files = f.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            this.recurse(file, visitor);
        }
        visitor.visit(f);
    }

    private static interface Visitor {
        public void visit(File var1);
    }
}

