/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.internal;

import com.openexchange.exception.OXException;
import com.openexchange.tools.file.external.FileStorage;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.internal.CompositingFileStorage;
import com.openexchange.tools.file.internal.HashingFileStorage;
import com.openexchange.tools.file.internal.LocalFileStorage;
import java.io.File;
import java.net.URI;

public class CompositeFileStorageFactory
implements FileStorageFactory {
    @Override
    public FileStorage getFileStorage(URI uri) throws OXException {
        LocalFileStorage standardFS = new LocalFileStorage(uri);
        HashingFileStorage hashedFS = new HashingFileStorage(new File(new File(uri), "hashed"));
        CompositingFileStorage cStorage = new CompositingFileStorage();
        cStorage.addStore(standardFS);
        cStorage.addStore("hashed", hashedFS);
        cStorage.setSavePrefix("hashed");
        return cStorage;
    }
}

