/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.services;

import com.openexchange.exception.OXException;
import com.openexchange.server.ServiceExceptionCode;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ServerServiceRegistry {
    private static final ServerServiceRegistry REGISTRY = new ServerServiceRegistry();
    private final Map<Class<?>, Object> services = new ConcurrentHashMap();

    public static ServerServiceRegistry getInstance() {
        return REGISTRY;
    }

    private ServerServiceRegistry() {
    }

    public void clearRegistry() {
        this.services.clear();
    }

    public void removeService(Class<?> clazz) {
        this.services.remove(clazz);
    }

    public <S> void addService(Class<? extends S> clazz, S service) {
        this.services.put(clazz, service);
    }

    public <S> void addService(S service) {
        this.services.put(service.getClass(), service);
    }

    public <S> S getService(Class<? extends S> clazz) {
        Object service = this.services.get(clazz);
        if (null == service) {
            return null;
        }
        return clazz.cast(service);
    }

    public <S> S getService(Class<? extends S> clazz, boolean failOnError) throws OXException {
        Object service = this.services.get(clazz);
        if (null == service) {
            if (failOnError) {
                throw ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{clazz.getName()});
            }
            return null;
        }
        return clazz.cast(service);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("Server service registry:\n");
        if (this.services.isEmpty()) {
            sb.append("<empty>");
        } else {
            Iterator<Map.Entry<Class<?>, Object>> iter = this.services.entrySet().iterator();
            while (true) {
                Map.Entry<Class<?>, Object> e = iter.next();
                sb.append(e.getKey().getName()).append(": ").append(e.getValue().toString());
                if (!iter.hasNext()) break;
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

