/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.report.internal;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.report.internal.LoginCounterMBean;
import com.openexchange.report.internal.ReportingMBean;
import com.openexchange.report.internal.Tools;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.management.MBeanException;
import org.apache.commons.logging.Log;

public class LoginCounter
implements LoginCounterMBean {
    private final Log logger = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReportingMBean.class));
    private String wildcard;

    @Override
    public int getNumberOfLogins(Date startDate, Date endDate) throws MBeanException {
        Pattern pattern;
        if (this.wildcard != null) {
            try {
                pattern = Pattern.compile(LoginCounter.wildcardToRegex("client:" + this.wildcard));
            }
            catch (PatternSyntaxException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new MBeanException(e, "Couldn't compile regex pattern.");
            }
        } else {
            pattern = null;
        }
        int counter = 0;
        DatabaseService dbService = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Map<String, Integer> schemaMap = null;
        try {
            schemaMap = Tools.getAllSchemata(this.logger);
        }
        catch (OXException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        catch (SQLException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            Exception wrapMe = new Exception(e.getMessage());
            throw new MBeanException(wrapMe, e.getMessage());
        }
        for (String schema : schemaMap.keySet()) {
            Connection connection;
            int readPool = schemaMap.get(schema);
            try {
                connection = dbService.get(readPool, schema);
            }
            catch (OXException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new MBeanException((Exception)((Object)e), "Couldn't get connection to schema " + schema + " in pool " + readPool + ".");
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = connection.prepareStatement("SELECT name, value FROM user_attribute WHERE name LIKE ?");
                stmt.setString(1, StringCollection.prepareForSearch("client:*", false, true));
                rs = stmt.executeQuery();
                Date lastLogin = new Date();
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (pattern != null && !pattern.matcher(name).matches()) continue;
                    try {
                        lastLogin.setTime(Long.parseLong(rs.getString(2)));
                        if (!lastLogin.after(startDate) || !lastLogin.before(endDate)) continue;
                        ++counter;
                    }
                    catch (NumberFormatException e) {
                        this.logger.warn((Object)"Client value is not a number.", (Throwable)e);
                    }
                }
            }
            catch (SQLException e) {
                try {
                    this.logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new MBeanException(e, e.getMessage());
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(rs, stmt);
                    dbService.back(readPool, connection);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(rs, stmt);
            dbService.back(readPool, connection);
        }
        return counter;
    }

    @Override
    public void setDeviceWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    @Override
    public String getDeviceWildcard() {
        return this.wildcard;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int len = wildcard.length();
        for (int i = 0; i < len; ++i) {
            char c = wildcard.charAt(i);
            if (c == '*') {
                s.append(".*");
                continue;
            }
            if (c == '?') {
                s.append('.');
                continue;
            }
            if (c == '(' || c == ')' || c == '[' || c == ']' || c == '$' || c == '^' || c == '.' || c == '{' || c == '}' || c == '|' || c == '\\') {
                s.append('\\');
                s.append(c);
                continue;
            }
            s.append(c);
        }
        s.append('$');
        return s.toString();
    }
}

