/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.pooling;

import com.openexchange.log.LogFactory;
import com.openexchange.pooling.ExhaustedActions;
import com.openexchange.pooling.Pool;
import com.openexchange.pooling.PoolImplData;
import com.openexchange.pooling.PoolableLifecycle;
import com.openexchange.pooling.PooledData;
import com.openexchange.pooling.PoolingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;

public class ReentrantLockPool<T>
implements Pool<T>,
Runnable {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReentrantLockPool.class));
    private final int minIdle;
    private final int maxIdle;
    private final long maxIdleTime;
    private final int maxActive;
    private final long maxWait;
    private final long maxLifeTime;
    private final ExhaustedActions exhaustedAction;
    private final boolean testOnActivate;
    private final boolean testOnDeactivate;
    private final boolean testOnIdle;
    private final boolean testThreads;
    private final PoolImplData<T> data = new PoolImplData();
    private final PoolableLifecycle<T> lifecycle;
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition idleAvailable = this.lock.newCondition();
    private final long[] useTimes = new long[1000];
    private boolean running = true;
    private int useTimePointer;
    private final AtomicBoolean brokenCreate = new AtomicBoolean();
    private long maxUseTime;
    private long minUseTime = Long.MAX_VALUE;
    private int numBroken;
    private long lastWarning;
    private final Runnable cleaner = new Runnable(){

        @Override
        public void run() {
            try {
                Thread thread = Thread.currentThread();
                String origName = thread.getName();
                thread.setName("PoolCleaner");
                ReentrantLockPool.this.run();
                thread.setName(origName);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    };

    public ReentrantLockPool(PoolableLifecycle<T> lifecycle, Config config) {
        this.minIdle = Math.max(0, config.minIdle);
        this.maxIdle = config.maxIdle;
        this.maxIdleTime = config.maxIdleTime;
        this.maxActive = config.maxActive;
        this.maxWait = config.maxWait;
        this.maxLifeTime = config.maxLifeTime;
        this.exhaustedAction = config.exhaustedAction;
        this.testOnActivate = config.testOnActivate;
        this.testOnDeactivate = config.testOnDeactivate;
        this.testOnIdle = config.testOnIdle;
        this.testThreads = config.testThreads;
        this.lifecycle = lifecycle;
        try {
            this.ensureMinIdle();
        }
        catch (PoolingException e) {
            LOG.error((Object)"Problem while creating initial objects.", (Throwable)e);
        }
    }

    protected final PoolableLifecycle<T> getLifecycle() {
        return this.lifecycle;
    }

    @Override
    public void back(T pooled) throws PoolingException {
        if (null == pooled) {
            throw new PoolingException("A null reference was returned to pool.");
        }
        this.back(pooled, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean back(T pooled, boolean decrementActive) throws PoolingException {
        boolean poolable;
        PooledData<T> metaData;
        long startTime = System.currentTimeMillis();
        if (decrementActive) {
            this.lock.lock();
            try {
                metaData = this.data.getActive(pooled);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            metaData = new PooledData<T>(pooled);
        }
        if (null == metaData) {
            throw new PoolingException("Object \"" + pooled + "\" does not belong to this pool.");
        }
        if (this.running) {
            poolable = this.testOnDeactivate ? this.lifecycle.validate(metaData) : this.lifecycle.deactivate(metaData);
            if (!poolable) {
                ++this.numBroken;
            }
            poolable &= this.maxLifeTime <= 0L || metaData.getLiveTime() < this.maxLifeTime;
        } else {
            poolable = false;
        }
        boolean destroy = !poolable;
        this.lock.lock();
        try {
            if (this.testThreads) {
                this.data.removeByThread(metaData);
            }
            long useTime = metaData.getTimeDiff();
            this.useTimes[this.useTimePointer++] = useTime;
            this.useTimePointer %= this.useTimes.length;
            this.maxUseTime = Math.max(this.maxUseTime, useTime);
            this.minUseTime = Math.min(this.minUseTime, useTime);
            metaData.resetTrace();
            metaData.touch();
            if (decrementActive) {
                this.data.removeActive(metaData);
            }
            this.idleAvailable.signal();
            if (this.maxIdle > 0 && this.data.numIdle() >= this.maxIdle) {
                destroy = true;
            } else if (poolable) {
                this.data.addIdle(metaData);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (destroy) {
            LOG.trace((Object)"Destroying object.");
            this.lifecycle.destroy(metaData.getPooled());
        }
        LOG.trace((Object)("Back time: " + ReentrantLockPool.getWaitTime(startTime)));
        return !destroy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws PoolingException {
        long startTime = System.currentTimeMillis();
        block25: while (this.running) {
            PooledData<T> retval;
            boolean created;
            block38: {
                created = false;
                this.lock.lock();
                try {
                    Thread thread;
                    PooledData<T> other;
                    if (this.testThreads && (other = this.data.getByThread(thread = Thread.currentThread())) != null && thread.equals(other.getThread()) && LOG.isDebugEnabled()) {
                        PoolingException e = new PoolingException("Found thread using two objects. First get.");
                        if (null != other.getTrace()) {
                            e.setStackTrace(other.getTrace());
                        }
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                        e = new PoolingException("Found thread using two objects. Second get.");
                        e.fillInStackTrace();
                        LOG.debug((Object)e.getMessage(), (Throwable)e);
                    }
                    if (null == (retval = this.data.popIdle()) && this.maxActive > 0 && this.data.numActive() >= this.maxActive) {
                        switch (this.exhaustedAction) {
                            case GROW: {
                                break;
                            }
                            case FAIL: {
                                throw new PoolingException("Pool exhausted.");
                            }
                            case BLOCK: {
                                boolean writeWarning;
                                String threadName = Thread.currentThread().getName();
                                boolean bl = writeWarning = System.currentTimeMillis() > this.lastWarning + 60000L;
                                if (writeWarning) {
                                    this.lastWarning = System.currentTimeMillis();
                                    PoolingException warn = new PoolingException("Thread " + threadName + " is sent to sleep until an object in the pool is available. " + this.data.numActive() + " objects are already in use.");
                                    LOG.warn((Object)warn.getMessage(), (Throwable)warn);
                                }
                                long sleepStartTime = System.currentTimeMillis();
                                boolean timedOut = false;
                                try {
                                    if (this.maxWait > 0L) {
                                        timedOut = !this.idleAvailable.await(this.maxWait - ReentrantLockPool.getWaitTime(startTime), TimeUnit.MILLISECONDS);
                                    } else {
                                        this.idleAvailable.await();
                                    }
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                    LOG.error((Object)("Thread " + threadName + " was interrupted."), (Throwable)e);
                                }
                                if (writeWarning) {
                                    PoolingException warn = new PoolingException("Thread " + threadName + " slept for " + (System.currentTimeMillis() - sleepStartTime) + "ms.");
                                    LOG.warn((Object)warn.getMessage(), (Throwable)warn);
                                }
                                if (!timedOut) continue block25;
                                this.idleAvailable.signal();
                                throw new PoolingException("Wait time exceeded. Active: " + this.data.numActive() + ", Idle: " + this.data.numIdle() + ", Waiting: " + this.lock.getWaitQueueLength(this.idleAvailable) + ", Time: " + ReentrantLockPool.getWaitTime(startTime));
                            }
                            default: {
                                throw new IllegalStateException("Unknown exhausted action: " + (Object)((Object)this.exhaustedAction));
                            }
                        }
                    }
                    if (null != retval) break block38;
                    if (this.brokenCreate.get() && this.data.getCreating() > 0) {
                        throw new PoolingException("Not trying to create a pooled object in broken create state.");
                    }
                    this.data.addCreating();
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
            }
            if (null == retval) {
                T pooled;
                LOG.trace((Object)"Creating object.");
                try {
                    pooled = this.lifecycle.create();
                    this.brokenCreate.set(false);
                }
                catch (Exception e) {
                    this.brokenCreate.set(true);
                    this.lock.lock();
                    try {
                        this.data.removeCreating();
                        this.idleAvailable.signal();
                    }
                    finally {
                        this.lock.unlock();
                    }
                    throw new PoolingException("Cannot create pooled object.", e);
                }
                retval = new PooledData<T>(pooled);
                this.lock.lock();
                try {
                    this.data.addActive(retval);
                    this.data.removeCreating();
                }
                finally {
                    this.lock.unlock();
                }
                created = true;
            }
            if (!this.lifecycle.activate(retval) || this.testOnActivate && !this.lifecycle.validate(retval)) {
                this.lock.lock();
                try {
                    this.data.removeActive(retval);
                    this.idleAvailable.signal();
                }
                finally {
                    this.lock.unlock();
                }
                ++this.numBroken;
                this.lifecycle.destroy(retval.getPooled());
                if (!created) continue;
                throw new PoolingException("Problem while creating new object.");
            }
            Thread thread = Thread.currentThread();
            retval.setThread(thread);
            retval.touch();
            if (this.testThreads) {
                retval.setTrace(thread.getStackTrace());
                this.lock.lock();
                try {
                    this.data.addByThread(retval);
                }
                finally {
                    this.lock.unlock();
                }
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Get time: " + ReentrantLockPool.getWaitTime(startTime) + ", Created: " + created));
            }
            return retval.getPooled();
        }
        throw new PoolingException("Pool has been stopped.");
    }

    private static final long getWaitTime(long startTime) {
        return System.currentTimeMillis() - startTime;
    }

    @Override
    public void destroy() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.lock.lock();
        try {
            boolean bl = this.data.isIdleEmpty() && this.data.isActiveEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumIdle() {
        this.lock.lock();
        try {
            int n = this.data.numIdle();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumActive() {
        this.lock.lock();
        try {
            int n = this.data.numActive();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPoolSize() {
        this.lock.lock();
        try {
            int n = this.data.numActive() + this.data.numIdle();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumWaiting() {
        this.lock.lock();
        try {
            int n = this.lock.getWaitQueueLength(this.idleAvailable);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getMaxUseTime() {
        return this.maxUseTime;
    }

    @Override
    public long getMinUseTime() {
        return this.minUseTime;
    }

    @Override
    public int getNumBroken() {
        return this.numBroken;
    }

    @Override
    public void resetMaxUseTime() {
        this.maxUseTime = 0L;
    }

    @Override
    public void resetMinUseTime() {
        this.minUseTime = Long.MAX_VALUE;
    }

    public double getAvgUseTime() {
        double retval = 0.0;
        for (long useTime : this.useTimes) {
            retval += (double)useTime;
        }
        return retval / (double)this.useTimes.length;
    }

    public Runnable getCleanerTask() {
        return this.cleaner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBelowMinIdle() {
        int numActive;
        int numIdle;
        this.lock.lock();
        try {
            numIdle = this.data.numIdle();
            numActive = this.data.numActive();
        }
        finally {
            this.lock.unlock();
        }
        int maxCreate = -1 == this.maxActive ? Integer.MAX_VALUE : Math.max(0, this.maxActive - numActive - numIdle);
        return Math.min(this.minIdle - numIdle, maxCreate) > 0;
    }

    private void ensureMinIdle() throws PoolingException {
        for (boolean successfullyAdded = true; this.isBelowMinIdle() && successfullyAdded; successfullyAdded &= this.createObject()) {
        }
    }

    private boolean createObject() throws PoolingException {
        T pooled;
        try {
            pooled = this.lifecycle.create();
        }
        catch (Exception e) {
            throw new PoolingException("Cannot create pooled object.", e);
        }
        return this.back(pooled, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Starting cleaner run.");
        }
        ArrayList<PooledData<T>> toCheck = new ArrayList<PooledData<T>>();
        ArrayList<PooledData> removed = new ArrayList<PooledData>();
        ArrayList<PooledData<T>> notReturned = new ArrayList<PooledData<T>>();
        this.lock.lock();
        try {
            PooledData<T> metaData;
            boolean bl;
            int idleSize = this.data.numIdle();
            boolean bl2 = true;
            int index = 0;
            while (bl && index < idleSize) {
                metaData = this.data.getIdle(index);
                boolean bl3 = bl = this.maxIdleTime > 0L && metaData.getTimeDiff() > this.maxIdleTime || this.maxLifeTime > 0L && metaData.getLiveTime() > this.maxLifeTime;
                if (bl) {
                    this.data.removeIdle(index);
                    idleSize = this.data.numIdle();
                    removed.add(metaData);
                    continue;
                }
                if (this.testOnIdle) {
                    this.data.removeIdle(index);
                    idleSize = this.data.numIdle();
                    toCheck.add(metaData);
                    continue;
                }
                ++index;
            }
            Iterator<PooledData<T>> iter = this.data.listActive();
            while (iter.hasNext()) {
                metaData = iter.next();
                if (metaData.getTimeDiff() <= this.maxIdleTime) continue;
                notReturned.add(metaData);
                iter.remove();
                this.idleAvailable.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
        for (PooledData pooledData : toCheck) {
            if (!(this.lifecycle.activate(pooledData) && this.lifecycle.validate(pooledData) && this.lifecycle.deactivate(pooledData))) {
                removed.add(pooledData);
                continue;
            }
            this.lock.lock();
            try {
                this.data.addIdle(pooledData);
            }
            finally {
                this.lock.unlock();
            }
        }
        for (PooledData pooledData : removed) {
            this.lifecycle.destroy(pooledData.getPooled());
        }
        for (PooledData pooledData : notReturned) {
            StringBuilder sb = new StringBuilder();
            sb.append("Object was not returned. Fetched: ");
            sb.append(pooledData.getTimestamp());
            sb.append(", UseTime: ");
            sb.append(pooledData.getTimeDiff());
            sb.append(", ID: ");
            sb.append(pooledData.getIdentifier());
            sb.append(", Object: ");
            sb.append(pooledData.getPooled());
            PoolingException e = new PoolingException(sb.toString());
            if (this.testThreads && null != pooledData.getTrace()) {
                e.setStackTrace(pooledData.getTrace());
            }
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        try {
            this.ensureMinIdle();
        }
        catch (PoolingException e) {
            LOG.error((Object)"Problem creating the minimum number of connections.", (Throwable)e);
        }
        LOG.trace((Object)("Clean run ending. Time: " + ReentrantLockPool.getWaitTime(startTime)));
    }

    public static class Config
    implements Cloneable {
        public int minIdle = 0;
        public int maxIdle = -1;
        public long maxIdleTime = 60000L;
        public int maxActive = -1;
        public long maxWait = 10000L;
        public long maxLifeTime = -1L;
        public ExhaustedActions exhaustedAction = ExhaustedActions.GROW;
        public boolean testOnActivate = true;
        public boolean testOnDeactivate = true;
        public boolean testOnIdle = false;
        public boolean testThreads = false;

        public Config clone() {
            try {
                return (Config)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new Error("Assertion failed!", e);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Database pooling options:\n\tMinimum idle connections: ");
            sb.append(this.minIdle);
            sb.append("\n\tMaximum idle connections: ");
            sb.append(this.maxIdle);
            sb.append("\n\tMaximum idle time: ");
            sb.append(this.maxIdleTime);
            sb.append("ms\n\tMaximum active connections: ");
            sb.append(this.maxActive);
            sb.append("\n\tMaximum wait time for a connection: ");
            sb.append(this.maxWait);
            sb.append("ms\n\tMaximum life time of a connection: ");
            sb.append(this.maxLifeTime);
            sb.append("ms\n\tAction if connections exhausted: ");
            sb.append(this.exhaustedAction.toString());
            sb.append("\n\tTest connections on activate  : ");
            sb.append(this.testOnActivate);
            sb.append("\n\tTest connections on deactivate: ");
            sb.append(this.testOnDeactivate);
            sb.append("\n\tTest idle connections         : ");
            sb.append(this.testOnIdle);
            sb.append("\n\tTest threads for bad connection usage (SLOW): ");
            sb.append(this.testThreads);
            return sb.toString();
        }
    }
}

