/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mailaccount.json.actions;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.mailaccount.Attribute;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.mailaccount.json.actions.AbstractMailAccountAction;
import com.openexchange.mailaccount.json.writer.MailAccountWriter;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;

public final class ListAction
extends AbstractMailAccountAction {
    public static final String ACTION = "list";

    @Override
    public AJAXRequestResult perform(AJAXRequestData requestData, ServerSession session) throws OXException {
        String colString = requestData.getParameter("columns");
        List<Attribute> attributes = ListAction.getColumns(colString);
        try {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            JSONArray ids = (JSONArray)requestData.getData();
            int len = ids.length();
            boolean multipleEnabled = session.getUserConfiguration().isMultipleMailAccounts();
            ArrayList<MailAccount> accounts = new ArrayList<MailAccount>(len);
            int size = len;
            for (int i = 0; i < size; ++i) {
                int id = ids.getInt(i);
                MailAccount account = storageService.getMailAccount(id, session.getUserId(), session.getContextId());
                if (ListAction.isUnifiedINBOXAccount(account) || !multipleEnabled && !ListAction.isDefaultMailAccount(account)) continue;
                accounts.add(ListAction.checkFullNames(account, storageService, session));
            }
            return new AJAXRequestResult(MailAccountWriter.writeArray(accounts.toArray(new MailAccount[accounts.size()]), attributes));
        }
        catch (JSONException e) {
            throw AjaxExceptionCodes.JSON_ERROR.create(e, e.getMessage());
        }
    }
}

