/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.exception.OXException;
import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.utils.CharsetDetector;
import java.io.ByteArrayOutputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;

public final class MessageUtility {
    private static final String STR_EMPTY = "";
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MessageUtility.class));
    private static final boolean DEBUG = LOG.isDebugEnabled();
    private static final int BUFSIZE = 8192;
    public static final char UNKNOWN = '\ufffd';
    private static final Pattern PATTERN_BIG5 = Pattern.compile("[-_]+");
    private static final String BIG5 = "big5";
    private static final String BIGFIVE = "bigfive";
    private static final String GB2312 = "gb2312";

    private MessageUtility() {
    }

    public static String checkCharset(MailPart p, ContentType ct) throws OXException {
        String cs = ct.getCharsetParameter();
        if (!CharsetDetector.isValid(cs)) {
            StringBuilder sb = null;
            if (cs != null) {
                sb = new StringBuilder(64).append("Illegal or unsupported encoding: \"").append(cs).append("\".");
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
            }
            cs = CharsetDetector.detectCharset(p.getInputStream());
            if (null != sb && LOG.isWarnEnabled()) {
                sb.append(" Using auto-detected encoding: \"").append(cs).append('\"');
                LOG.warn((Object)sb.toString());
            }
        }
        return cs;
    }

    public static String checkCharset(Part p, ContentType ct) {
        String cs = ct.getCharsetParameter();
        if (!CharsetDetector.isValid(cs)) {
            StringBuilder sb = null;
            if (cs != null) {
                sb = new StringBuilder(64).append("Illegal or unsupported encoding: \"").append(cs).append("\".");
                MailServletInterface.mailInterfaceMonitor.addUnsupportedEncodingExceptions(cs);
            }
            cs = CharsetDetector.detectCharset(MessageUtility.getPartInputStream(p));
            if (null != sb && LOG.isWarnEnabled()) {
                sb.append(" Using auto-detected encoding: \"").append(cs).append('\"');
                LOG.warn((Object)sb.toString());
            }
        }
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InputStream getPartInputStream(Part p) {
        InputStream tmp = null;
        try {
            tmp = p.getInputStream();
            tmp.read();
            InputStream inputStream = p.getInputStream();
            return inputStream;
        }
        catch (IOException e) {
            InputStream inputStream = MessageUtility.getPartRawInputStream(p);
            return inputStream;
        }
        catch (MessagingException e) {
            InputStream inputStream = MessageUtility.getPartRawInputStream(p);
            return inputStream;
        }
        finally {
            if (null != tmp) {
                try {
                    tmp.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private static InputStream getPartRawInputStream(Part p) {
        if (p instanceof MimeBodyPart) {
            try {
                return ((MimeBodyPart)p).getRawInputStream();
            }
            catch (MessagingException e1) {
                return null;
            }
        }
        if (p instanceof MimeMessage) {
            try {
                return ((MimeMessage)p).getRawInputStream();
            }
            catch (MessagingException e1) {
                return null;
            }
        }
        return null;
    }

    public static String readMimePart(Part p, ContentType ct) throws MessagingException {
        String charset = ct.getCharsetParameter();
        if (null == charset) {
            charset = ServerConfig.getProperty(ServerConfig.Property.DefaultEncoding);
        }
        return MessageUtility.readMimePart(p, charset);
    }

    public static String readMimePart(final Part p, String charset) throws MessagingException {
        try {
            AbstractInputStreamProvider streamProvider = new AbstractInputStreamProvider(){

                @Override
                public InputStream getInputStream() throws IOException {
                    try {
                        return p.getInputStream();
                    }
                    catch (MessagingException e) {
                        throw new IOException(e.getMessage(), e);
                    }
                }
            };
            return MessageUtility.readStream(streamProvider, charset);
        }
        catch (IOException e) {
            AbstractInputStreamProvider streamProvider;
            Throwable cause = e.getCause();
            if (cause instanceof MessagingException) {
                throw (MessagingException)cause;
            }
            if (p instanceof MimeBodyPart) {
                streamProvider = new AbstractInputStreamProvider(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return ((MimeBodyPart)p).getRawInputStream();
                        }
                        catch (MessagingException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                };
            } else if (p instanceof MimeMessage) {
                streamProvider = new AbstractInputStreamProvider(){

                    @Override
                    public InputStream getInputStream() throws IOException {
                        try {
                            return ((MimeMessage)p).getRawInputStream();
                        }
                        catch (MessagingException e) {
                            throw new IOException(e.getMessage(), e);
                        }
                    }
                };
            } else {
                return STR_EMPTY;
            }
            try {
                return MessageUtility.readStream(streamProvider, charset);
            }
            catch (IOException e1) {
                LOG.error((Object)e1.getMessage(), (Throwable)e1);
                return STR_EMPTY;
            }
        }
    }

    public static String readMailPart(final MailPart mailPart, String charset) throws IOException, OXException {
        AbstractInputStreamProvider streamProvider = new AbstractInputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                try {
                    return mailPart.getInputStream();
                }
                catch (OXException e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
        };
        try {
            return MessageUtility.readStream(streamProvider, charset);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw e;
        }
    }

    public static String readBytes(final byte[] bytes, String charset) throws IOException {
        AbstractInputStreamProvider streamProvider = new AbstractInputStreamProvider(){

            @Override
            public InputStream getInputStream() throws IOException {
                return Streams.newByteArrayInputStream((byte[])bytes);
            }
        };
        return MessageUtility.readStream(streamProvider, charset);
    }

    public static String readStream(StreamDataSource.InputStreamProvider streamProvider, String charset) throws IOException {
        if (null == streamProvider) {
            return STR_EMPTY;
        }
        if (MessageUtility.isBig5(charset)) {
            return MessageUtility.readBig5Bytes(MessageUtility.getBytesFrom(streamProvider.getInputStream()));
        }
        if ("GB18030".equalsIgnoreCase(charset)) {
            return MessageUtility.readGB18030Bytes(MessageUtility.getBytesFrom(streamProvider.getInputStream()));
        }
        if (MessageUtility.isGB2312(charset)) {
            byte[] bytes = MessageUtility.getBytesFrom(streamProvider.getInputStream());
            if (bytes.length == 0) {
                return STR_EMPTY;
            }
            String retval = new String(bytes, "GB2312");
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            retval = new String(bytes, "GB18030");
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            String detectedCharset = CharsetDetector.detectCharset(Streams.newByteArrayInputStream((byte[])bytes));
            if (DEBUG) {
                LOG.debug((Object)("Mapped \"GB2312\" charset to \"" + detectedCharset + "\"."));
            }
            if (MessageUtility.isBig5(detectedCharset)) {
                return MessageUtility.readBig5Bytes(bytes);
            }
            return new String(bytes, detectedCharset);
        }
        String retval = MessageUtility.readStream0(streamProvider.getInputStream(), charset);
        if (retval.indexOf(65533) < 0) {
            return retval;
        }
        byte[] bytes = MessageUtility.getBytesFrom(streamProvider.getInputStream());
        String detectedCharset = CharsetDetector.detectCharset(Streams.newByteArrayInputStream((byte[])bytes));
        if (DEBUG) {
            LOG.debug((Object)("Mapped \"" + charset + "\" charset to \"" + detectedCharset + "\"."));
        }
        return new String(bytes, detectedCharset);
    }

    public static String readStream(InputStream inStream, String charset) throws IOException {
        if (null == inStream) {
            return STR_EMPTY;
        }
        if (MessageUtility.isBig5(charset)) {
            return MessageUtility.readBig5Bytes(MessageUtility.getBytesFrom(inStream));
        }
        if ("GB18030".equalsIgnoreCase(charset)) {
            return MessageUtility.readGB18030Bytes(MessageUtility.getBytesFrom(inStream));
        }
        if (MessageUtility.isGB2312(charset)) {
            byte[] bytes = MessageUtility.getBytesFrom(inStream);
            if (bytes.length == 0) {
                return STR_EMPTY;
            }
            String retval = new String(bytes, Charsets.forName((String)"GB2312"));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            retval = new String(bytes, Charsets.forName((String)"GB18030"));
            if (retval.indexOf(65533) < 0) {
                return retval;
            }
            String detectedCharset = CharsetDetector.detectCharset(Streams.newByteArrayInputStream((byte[])bytes));
            if (DEBUG) {
                LOG.debug((Object)("Mapped \"GB2312\" charset to \"" + detectedCharset + "\"."));
            }
            if (MessageUtility.isBig5(detectedCharset)) {
                return MessageUtility.readBig5Bytes(bytes);
            }
            return new String(bytes, Charsets.forName((String)detectedCharset));
        }
        return MessageUtility.readStream0(inStream, charset);
    }

    private static String readGB18030Bytes(byte[] bytes) throws Error {
        if (bytes.length == 0) {
            return STR_EMPTY;
        }
        String retval = new String(bytes, Charsets.forName((String)"GB18030"));
        if (retval.indexOf(65533) < 0) {
            return retval;
        }
        String detectedCharset = CharsetDetector.detectCharset(Streams.newByteArrayInputStream((byte[])bytes));
        if (DEBUG) {
            LOG.debug((Object)("Mapped \"GB18030\" charset to \"" + detectedCharset + "\"."));
        }
        if (MessageUtility.isBig5(detectedCharset)) {
            return MessageUtility.readBig5Bytes(bytes);
        }
        return new String(bytes, Charsets.forName((String)detectedCharset));
    }

    private static String readBig5Bytes(byte[] bytes) throws Error {
        if (bytes.length == 0) {
            return STR_EMPTY;
        }
        String retval = new String(bytes, Charsets.forName((String)BIG5));
        if (retval.indexOf(65533) < 0) {
            return retval;
        }
        try {
            return new String(bytes, Charsets.forName((String)"Big5-HKSCS"));
        }
        catch (Error error) {
            Throwable cause = error.getCause();
            if (cause instanceof CharConversionException || cause instanceof CharacterCodingException) {
                return new String(bytes, Charsets.forName((String)CharsetDetector.detectCharset(Streams.newByteArrayInputStream((byte[])bytes))));
            }
            throw error;
        }
    }

    /*
     * Loose catch block
     */
    private static String readStream0(InputStream inStream, String charset) throws IOException {
        int read;
        if (null == inStream) {
            return STR_EMPTY;
        }
        ByteArrayOutputStream tmp = Streams.newByteArrayOutputStream((int)16384);
        byte[] buf = new byte[8192];
        while ((read = inStream.read(buf, 0, 8192)) > 0) {
            tmp.write(buf, 0, read);
        }
        if (null == charset) {
            byte[] bytes = tmp.toByteArray();
            String string = new String(bytes, Charsets.forName((String)MessageUtility.detectCharset(bytes)));
            return string;
        }
        String bytes = new String(tmp.toByteArray(), Charsets.forName((String)charset));
        return bytes;
        {
            catch (IOException e) {
                if ("No content".equals(e.getMessage())) {
                    String string = STR_EMPTY;
                    return string;
                }
                throw e;
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private static String detectCharset(byte[] bytes) {
        String charset = CharsetDetector.detectCharset(Streams.newByteArrayInputStream((byte[])bytes));
        if ("US-ASCII".equalsIgnoreCase(charset)) {
            charset = "ISO-8859-1";
        }
        return charset;
    }

    public static boolean isBig5(String charset) {
        if (null == charset) {
            return false;
        }
        String lc = charset.toLowerCase(Locale.US);
        if (!lc.startsWith("big", 0)) {
            return false;
        }
        String wo = PATTERN_BIG5.matcher(lc).replaceAll(STR_EMPTY);
        return BIG5.equals(wo) || BIGFIVE.equals(wo);
    }

    public static boolean isGB2312(String charset) {
        if (null == charset) {
            return false;
        }
        return GB2312.equals(charset.toLowerCase(Locale.US));
    }

    public static byte[] getBytesFrom(InputStream in) throws IOException {
        if (null == in) {
            return new byte[0];
        }
        try {
            byte[] buf = new byte[8192];
            int len = 0;
            len = in.read(buf, 0, buf.length);
            if (len <= 0) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            ByteArrayOutputStream out = Streams.newByteArrayOutputStream((int)8192);
            do {
                out.write(buf, 0, len);
            } while ((len = in.read(buf, 0, buf.length)) > 0);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            if ("No content".equals(e.getMessage())) {
                byte[] byArray = new byte[]{};
                return byArray;
            }
            throw e;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static boolean isAscii(byte[] bytes) {
        if (null == bytes || 0 == bytes.length) {
            return true;
        }
        int len = bytes.length;
        boolean isAscci = true;
        for (int i = 0; i < len && isAscci; ++i) {
            isAscci = bytes[i] >= 0;
        }
        return isAscci;
    }

    public static String simpleHtmlDuplicateRemoval(String html) {
        if (MessageUtility.isEmpty(html)) {
            return html;
        }
        String lc = html.toLowerCase();
        int pos = lc.lastIndexOf("<html>");
        if (pos > 0 && (pos = lc.lastIndexOf("<html>", pos - 1)) >= 0) {
            return html.substring(pos + 6);
        }
        return html;
    }

    private static boolean isEmpty(String string) {
        if (null == string) {
            return true;
        }
        int len = string.length();
        boolean isWhitespace = true;
        for (int i = 0; isWhitespace && i < len; ++i) {
            isWhitespace = Character.isWhitespace(string.charAt(i));
        }
        return isWhitespace;
    }

    private static abstract class AbstractInputStreamProvider
    implements StreamDataSource.InputStreamProvider {
        protected AbstractInputStreamProvider() {
        }

        @Override
        public String getName() {
            return null;
        }
    }
}

