/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.utils;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.i18n.MailStrings;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.mailaccount.MailAccount;
import com.openexchange.mailaccount.MailAccountDescription;
import com.openexchange.mailaccount.MailAccountStorageService;
import com.openexchange.server.services.ServerServiceRegistry;

public final class DefaultFolderNamesProvider {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(DefaultFolderNamesProvider.class));
    private static final String SWITCH_DEFAULT_FOLDER = "Switching to default value %s";
    private final FallbackProvider fallbackProvider;
    public static final FallbackProvider DEFAULT_PROVIDER = new FallbackProvider(){

        @Override
        public String getConfirmedHam() {
            return MailStrings.CONFIRMED_HAM;
        }

        @Override
        public String getConfirmedSpam() {
            return MailStrings.CONFIRMED_SPAM;
        }

        @Override
        public String getDrafts() {
            return MailStrings.DRAFTS;
        }

        @Override
        public String getSent() {
            return MailStrings.SENT;
        }

        @Override
        public String getSpam() {
            return MailStrings.SPAM;
        }

        @Override
        public String getTrash() {
            return MailStrings.TRASH;
        }
    };

    public DefaultFolderNamesProvider(int accountId, int user, int cid) throws OXException {
        if (0 == accountId) {
            this.fallbackProvider = DEFAULT_PROVIDER;
        } else {
            MailAccountStorageService storageService = ServerServiceRegistry.getInstance().getService(MailAccountStorageService.class, true);
            this.fallbackProvider = new DefaultAccountProvider(storageService.getDefaultMailAccount(user, cid));
        }
    }

    public String[] getDefaultFolderNames(MailAccount mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderNames(mailAccount.getTrash(), mailAccount.getSent(), mailAccount.getDrafts(), mailAccount.getSpam(), mailAccount.getConfirmedSpam(), mailAccount.getConfirmedHam(), isSpamEnabled);
    }

    public String[] getDefaultFolderNames(MailAccountDescription mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderNames(mailAccount.getTrash(), mailAccount.getSent(), mailAccount.getDrafts(), mailAccount.getSpam(), mailAccount.getConfirmedSpam(), mailAccount.getConfirmedHam(), isSpamEnabled);
    }

    public String[] getDefaultFolderNames(String trash, String sent, String drafts, String spam, String confirmedSpam, String confirmedHam, boolean isSpamEnabled) {
        String[] names = new String[isSpamEnabled ? 6 : 4];
        if (drafts == null || drafts.length() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getDrafts()));
            }
            names[0] = this.fallbackProvider.getDrafts();
        } else {
            names[0] = drafts;
        }
        if (sent == null || sent.length() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getSent()));
            }
            names[1] = this.fallbackProvider.getSent();
        } else {
            names[1] = sent;
        }
        if (spam == null || spam.length() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getSpam()));
            }
            names[2] = this.fallbackProvider.getSpam();
        } else {
            names[2] = spam;
        }
        if (trash == null || trash.length() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getTrash()));
            }
            names[3] = this.fallbackProvider.getTrash();
        } else {
            names[3] = trash;
        }
        if (isSpamEnabled) {
            if (confirmedSpam == null || confirmedSpam.length() == 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getConfirmedSpam()));
                }
                names[4] = this.fallbackProvider.getConfirmedSpam();
            } else {
                names[4] = confirmedSpam;
            }
            if (confirmedHam == null || confirmedHam.length() == 0) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)String.format(SWITCH_DEFAULT_FOLDER, this.fallbackProvider.getConfirmedHam()));
                }
                names[5] = this.fallbackProvider.getConfirmedHam();
            } else {
                names[5] = confirmedHam;
            }
        }
        return names;
    }

    public String[] getDefaultFolderFullnames(MailAccount mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderFullnames(DefaultFolderNamesProvider.extractFullname(mailAccount.getTrashFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSentFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getDraftsFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedHamFullname()), isSpamEnabled);
    }

    public String[] getDefaultFolderFullnames(MailAccountDescription mailAccount, boolean isSpamEnabled) {
        return this.getDefaultFolderFullnames(DefaultFolderNamesProvider.extractFullname(mailAccount.getTrashFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSentFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getDraftsFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedSpamFullname()), DefaultFolderNamesProvider.extractFullname(mailAccount.getConfirmedHamFullname()), isSpamEnabled);
    }

    private static String extractFullname(String fullnameParameter) {
        return null == fullnameParameter ? null : MailFolderUtility.prepareMailFolderParam(fullnameParameter).getFullname();
    }

    public String[] getDefaultFolderFullnames(String trashFullname, String sentFullname, String draftsFullname, String spamFullname, String confirmedSpamFullname, String confirmedHamFullname, boolean isSpamEnabled) {
        String[] fullnames = new String[isSpamEnabled ? 6 : 4];
        fullnames[0] = draftsFullname != null && draftsFullname.length() != 0 ? draftsFullname : null;
        fullnames[1] = sentFullname != null && sentFullname.length() != 0 ? sentFullname : null;
        fullnames[2] = spamFullname != null && spamFullname.length() != 0 ? spamFullname : null;
        fullnames[3] = trashFullname != null && trashFullname.length() != 0 ? trashFullname : null;
        if (isSpamEnabled) {
            fullnames[4] = confirmedSpamFullname != null && confirmedSpamFullname.length() != 0 ? confirmedSpamFullname : null;
            fullnames[5] = confirmedHamFullname != null && confirmedHamFullname.length() != 0 ? confirmedHamFullname : null;
        }
        return fullnames;
    }

    private static final class DefaultAccountProvider
    implements FallbackProvider {
        private final MailAccount defaultAccount;

        public DefaultAccountProvider(MailAccount defaultAccount) {
            this.defaultAccount = defaultAccount;
        }

        @Override
        public String getConfirmedHam() {
            String ret = this.defaultAccount.getConfirmedHam();
            if (ret == null || ret.length() == 0) {
                return DEFAULT_PROVIDER.getConfirmedHam();
            }
            return ret;
        }

        @Override
        public String getConfirmedSpam() {
            String ret = this.defaultAccount.getConfirmedSpam();
            if (ret == null || ret.length() == 0) {
                return DEFAULT_PROVIDER.getConfirmedSpam();
            }
            return ret;
        }

        @Override
        public String getDrafts() {
            String ret = this.defaultAccount.getDrafts();
            if (ret == null || ret.length() == 0) {
                return DEFAULT_PROVIDER.getDrafts();
            }
            return ret;
        }

        @Override
        public String getSent() {
            String ret = this.defaultAccount.getSent();
            if (ret == null || ret.length() == 0) {
                return DEFAULT_PROVIDER.getSent();
            }
            return ret;
        }

        @Override
        public String getSpam() {
            String ret = this.defaultAccount.getSpam();
            if (ret == null || ret.length() == 0) {
                return DEFAULT_PROVIDER.getSpam();
            }
            return ret;
        }

        @Override
        public String getTrash() {
            String ret = this.defaultAccount.getTrash();
            if (ret == null || ret.length() == 0) {
                return DEFAULT_PROVIDER.getTrash();
            }
            return ret;
        }
    }

    public static interface FallbackProvider {
        public String getTrash();

        public String getSent();

        public String getDrafts();

        public String getSpam();

        public String getConfirmedSpam();

        public String getConfirmedHam();
    }
}

