/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailInitialization;
import com.openexchange.mail.transport.config.TransportPropertiesInit;
import com.openexchange.server.Initialization;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TransportInitialization
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(TransportInitialization.class));
    private static final TransportInitialization instance = new TransportInitialization();
    private final AtomicBoolean started = new AtomicBoolean();

    public static TransportInitialization getInstance() {
        return instance;
    }

    private TransportInitialization() {
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn((Object)"Duplicate initialization of transport module aborted.");
            return;
        }
        TransportPropertiesInit.getInstance().start();
    }

    public void stop() {
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn((Object)"Duplicate shut-down of transport module aborted.");
            return;
        }
        TransportPropertiesInit.getInstance().stop();
    }

    public boolean isInitialized() {
        return this.started.get() && MailInitialization.getInstance().isInitialized();
    }
}

