/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime.processing;

import com.openexchange.config.ConfigurationService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.i18n.tools.StringHelper;
import com.openexchange.java.Streams;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.MailSessionCache;
import com.openexchange.mail.MailSessionParameterNames;
import com.openexchange.mail.api.IMailFolderStorage;
import com.openexchange.mail.api.IMailMessageStorage;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.CompositeMailMessage;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.ManagedMimeMessage;
import com.openexchange.mail.mime.MimeDefaultSession;
import com.openexchange.mail.mime.MimeMailException;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.mail.mime.converters.MimeMessageConverter;
import com.openexchange.mail.mime.filler.MimeMessageFiller;
import com.openexchange.mail.mime.processing.LocaleAndTimeZone;
import com.openexchange.mail.mime.processing.MimeProcessingUtility;
import com.openexchange.mail.mime.utils.MimeMessageUtility;
import com.openexchange.mail.parser.MailMessageParser;
import com.openexchange.mail.parser.handlers.InlineContentHandler;
import com.openexchange.mail.text.HtmlProcessing;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.mail.utils.CharsetDetector;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.regex.MatcherReplacer;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.logging.Log;

public final class MimeReply {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeReply.class));
    private static final String PREFIX_RE = "Re: ";
    private static final Pattern PAT_META_CT = Pattern.compile("<meta[^>]*?http-equiv=\"?content-type\"?[^>]*?>", 2);
    private static final Pattern PATTERN_DATE = Pattern.compile(Pattern.quote("#DATE#"));
    private static final Pattern PATTERN_TIME = Pattern.compile(Pattern.quote("#TIME#"));
    private static final Pattern PATTERN_SENDER = Pattern.compile(Pattern.quote("#SENDER#"));
    private static final String MULTIPART = "multipart/";
    private static final String TEXT = "text/";
    private static final String TEXT_HTM = "text/htm";
    private static final Pattern PATTERN_BODY_TAG = Pattern.compile("<body[^>]*?>", 2);
    private static final Pattern PATTERN_HTML_START = Pattern.compile("<html[^>]*?>", 2);
    private static final Pattern PATTERN_HTML_END = Pattern.compile("</html>", 2);
    private static final String BLOCKQUOTE_START = "<blockquote type=\"cite\" style=\"position: relative; margin-left: 0px; padding-left: 10px; border-left: solid 1px blue;\">\n";
    private static final String BLOCKQUOTE_END = "</blockquote>\n<br>&nbsp;";

    private MimeReply() {
    }

    public static MailMessage getReplyMail(MailMessage originalMail, boolean replyAll, Session session, int accountId) throws OXException {
        return MimeReply.getReplyMail(originalMail, replyAll, session, accountId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MailMessage getReplyMail(MailMessage originalMail, boolean replyAll, Session session, int accountId, UserSettingMail usm) throws OXException {
        boolean preferToAsRecipient = false;
        String originalMailFolder = originalMail.getFolder();
        MailPath msgref = null;
        if (originalMail.getMailId() != null && originalMailFolder != null) {
            msgref = new MailPath(accountId, originalMailFolder, originalMail.getMailId());
            String[] arr = (String[])MailSessionCache.getInstance(session).getParameter(accountId, MailSessionParameterNames.getParamDefaultFolderArray());
            if (arr == null) {
                MailAccess<IMailFolderStorage, IMailMessageStorage> mailAccess = MailAccess.getInstance(session, accountId);
                mailAccess.connect();
                try {
                    IMailFolderStorage folderStorage = mailAccess.getFolderStorage();
                    preferToAsRecipient = originalMailFolder.equals(folderStorage.getSentFolder()) || originalMailFolder.equals(folderStorage.getDraftsFolder());
                }
                finally {
                    mailAccess.close(false);
                }
            } else {
                preferToAsRecipient = originalMailFolder.equals(arr[1]) || originalMailFolder.equals(arr[0]);
            }
        }
        return MimeReply.getReplyMail(originalMail, msgref, replyAll, preferToAsRecipient, session, accountId, MimeDefaultSession.getDefaultSession(), usm);
    }

    private static String replaceMetaEquiv(String html, ContentType contentType) {
        Matcher m = PAT_META_CT.matcher(html);
        MatcherReplacer mr = new MatcherReplacer(m, html);
        StringBuilder replaceBuffer = new StringBuilder(html.length());
        if (m.find()) {
            replaceBuffer.append("<meta content=\"").append(contentType.getBaseType().toLowerCase(Locale.ENGLISH));
            replaceBuffer.append("; charset=").append(contentType.getCharsetParameter()).append("\" http-equiv=\"Content-Type\" />");
            String replacement = replaceBuffer.toString();
            replaceBuffer.setLength(0);
            mr.appendLiteralReplacement(replaceBuffer, replacement);
        }
        mr.appendTail(replaceBuffer);
        return replaceBuffer.toString();
    }

    private static MailMessage getReplyMail(MailMessage originalMsg, MailPath msgref, boolean replyAll, boolean preferToAsRecipient, Session session, int accountId, javax.mail.Session mailSession, UserSettingMail userSettingMail) throws OXException {
        try {
            String cs;
            InternetAddress[] recipientAddrs;
            String rawSubject;
            String decodedSubject;
            originalMsg.setAccountId(accountId);
            MailMessage origMsg = ManagedMimeMessage.clone(originalMsg);
            Context ctx = ContextStorage.getStorageContext(session.getContextId());
            UserSettingMail usm = userSettingMail == null ? UserSettingMailStorage.getInstance().getUserSettingMail(session.getUserId(), ctx) : userSettingMail;
            MimeMessage replyMsg = new MimeMessage(MimeDefaultSession.getDefaultSession());
            String subjectPrefix = PREFIX_RE;
            String subjectHdrValue = MimeMessageUtility.checkNonAscii(origMsg.getHeader("Subject", null));
            if (subjectHdrValue == null) {
                subjectHdrValue = "";
            }
            String newSubject = (decodedSubject = MimeMessageUtility.decodeMultiEncodedHeader(rawSubject = MimeMessageUtility.unfold(subjectHdrValue))).regionMatches(true, 0, PREFIX_RE, 0, 4) ? decodedSubject : PREFIX_RE + decodedSubject;
            replyMsg.setSubject(newSubject, MailProperties.getInstance().getDefaultMimeCharset());
            if (preferToAsRecipient) {
                String hdrVal = origMsg.getHeader("To", ",");
                recipientAddrs = null == hdrVal ? new InternetAddress[]{} : MimeMessageUtility.parseAddressList(hdrVal, true);
            } else {
                boolean fromAdded;
                LinkedHashSet<InternetAddress> tmpSet = new LinkedHashSet<InternetAddress>(4);
                String[] replyTo = origMsg.getHeader("Reply-To");
                if (MimeMessageUtility.isEmptyHeader(replyTo)) {
                    User[] users;
                    String owner = MimeProcessingUtility.getFolderOwnerIfShared(msgref.getFolder(), msgref.getAccountId(), session);
                    if (null != owner && null != (users = UserStorage.getInstance().searchUserByMailLogin(owner, ctx)) && users.length > 0) {
                        QuotedInternetAddress onBehalfOf = new QuotedInternetAddress(users[0].getMail(), true);
                        replyMsg.setFrom((Address)onBehalfOf);
                        QuotedInternetAddress sender = new QuotedInternetAddress(usm.getSendAddr(), true);
                        replyMsg.setSender((Address)sender);
                    }
                    tmpSet.addAll(Arrays.asList(origMsg.getFrom()));
                    fromAdded = true;
                } else {
                    tmpSet.addAll(Arrays.asList(QuotedInternetAddress.parseHeader(MimeMessageUtility.unfold(replyTo[0]), true)));
                    fromAdded = false;
                }
                if (replyAll && !fromAdded) {
                    tmpSet.addAll(Arrays.asList(origMsg.getFrom()));
                }
                recipientAddrs = tmpSet.toArray(new InternetAddress[tmpSet.size()]);
            }
            if (replyAll) {
                String[] userAddrs;
                String alternates;
                HashSet<InternetAddress> filter = new HashSet<InternetAddress>();
                if (InternetAddress.getLocalAddress((javax.mail.Session)mailSession) != null) {
                    filter.add(InternetAddress.getLocalAddress((javax.mail.Session)mailSession));
                }
                if ((alternates = mailSession.getProperty("mail.alternates")) != null) {
                    filter.addAll(Arrays.asList(MimeMessageUtility.parseAddressList(alternates, false)));
                }
                if ((userAddrs = UserStorage.getStorageUser(session.getUserId(), ctx).getAliases()) != null && userAddrs.length > 0) {
                    StringBuilder addrBuilder = new StringBuilder();
                    addrBuilder.append(userAddrs[0]);
                    for (int i = 1; i < userAddrs.length; ++i) {
                        addrBuilder.append(',').append(userAddrs[i]);
                    }
                    filter.addAll(Arrays.asList(MimeMessageUtility.parseAddressList(addrBuilder.toString(), false)));
                }
                boolean replyallcc = usm.isReplyAllCc();
                Set<InternetAddress> filteredAddrs = MimeReply.filter(filter, recipientAddrs);
                String hdrVal = origMsg.getHeader("To", ",");
                InternetAddress[] toAddrs = null;
                if (hdrVal != null) {
                    toAddrs = MimeMessageUtility.parseAddressList(hdrVal, true);
                    filteredAddrs.addAll(MimeReply.filter(filter, toAddrs));
                }
                if (!filteredAddrs.isEmpty()) {
                    if (replyallcc) {
                        replyMsg.addRecipients(Message.RecipientType.TO, (Address[])recipientAddrs);
                        filteredAddrs.removeAll(Arrays.asList(recipientAddrs));
                        replyMsg.addRecipients(Message.RecipientType.CC, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                    } else {
                        replyMsg.addRecipients(Message.RecipientType.TO, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                    }
                } else if (toAddrs != null) {
                    HashSet<InternetAddress> tmpSet = new HashSet<InternetAddress>(Arrays.asList(recipientAddrs));
                    tmpSet.removeAll(Arrays.asList(toAddrs));
                    if (tmpSet.isEmpty()) {
                        replyMsg.addRecipients(Message.RecipientType.TO, (Address[])recipientAddrs);
                    }
                }
                filteredAddrs.clear();
                hdrVal = origMsg.getHeader("Cc", ",");
                if (hdrVal != null) {
                    filteredAddrs.addAll(MimeReply.filter(filter, MimeMessageUtility.parseAddressList(MimeMessageUtility.unfold(hdrVal), true)));
                }
                if (!filteredAddrs.isEmpty()) {
                    replyMsg.addRecipients(Message.RecipientType.CC, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                }
                filteredAddrs.clear();
                hdrVal = origMsg.getHeader("Bcc", ",");
                if (hdrVal != null) {
                    filteredAddrs.addAll(MimeReply.filter(filter, MimeMessageUtility.parseAddressList(MimeMessageUtility.unfold(hdrVal), true)));
                }
                if (!filteredAddrs.isEmpty()) {
                    replyMsg.addRecipients(Message.RecipientType.BCC, (Address[])filteredAddrs.toArray(new InternetAddress[filteredAddrs.size()]));
                }
            } else {
                replyMsg.addRecipients(Message.RecipientType.TO, (Address[])recipientAddrs);
            }
            if (usm.isIgnoreOriginalMailTextOnReply()) {
                replyMsg.setText("", MailProperties.getInstance().getDefaultMimeCharset(), "plain");
                replyMsg.setHeader("MIME-Version", "1.0");
                replyMsg.setHeader("Content-Type", "text/plain; charset=#CS#".replaceFirst("#CS#", MailProperties.getInstance().getDefaultMimeCharset()));
                MailMessage replyMail = MimeMessageConverter.convertMessage(replyMsg);
                if (null != msgref) {
                    replyMail.setMsgref(msgref);
                }
                return replyMail;
            }
            ContentType retvalContentType = new ContentType();
            ArrayList<String> list = new ArrayList<String>();
            User user = UserStorage.getStorageUser(session.getUserId(), ctx);
            Locale locale = user.getLocale();
            LocaleAndTimeZone ltz = new LocaleAndTimeZone(locale, user.getTimeZone());
            MimeReply.generateReplyText(origMsg, retvalContentType, StringHelper.valueOf(locale), ltz, usm, mailSession, list);
            StringBuilder replyTextBuilder = new StringBuilder(16384);
            for (int i = list.size() - 1; i >= 0; --i) {
                replyTextBuilder.append((String)list.get(i));
            }
            if (retvalContentType.getPrimaryType() == null) {
                retvalContentType.setContentType("text/plain");
            }
            if ((cs = retvalContentType.getCharsetParameter()) == null || "US-ASCII".equalsIgnoreCase(cs) || !CharsetDetector.isValid(cs)) {
                retvalContentType.setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
            }
            String replyText = replyTextBuilder.toString();
            if (retvalContentType.startsWith(TEXT_HTM)) {
                retvalContentType.setCharsetParameter("UTF-8");
                replyText = MimeReply.replaceMetaEquiv(replyText, retvalContentType);
            }
            replyMsg.setText(replyText, retvalContentType.getCharsetParameter(), retvalContentType.getSubType());
            replyMsg.setHeader("MIME-Version", "1.0");
            replyMsg.setHeader("Content-Type", MimeMessageUtility.foldContentType(retvalContentType.toString()));
            replyMsg.saveChanges();
            replyMsg.removeHeader("Message-ID");
            MimeMessageFiller.setReplyHeaders(origMsg, replyMsg);
            MailMessage replyMail = MimeMessageConverter.convertMessage(replyMsg);
            if (null != msgref) {
                replyMail.setMsgref(msgref);
            }
            return replyMail;
        }
        catch (MessagingException e) {
            throw MimeMailException.handleMessagingException(e);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    private static void appendInlineContent(MailMessage originalMail, CompositeMailMessage replyMail, List<String> cids) throws OXException {
        InlineContentHandler handler = new InlineContentHandler(cids);
        new MailMessageParser().parseMailMessage(originalMail, handler);
        Map<String, MailPart> inlineContents = handler.getInlineContents();
        for (String cid : cids) {
            MailPart part = inlineContents.get(cid);
            if (null == part) continue;
            replyMail.addAdditionalParts(part);
        }
    }

    private static Set<InternetAddress> filter(Set<InternetAddress> filter, InternetAddress[] addrs) {
        if (addrs == null) {
            return new HashSet<InternetAddress>(0);
        }
        HashSet<InternetAddress> set = new HashSet<InternetAddress>(Arrays.asList(addrs));
        set.removeAll(filter);
        filter.addAll(set);
        return set;
    }

    private static boolean generateReplyText(MailMessage msg, ContentType retvalContentType, StringHelper strHelper, LocaleAndTimeZone ltz, UserSettingMail usm, javax.mail.Session mailSession, List<String> replyTexts) throws OXException, MessagingException, IOException {
        StringBuilder textBuilder = new StringBuilder(8192);
        ContentType contentType = msg.getContentType();
        boolean found = false;
        if (contentType.startsWith(MULTIPART)) {
            ParameterContainer pc = new ParameterContainer(retvalContentType, textBuilder, strHelper, usm, mailSession, ltz, replyTexts);
            found |= MimeReply.gatherAllTextContents(msg, contentType, pc);
        } else if (contentType.startsWith(TEXT) && !MimeProcessingUtility.isSpecial(contentType.getBaseType())) {
            String text;
            if (retvalContentType.getPrimaryType() == null) {
                text = MimeProcessingUtility.handleInlineTextPart(msg, contentType, usm.isDisplayHtmlInlineContent());
                retvalContentType.setContentType(contentType);
                textBuilder.append(text);
            } else {
                text = MimeProcessingUtility.handleInlineTextPart(msg, contentType, usm.isDisplayHtmlInlineContent());
                MimeProcessingUtility.appendRightVersion(retvalContentType, contentType, text, textBuilder);
            }
            found = true;
        }
        if (found && !usm.isDropReplyForwardPrefix()) {
            String replyTextBody;
            boolean prependReplyPrefx;
            boolean isHtml = retvalContentType.startsWith(TEXT_HTM);
            String replyPrefix = strHelper.getString("On #DATE# at #TIME# #SENDER# wrote:");
            Date date = msg.getSentDate();
            try {
                replyPrefix = PATTERN_DATE.matcher(replyPrefix).replaceFirst(date == null ? "" : Matcher.quoteReplacement(MimeProcessingUtility.getFormattedDate(date, 1, ltz.locale, ltz.timeZone)));
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                replyPrefix = PATTERN_DATE.matcher(replyPrefix).replaceFirst("");
            }
            try {
                replyPrefix = PATTERN_TIME.matcher(replyPrefix).replaceFirst(date == null ? "" : Matcher.quoteReplacement(MimeProcessingUtility.getFormattedTime(date, 3, ltz.locale, ltz.timeZone)));
            }
            catch (Exception e) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)e.getMessage(), (Throwable)e);
                }
                replyPrefix = PATTERN_TIME.matcher(replyPrefix).replaceFirst("");
            }
            InternetAddress[] from = msg.getFrom();
            replyPrefix = PATTERN_SENDER.matcher(replyPrefix).replaceFirst(from == null || from.length == 0 ? "" : Matcher.quoteReplacement(from[0].toUnicodeString()));
            int nextLine = 10;
            replyPrefix = isHtml ? HtmlProcessing.htmlFormat(new StringBuilder(replyPrefix.length() + 1).append(replyPrefix).append('\n').toString()) : new StringBuilder(replyPrefix.length() + 1).append(replyPrefix).append('\n').toString();
            ConfigurationService service = ServerServiceRegistry.getInstance().getService(ConfigurationService.class);
            boolean bl = prependReplyPrefx = null == service ? false : service.getBoolProperty("com.openexchange.mail.prependReplyPrefx", false);
            if (prependReplyPrefx) {
                replyTextBody = isHtml ? MimeReply.quoteHtml(textBuilder.toString()) : MimeReply.quoteText(textBuilder.toString());
                textBuilder.setLength(0);
                textBuilder.append(replyPrefix);
                textBuilder.append(replyTextBody);
            } else {
                if (isHtml) {
                    textBuilder.insert(MimeReply.getBodyTagEndPos(textBuilder), replyPrefix);
                    replyTextBody = MimeReply.quoteHtml(textBuilder.toString());
                } else {
                    textBuilder.insert(0, replyPrefix);
                    textBuilder.insert(replyPrefix.length(), '\n');
                    replyTextBody = MimeReply.quoteText(textBuilder.toString());
                }
                textBuilder.setLength(0);
                textBuilder.append(replyTextBody);
            }
        }
        replyTexts.add(textBuilder.toString());
        return found;
    }

    private static int getBodyTagEndPos(StringBuilder textBuilder) {
        Matcher m = PATTERN_BODY_TAG.matcher(textBuilder);
        return m.find() ? m.end() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean gatherAllTextContents(MailPart multipartPart, ContentType mpContentType, ParameterContainer pc) throws OXException, MessagingException, IOException {
        int count = multipartPart.getEnclosedCount();
        ContentType partContentType = new ContentType();
        boolean found = false;
        if (pc.usm.isDisplayHtmlInlineContent() && mpContentType.startsWithAny("multipart/alternative", "multipart/related") && count >= 2) {
            found = MimeReply.getTextContent(true, multipartPart, count, partContentType, pc);
            if (!found) {
                found = MimeReply.getTextContent(false, multipartPart, count, partContentType, pc);
            }
        } else {
            found = MimeReply.getTextContent(true, multipartPart, count, partContentType, pc);
        }
        for (int i = count - 1; i >= 0; --i) {
            MailPart part = multipartPart.getEnclosedMailPart(i);
            partContentType.setContentType(part.getContentType());
            if (partContentType.startsWith("message/rfc822")) {
                MailMessage enclosedMsg = (MailMessage)part.getContent();
                found |= MimeReply.generateReplyText(enclosedMsg, pc.retvalContentType, pc.strHelper, pc.ltz, pc.usm, pc.mailSession, pc.replyTexts);
                continue;
            }
            if (!MimeProcessingUtility.fileNameEndsWith(".eml", part, partContentType)) continue;
            InputStream is = part.getInputStream();
            try {
                UnsynchronizedByteArrayOutputStream tmp = new UnsynchronizedByteArrayOutputStream(8192);
                byte[] buf = new byte[4096];
                int read = -1;
                while ((read = is.read(buf, 0, buf.length)) != -1) {
                    tmp.write(buf, 0, read);
                }
                MailMessage attachedMsg = MimeMessageConverter.convertMessage(tmp.toByteArray());
                found |= MimeReply.generateReplyText(attachedMsg, pc.retvalContentType, pc.strHelper, pc.ltz, pc.usm, pc.mailSession, pc.replyTexts);
                continue;
            }
            finally {
                Streams.close((Closeable)is);
            }
        }
        return found;
    }

    private static boolean getTextContent(boolean preferHTML, MailPart multipartPart, int count, ContentType partContentType, ParameterContainer pc) throws OXException, MessagingException, IOException {
        String text;
        String charset;
        MailPart part;
        int i;
        boolean found = false;
        if (preferHTML) {
            for (i = 0; !found && i < count; ++i) {
                part = multipartPart.getEnclosedMailPart(i);
                partContentType.setContentType(part.getContentType());
                if (partContentType.startsWith(TEXT_HTM) && MimeProcessingUtility.isInline(part, partContentType) && !MimeProcessingUtility.isSpecial(partContentType.getBaseType())) {
                    if (pc.retvalContentType.getPrimaryType() == null) {
                        pc.retvalContentType.setContentType(partContentType);
                        charset = MessageUtility.checkCharset(part, partContentType);
                        pc.retvalContentType.setCharsetParameter(charset);
                        text = MimeProcessingUtility.readContent(part, charset);
                        pc.textBuilder.append(text);
                    } else {
                        charset = MessageUtility.checkCharset(part, partContentType);
                        partContentType.setCharsetParameter(charset);
                        text = MimeProcessingUtility.handleInlineTextPart(part, partContentType, pc.usm.isDisplayHtmlInlineContent());
                        MimeProcessingUtility.appendRightVersion(pc.retvalContentType, partContentType, text, pc.textBuilder);
                    }
                    found = true;
                    continue;
                }
                if (!partContentType.startsWith(MULTIPART)) continue;
                found |= MimeReply.gatherAllTextContents(part, partContentType, pc);
            }
            if (found) {
                return true;
            }
        }
        found = false;
        for (i = 0; i < count; ++i) {
            part = multipartPart.getEnclosedMailPart(i);
            partContentType.setContentType(part.getContentType());
            if (partContentType.startsWith(TEXT) && !partContentType.startsWith(TEXT_HTM) && MimeProcessingUtility.isInline(part, partContentType) && !MimeProcessingUtility.isSpecial(partContentType.getBaseType())) {
                if (pc.retvalContentType.getPrimaryType() == null) {
                    pc.retvalContentType.setContentType(partContentType);
                    charset = MessageUtility.checkCharset(part, partContentType);
                    pc.retvalContentType.setCharsetParameter(charset);
                    text = MimeProcessingUtility.handleInlineTextPart(part, pc.retvalContentType, pc.usm.isDisplayHtmlInlineContent());
                    pc.textBuilder.append(text);
                } else {
                    charset = MessageUtility.checkCharset(part, partContentType);
                    partContentType.setCharsetParameter(charset);
                    text = MimeProcessingUtility.handleInlineTextPart(part, partContentType, pc.usm.isDisplayHtmlInlineContent());
                    MimeProcessingUtility.appendRightVersion(pc.retvalContentType, partContentType, text, pc.textBuilder);
                }
                found = true;
                continue;
            }
            if (!partContentType.startsWith(MULTIPART)) continue;
            found |= MimeReply.gatherAllTextContents(part, partContentType, pc);
        }
        return found;
    }

    private static String quoteText(String textContent) {
        return textContent.replaceAll("(?m)^", "> ");
    }

    private static String quoteHtml(String htmlContent) {
        Matcher m = PATTERN_HTML_START.matcher(htmlContent);
        MatcherReplacer mr = new MatcherReplacer(m, htmlContent);
        StringBuilder sb = new StringBuilder(htmlContent.length());
        if (m.find()) {
            mr.appendLiteralReplacement(sb, BLOCKQUOTE_START);
        } else {
            sb.append(BLOCKQUOTE_START);
        }
        mr.appendTail(sb);
        String s = sb.toString();
        m = PATTERN_HTML_END.matcher(s);
        mr.resetTo(m, s);
        sb.setLength(0);
        if (m.find()) {
            mr.appendLiteralReplacement(sb, BLOCKQUOTE_END);
            mr.appendTail(sb);
        } else {
            mr.appendTail(sb);
            sb.append(BLOCKQUOTE_END);
        }
        return sb.toString();
    }

    private static final class ParameterContainer {
        final ContentType retvalContentType;
        final StringBuilder textBuilder;
        final StringHelper strHelper;
        final UserSettingMail usm;
        final javax.mail.Session mailSession;
        final LocaleAndTimeZone ltz;
        final List<String> replyTexts;

        ParameterContainer(ContentType retvalContentType, StringBuilder textBuilder, StringHelper strHelper, UserSettingMail usm, javax.mail.Session mailSession, LocaleAndTimeZone ltz, List<String> replyTexts) {
            this.retvalContentType = retvalContentType;
            this.textBuilder = textBuilder;
            this.strHelper = strHelper;
            this.usm = usm;
            this.mailSession = mailSession;
            this.ltz = ltz;
            this.replyTexts = replyTexts;
        }
    }
}

