/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.exception.OXException;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailServletInterface;
import com.openexchange.mail.api.MailConfig;
import com.openexchange.mail.mime.MimeMailExceptionCode;
import com.openexchange.mail.mime.QuotaExceededException;
import com.openexchange.session.Session;
import com.sun.mail.iap.BadCommandException;
import com.sun.mail.iap.CommandFailedException;
import com.sun.mail.iap.ConnectionException;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.smtp.SMTPAddressFailedException;
import com.sun.mail.smtp.SMTPSendFailedException;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.PortUnreachableException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.FolderClosedException;
import javax.mail.FolderNotFoundException;
import javax.mail.IllegalWriteException;
import javax.mail.MessageRemovedException;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.NoSuchProviderException;
import javax.mail.ReadOnlyFolderException;
import javax.mail.SendFailedException;
import javax.mail.StoreClosedException;
import javax.mail.internet.AddressException;
import javax.mail.internet.ParseException;
import javax.mail.search.SearchException;
import org.apache.commons.logging.Log;

public class MimeMailException
extends OXException {
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(MimeMailException.class));
    private static final long serialVersionUID = -3401580182929349354L;
    private static final String STR_EMPTY = "";
    private static final String ERR_TMP = "temporary error, please try again later";
    private static final String ERR_AUTH_FAILED = "bad authentication failed";
    private static final String ERR_MSG_TOO_LARGE = "message too large";
    private static final String ERR_QUOTA = "quota";
    private static final String EXC_CONNECTION_RESET_EXCEPTION = "ConnectionResetException";
    private static final Object[] EMPTY_ARGS = new Object[0];
    private static final Pattern PATTERN_TAG = Pattern.compile("A[0-9]+ (.+)");

    public MimeMailException(int code, String displayMessage, Object ... displayArgs) {
        super(code, displayMessage, displayArgs);
    }

    public MimeMailException(int code, String displayMessage, Throwable cause, Object ... displayArgs) {
        super(code, displayMessage, cause, displayArgs);
    }

    public static OXException handleMessagingException(MessagingException e) {
        return MimeMailException.handleMessagingException(e, null, null);
    }

    public static OXException handleMessagingException(MessagingException e, MailConfig mailConfig) {
        return MimeMailException.handleMessagingException(e, mailConfig, mailConfig.getSession());
    }

    public static OXException handleMessagingException(MessagingException e, MailConfig mailConfig, Session session) {
        try {
            if (e instanceof AuthenticationFailedException || e.getMessage() != null && e.getMessage().toLowerCase(Locale.ENGLISH).indexOf(ERR_AUTH_FAILED) != -1) {
                if (null != mailConfig && 0 == mailConfig.getAccountId()) {
                    return MimeMailExceptionCode.LOGIN_FAILED.create(e, mailConfig.getServer(), mailConfig.getLogin());
                }
                if (e.getMessage() != null && ERR_TMP.equals(e.getMessage().toLowerCase(Locale.ENGLISH))) {
                    return MimeMailExceptionCode.LOGIN_FAILED.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
                }
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.INVALID_CREDENTIALS_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), e.getMessage());
                }
                return MimeMailExceptionCode.INVALID_CREDENTIALS.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), e.getMessage());
            }
            if (e instanceof FolderClosedException) {
                Folder f = ((FolderClosedException)e).getFolder();
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.FOLDER_CLOSED_EXT.create(e, null == f ? e.getMessage() : f.getFullName(), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.FOLDER_CLOSED.create(e, null == f ? e.getMessage() : f.getFullName());
            }
            if (e instanceof FolderNotFoundException) {
                Folder f = ((FolderNotFoundException)e).getFolder();
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.FOLDER_NOT_FOUND_EXT.create(e, null == f ? e.getMessage() : f.getFullName(), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.FOLDER_NOT_FOUND.create(e, null == f ? e.getMessage() : f.getFullName());
            }
            if (e instanceof IllegalWriteException) {
                return MimeMailExceptionCode.ILLEGAL_WRITE.create(e, e.getMessage());
            }
            if (e instanceof MessageRemovedException) {
                return MimeMailExceptionCode.MESSAGE_REMOVED.create(e, e.getMessage());
            }
            if (e instanceof MethodNotSupportedException) {
                return MimeMailExceptionCode.METHOD_NOT_SUPPORTED.create(e, e.getMessage());
            }
            if (e instanceof NoSuchProviderException) {
                return MimeMailExceptionCode.NO_SUCH_PROVIDER.create(e, e.getMessage());
            }
            if (e instanceof ParseException) {
                if (e instanceof AddressException) {
                    String optRef = ((AddressException)((Object)e)).getRef();
                    return MimeMailExceptionCode.INVALID_EMAIL_ADDRESS.create(e, optRef == null ? STR_EMPTY : optRef);
                }
                return MimeMailExceptionCode.PARSE_ERROR.create(e, e.getMessage());
            }
            if (e instanceof ReadOnlyFolderException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.READ_ONLY_FOLDER_EXT.create(e, e.getMessage(), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.READ_ONLY_FOLDER.create(e, e.getMessage());
            }
            if (e instanceof SearchException) {
                return MimeMailExceptionCode.SEARCH_ERROR.create(e, e.getMessage());
            }
            if (e instanceof SMTPSendFailedException) {
                SMTPSendFailedException exc = (SMTPSendFailedException)e;
                if (exc.getReturnCode() == 552 || exc.getMessage().toLowerCase(Locale.ENGLISH).indexOf(ERR_MSG_TOO_LARGE) > -1) {
                    return MimeMailExceptionCode.MESSAGE_TOO_LARGE.create((Throwable)exc, new Object[0]);
                }
                Address[] addrs = exc.getInvalidAddresses();
                if (null == addrs || addrs.length == 0) {
                    return MimeMailExceptionCode.SEND_FAILED_MSG.create((Throwable)exc, exc.getMessage());
                }
                return MimeMailExceptionCode.SEND_FAILED.create((Throwable)exc, Arrays.toString(exc.getInvalidAddresses()));
            }
            if (e instanceof SendFailedException) {
                Object[] addrs;
                SMTPSendFailedException smtpExc;
                Address[] invalidAddresses;
                SendFailedException exc = (SendFailedException)e;
                if (exc.getMessage().toLowerCase(Locale.ENGLISH).indexOf(ERR_MSG_TOO_LARGE) > -1) {
                    return MimeMailExceptionCode.MESSAGE_TOO_LARGE.create((Throwable)exc, new Object[0]);
                }
                Exception nextException = exc.getNextException();
                if (nextException instanceof SMTPSendFailedException && (null == (invalidAddresses = (smtpExc = (SMTPSendFailedException)nextException).getInvalidAddresses()) || invalidAddresses.length == 0)) {
                    return MimeMailExceptionCode.SEND_FAILED_MSG_EXT.create((Throwable)exc, exc.getMessage(), '(' + smtpExc.getMessage() + ')');
                }
                String serverInfo = null;
                if (nextException instanceof SMTPAddressFailedException) {
                    serverInfo = nextException.getMessage();
                }
                if (null == (addrs = exc.getInvalidAddresses()) || addrs.length == 0) {
                    return MimeMailExceptionCode.SEND_FAILED_MSG.create((Throwable)exc, exc.getMessage());
                }
                return MimeMailExceptionCode.SEND_FAILED_EXT.create((Throwable)exc, Arrays.toString(addrs), null == serverInfo ? STR_EMPTY : '(' + serverInfo + ')');
            }
            if (e instanceof StoreClosedException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.STORE_CLOSED_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), EMPTY_ARGS);
                }
                return MimeMailExceptionCode.STORE_CLOSED.create(e, EMPTY_ARGS);
            }
            Exception nextException = e.getNextException();
            if (nextException == null) {
                if (e.getMessage().toLowerCase(Locale.ENGLISH).indexOf(ERR_QUOTA) != -1) {
                    return MimeMailExceptionCode.QUOTA_EXCEEDED.create(e, EMPTY_ARGS);
                }
                if ("Unable to load BODYSTRUCTURE".equals(e.getMessage())) {
                    return MimeMailExceptionCode.MESSAGE_NOT_DISPLAYED.create(e, EMPTY_ARGS);
                }
                return MimeMailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
            }
            if (nextException instanceof BindException) {
                return MimeMailExceptionCode.BIND_ERROR.create(e, mailConfig == null ? STR_EMPTY : Integer.valueOf(mailConfig.getPort()));
            }
            if (nextException instanceof ConnectionException) {
                MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                return MimeMailExceptionCode.CONNECT_ERROR.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
            }
            if (nextException instanceof ConnectException) {
                MailServletInterface.mailInterfaceMonitor.changeNumTimeoutConnections(true);
                OXException me = MimeMailExceptionCode.CONNECT_ERROR.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
                return me;
            }
            if (nextException.getClass().getName().endsWith(EXC_CONNECTION_RESET_EXCEPTION)) {
                MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                return MimeMailExceptionCode.CONNECTION_RESET.create(e, new Object[0]);
            }
            if (nextException instanceof NoRouteToHostException) {
                return MimeMailExceptionCode.NO_ROUTE_TO_HOST.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer());
            }
            if (nextException instanceof PortUnreachableException) {
                return MimeMailExceptionCode.PORT_UNREACHABLE.create(e, mailConfig == null ? STR_EMPTY : Integer.valueOf(mailConfig.getPort()));
            }
            if (nextException instanceof SocketException) {
                SocketException se = (SocketException)nextException;
                if ("Socket closed".equals(se.getMessage()) || "Connection reset".equals(se.getMessage())) {
                    MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                    return MimeMailExceptionCode.BROKEN_CONNECTION.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer());
                }
                return MimeMailExceptionCode.SOCKET_ERROR.create(e, e.getMessage());
            }
            if (nextException instanceof UnknownHostException) {
                return MimeMailExceptionCode.UNKNOWN_HOST.create(e, e.getMessage());
            }
            if (nextException instanceof SocketTimeoutException) {
                MailServletInterface.mailInterfaceMonitor.changeNumBrokenConnections(true);
                return MimeMailExceptionCode.CONNECT_ERROR.create(e, mailConfig == null ? STR_EMPTY : mailConfig.getServer(), mailConfig == null ? STR_EMPTY : mailConfig.getLogin());
            }
            if (nextException instanceof QuotaExceededException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.QUOTA_EXCEEDED_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), nextException.getMessage());
                }
                return MimeMailExceptionCode.QUOTA_EXCEEDED.create(e, nextException.getMessage());
            }
            if (nextException instanceof CommandFailedException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.PROCESSING_ERROR_WE_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), MimeMailException.skipTag(nextException.getMessage()));
                }
                return MimeMailExceptionCode.PROCESSING_ERROR_WE.create(e, MimeMailException.skipTag(nextException.getMessage()));
            }
            if (nextException instanceof BadCommandException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.PROCESSING_ERROR_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), nextException.getMessage());
                }
                return MimeMailExceptionCode.PROCESSING_ERROR.create(e, nextException.getMessage());
            }
            if (nextException instanceof ProtocolException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.PROCESSING_ERROR_EXT.create(e, mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId(), nextException.getMessage());
                }
                return MimeMailExceptionCode.PROCESSING_ERROR.create(e, nextException.getMessage());
            }
            if (nextException instanceof IOException) {
                if (null != mailConfig && null != session) {
                    return MimeMailExceptionCode.IO_ERROR_EXT.create(e, nextException.getMessage(), mailConfig.getServer(), mailConfig.getLogin(), session.getUserId(), session.getContextId());
                }
                return MimeMailExceptionCode.IO_ERROR.create(nextException, nextException.getMessage());
            }
            if (e.getMessage().toLowerCase(Locale.ENGLISH).indexOf(ERR_QUOTA) != -1) {
                return MimeMailExceptionCode.QUOTA_EXCEEDED.create(e, EMPTY_ARGS);
            }
            return MimeMailExceptionCode.MESSAGING_ERROR.create(nextException, nextException.getMessage());
        }
        catch (Throwable t) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)t.getMessage(), t);
            }
            return MimeMailExceptionCode.MESSAGING_ERROR.create(e, e.getMessage());
        }
    }

    private static String skipTag(String serverResponse) {
        if (null == serverResponse) {
            return null;
        }
        Matcher m = PATTERN_TAG.matcher(serverResponse);
        if (m.matches()) {
            return m.group(1);
        }
        return serverResponse;
    }
}

