/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.mime;

import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.mime.MimeFilter;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.mail.BodyPart;
import javax.mail.Part;

public final class IcsMimeFilter
extends MimeFilter {
    private static final IcsMimeFilter INSTANCE = new IcsMimeFilter();
    private static final Set<String> ITIP_METHODS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("REQUEST", "CANCEL", "REPLY")));

    public static IcsMimeFilter getInstance() {
        return INSTANCE;
    }

    private IcsMimeFilter() {
        super(Arrays.asList("text/calendar", "application/ics"));
    }

    @Override
    public boolean ignorable(String contentType, BodyPart bodyPart) {
        for (String baseType : this.ignorableContentTypes) {
            if (!contentType.startsWith(baseType)) continue;
            ICalParser iCalParser = ServerServiceRegistry.getInstance().getService(ICalParser.class);
            if (iCalParser != null) {
                try {
                    String method = iCalParser.parseProperty("METHOD", MessageUtility.getPartInputStream((Part)bodyPart));
                    return null != method && ITIP_METHODS.contains(method.toUpperCase());
                }
                catch (RuntimeException e) {
                    org.apache.commons.logging.Log logger = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(IcsMimeFilter.class));
                    logger.warn((Object)"A runtime error occurred.", (Throwable)e);
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean ignorable(String contentType, MailPart bodyPart) {
        for (String baseType : this.ignorableContentTypes) {
            if (!contentType.startsWith(baseType)) continue;
            ICalParser iCalParser = ServerServiceRegistry.getInstance().getService(ICalParser.class);
            if (iCalParser != null) {
                try {
                    String method = iCalParser.parseProperty("METHOD", bodyPart.getInputStream());
                    return null != method && ITIP_METHODS.contains(method.toUpperCase());
                }
                catch (Exception e) {
                    org.apache.commons.logging.Log logger = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(IcsMimeFilter.class));
                    logger.warn((Object)"An error occurred.", (Throwable)e);
                }
            }
            return false;
        }
        return false;
    }
}

