/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json.parser;

import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.mail.dataobjects.compose.TextBodyMailPart;
import com.openexchange.mail.json.parser.AbstractAttachmentHandler;
import com.openexchange.session.Session;
import java.util.List;

public final class AbortAttachmentHandler
extends AbstractAttachmentHandler {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(AbortAttachmentHandler.class));
    private TextBodyMailPart textPart;
    private long consumed;

    public AbortAttachmentHandler(Session session) throws OXException {
        super(session);
    }

    @Override
    public void addAttachment(MailPart attachment) throws OXException {
        if (this.doAction) {
            long size = attachment.getSize();
            if (size <= 0L && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Missing size: " + size), new Throwable());
            }
            if (this.uploadQuotaPerFile > 0L && size > this.uploadQuotaPerFile) {
                String fileName = attachment.getFileName();
                throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED_FOR_FILE.create(this.uploadQuotaPerFile, null == fileName ? "" : fileName, size);
            }
            this.consumed += size;
            if (this.uploadQuota > 0L && this.consumed > this.uploadQuota) {
                throw MailExceptionCode.UPLOAD_QUOTA_EXCEEDED.create(this.uploadQuota);
            }
        }
        this.attachments.add(attachment);
    }

    @Override
    public ComposedMailMessage[] generateComposedMails(ComposedMailMessage source, List<OXException> warnings) throws OXException {
        source.setBodyPart(this.textPart);
        for (MailPart attachment : this.attachments) {
            source.addEnclosedPart(attachment);
        }
        return new ComposedMailMessage[]{source};
    }

    @Override
    public void setTextPart(TextBodyMailPart textPart) {
        this.textPart = textPart;
    }
}

