/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.json;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.exception.OXException;
import com.openexchange.mail.json.actions.AbstractMailAction;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public final class MailRequest {
    public static final int NOT_FOUND = -9999;
    private final ServerSession session;
    private final AJAXRequestData requestData;
    private static final Set<String> ALIASES_MAX = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("max", "maximum")));
    private static final Pattern SPLIT = Pattern.compile(" *, *");

    public MailRequest(AJAXRequestData request, ServerSession session) {
        this.requestData = request;
        this.session = session;
    }

    public long getMax() throws OXException {
        String s = null;
        Iterator<String> it = ALIASES_MAX.iterator();
        while (null == s && it.hasNext()) {
            s = this.requestData.getParameter(it.next());
        }
        if (null == s) {
            return -1L;
        }
        try {
            return Long.parseLong(s.trim());
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create("max", s);
        }
    }

    public String checkParameter(String name) throws OXException {
        return this.requestData.checkParameter(name);
    }

    public String getParameter(String name) {
        return this.requestData.getParameter(name);
    }

    public boolean optBool(String name) {
        return AJAXRequestDataTools.parseBoolParameter(this.requestData.getParameter(name));
    }

    public boolean optBool(String name, boolean def) {
        String parameter = this.requestData.getParameter(name);
        if (null == parameter) {
            return def;
        }
        return AJAXRequestDataTools.parseBoolParameter(parameter);
    }

    public int optInt(String name) throws OXException {
        String parameter = this.requestData.getParameter(name);
        if (null == parameter) {
            return -9999;
        }
        try {
            return Integer.parseInt(parameter.trim());
        }
        catch (NumberFormatException e) {
            throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
        }
    }

    public int[] checkIntArray(String name) throws OXException {
        String parameter = this.requestData.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        if (name.equals("columns")) {
            if (parameter.equals("all")) {
                return AbstractMailAction.COLUMNS_ALL_ALIAS;
            }
            if (parameter.equals("list")) {
                return AbstractMailAction.COLUMNS_LIST_ALIAS;
            }
        }
        String[] sa = SPLIT.split(parameter, 0);
        int[] ret = new int[sa.length];
        for (int i = 0; i < sa.length; ++i) {
            try {
                ret[i] = Integer.parseInt(sa[i].trim());
                continue;
            }
            catch (NumberFormatException e) {
                throw AjaxExceptionCodes.INVALID_PARAMETER_VALUE.create(name, parameter);
            }
        }
        return ret;
    }

    public String[] checkStringArray(String name) throws OXException {
        String parameter = this.requestData.getParameter(name);
        if (null == parameter) {
            throw AjaxExceptionCodes.MISSING_PARAMETER.create(name);
        }
        return SPLIT.split(parameter, 0);
    }

    public String[] optStringArray(String name) {
        String parameter = this.requestData.getParameter(name);
        if (null == parameter) {
            return null;
        }
        return SPLIT.split(parameter, 0);
    }

    public AJAXRequestData getRequest() {
        return this.requestData;
    }

    public ServerSession getSession() {
        return this.session;
    }
}

