/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.dataobjects.compose;

import com.openexchange.exception.OXException;
import com.openexchange.filemanagement.ManagedFile;
import com.openexchange.filemanagement.ManagedFileManagement;
import com.openexchange.java.Charsets;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.mail.config.MailConfigException;
import com.openexchange.mail.config.MailProperties;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.compose.ComposedMailPart;
import com.openexchange.mail.mime.datasource.MessageDataSource;
import com.openexchange.mail.mime.datasource.StreamDataSource;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mail.utils.MessageUtility;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.io.IOUtils;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.commons.logging.Log;

public abstract class ReferencedMailPart
extends MailPart
implements ComposedMailPart {
    private static final long serialVersionUID = 1097727980840011436L;
    private static final transient Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ReferencedMailPart.class));
    protected static final int DEFAULT_BUF_SIZE = 8192;
    private static final int MB = 0x100000;
    private final boolean isMail;
    private transient DataSource dataSource;
    private transient Object cachedContent;
    private byte[] data;
    private ManagedFile file;
    private String fileId;
    private static final String TEXT = "text/";

    protected ReferencedMailPart(MailPart referencedPart, Session session) throws OXException {
        this.isMail = referencedPart.getContentType().isMimeType("message/rfc822") && !referencedPart.getContentDisposition().isAttachment();
        try {
            this.handleReferencedPart(referencedPart, session);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    protected ReferencedMailPart(MailMessage referencedMail, Session session) throws OXException {
        this.isMail = true;
        try {
            this.handleReferencedPart(referencedMail, session);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    private void handleReferencedPart(MailPart referencedPart, Session session) throws OXException, IOException {
        long size = referencedPart.getSize();
        if (size > 0L && size <= (long)TransportProperties.getInstance().getReferencedPartLimit()) {
            if (this.isMail) {
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(16384);
                referencedPart.writeTo((OutputStream)out);
                this.data = out.toByteArray();
                this.setContentType("message/rfc822");
                this.setContentDisposition("inline");
                this.setSize(size);
            } else {
                this.copy2ByteArr(referencedPart.getInputStream());
                this.setHeaders(referencedPart);
            }
        } else {
            if (this.isMail) {
                UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(16384);
                referencedPart.writeTo((OutputStream)out);
                this.copy2File((InputStream)new UnsynchronizedByteArrayInputStream(out.toByteArray()));
                this.setContentType("message/rfc822");
                this.setContentDisposition("inline");
            } else {
                this.copy2File(referencedPart.getInputStream());
                this.setHeaders(referencedPart);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)new StringBuilder("Referenced mail part exeeds ").append(Float.valueOf(TransportProperties.getInstance().getReferencedPartLimit() / 0x100000).floatValue()).append("MB limit. A temporary disk copy has been created: ").append(this.file.getFile().getName()));
            }
        }
        if (!this.containsFileName() && referencedPart.containsFileName()) {
            this.setFileName(referencedPart.getFileName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy2File(InputStream in) throws IOException {
        try {
            ManagedFile mf;
            ManagedFileManagement mfm = ServerServiceRegistry.getInstance().getService(ManagedFileManagement.class);
            if (null == mfm) {
                throw new IOException("Missing file management");
            }
            try {
                mf = mfm.createManagedFile(in);
            }
            catch (OXException e) {
                IOException ioerr = new IOException();
                ioerr.initCause(e);
                throw ioerr;
            }
            this.setSize(mf.getSize());
            this.file = mf;
            this.fileId = mf.getID();
        }
        finally {
            IOUtils.closeStreamStuff(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy2ByteArr(InputStream in) throws IOException {
        try {
            int len;
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(16384);
            byte[] bbuf = new byte[8192];
            int totalBytes = 0;
            while ((len = in.read(bbuf)) != -1) {
                out.write(bbuf, 0, len);
                totalBytes += len;
            }
            out.flush();
            this.data = out.toByteArray();
        }
        finally {
            IOUtils.closeStreamStuff(in);
        }
    }

    private void setHeaders(MailPart referencedPart) {
        if (referencedPart.containsContentId()) {
            this.setContentId(referencedPart.getContentId());
        }
        this.setContentType(referencedPart.getContentType());
        this.setContentDisposition(referencedPart.getContentDisposition());
        this.setFileName(referencedPart.getFileName());
        if (!this.containsSize()) {
            this.setSize(referencedPart.getSize());
        }
        int count = referencedPart.getHeadersSize();
        Iterator<Map.Entry<String, String>> iter = referencedPart.getHeadersIterator();
        for (int i = 0; i < count; ++i) {
            Map.Entry<String, String> e = iter.next();
            this.addHeader(e.getKey(), e.getValue());
        }
    }

    private DataSource getDataSource() throws OXException {
        if (null == this.dataSource) {
            try {
                if (this.data != null) {
                    if (this.getContentType().startsWith(TEXT) && this.getContentType().getCharsetParameter() == null) {
                        this.getContentType().setCharsetParameter(MailProperties.getInstance().getDefaultMimeCharset());
                    }
                    this.dataSource = new MessageDataSource(this.data, this.getContentType().toString());
                    return this.dataSource;
                }
                if (this.file != null) {
                    if (this.getContentType().startsWith(TEXT) && this.getContentType().getCharsetParameter() == null) {
                        this.getContentType().setCharsetParameter(System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset()));
                    }
                    final ManagedFile managedFile = this.file;
                    StreamDataSource.InputStreamProvider isp = new StreamDataSource.InputStreamProvider(){

                        @Override
                        public InputStream getInputStream() throws IOException {
                            try {
                                return managedFile.getInputStream();
                            }
                            catch (OXException e) {
                                IOException err = new IOException();
                                err.initCause(e);
                                throw err;
                            }
                        }

                        @Override
                        public String getName() {
                            return null;
                        }
                    };
                    this.dataSource = new StreamDataSource(isp, this.getContentType().toString());
                    return this.dataSource;
                }
                throw MailExceptionCode.NO_CONTENT.create();
            }
            catch (MailConfigException e) {
                LOG.error((Object)e.getMessage(), (Throwable)((Object)e));
                this.dataSource = new MessageDataSource(new byte[0], "application/octet-stream");
            }
        }
        return this.dataSource;
    }

    @Override
    public Object getContent() throws OXException {
        if (this.cachedContent != null) {
            return this.cachedContent;
        }
        if (this.getContentType().isMimeType("text/*")) {
            if (this.data != null) {
                String charset = this.getContentType().getCharsetParameter();
                if (null == charset) {
                    charset = MailProperties.getInstance().getDefaultMimeCharset();
                }
                this.applyByteContent(charset);
                return this.cachedContent;
            }
            if (this.file != null) {
                String charset = this.getContentType().getCharsetParameter();
                if (null == charset) {
                    charset = System.getProperty("file.encoding", MailProperties.getInstance().getDefaultMimeCharset());
                }
                this.applyFileContent(charset);
                return this.cachedContent;
            }
        }
        return null;
    }

    private void applyFileContent(String charset) throws OXException {
        InputStream fis = null;
        try {
            fis = this.file.getInputStream();
            this.cachedContent = MessageUtility.readStream(fis, charset);
        }
        catch (IOException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void applyByteContent(String charset) throws OXException {
        try {
            this.cachedContent = new String(this.data, Charsets.forName((String)charset));
        }
        catch (UnsupportedCharsetException e) {
            throw MailExceptionCode.ENCODING_ERROR.create(e, e.getMessage());
        }
    }

    @Override
    public DataHandler getDataHandler() throws OXException {
        return new DataHandler(this.getDataSource());
    }

    @Override
    public int getEnclosedCount() throws OXException {
        return -1;
    }

    @Override
    public MailPart getEnclosedMailPart(int index) throws OXException {
        return null;
    }

    @Override
    public InputStream getInputStream() throws OXException {
        try {
            if (this.data != null) {
                return new UnsynchronizedByteArrayInputStream(this.data);
            }
            if (this.file != null) {
                return this.file.getInputStream();
            }
            throw MailExceptionCode.NO_CONTENT.create();
        }
        catch (OXException e) {
            throw new OXException(e);
        }
    }

    @Override
    public void loadContent() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"ReferencedMailPart.loadContent()");
        }
    }

    @Override
    public void prepareForCaching() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"ReferencedMailPart.prepareForCaching()");
        }
    }

    public String getFileID() {
        return this.fileId;
    }

    public boolean isMail() {
        return this.isMail;
    }

    private static String randomUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public ComposedMailPart.ComposedPartType getType() {
        return ComposedMailPart.ComposedPartType.REFERENCE;
    }
}

