/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.cache;

import com.openexchange.caching.CacheService;
import com.openexchange.config.ConfigurationService;
import com.openexchange.configuration.ConfigurationExceptionCodes;
import com.openexchange.exception.OXException;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.MailExceptionCode;
import com.openexchange.server.Initialization;
import com.openexchange.server.services.ServerServiceRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public final class MailCacheConfiguration
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailCacheConfiguration.class));
    private static final MailCacheConfiguration instance = new MailCacheConfiguration();
    private final AtomicBoolean started = new AtomicBoolean();

    private MailCacheConfiguration() {
    }

    public static MailCacheConfiguration getInstance() {
        return instance;
    }

    private void configure() throws OXException {
        File cacheConfigFile = ServerServiceRegistry.getInstance().getService(ConfigurationService.class).getFileByName("mailcache.ccf");
        if (cacheConfigFile == null) {
            throw ConfigurationExceptionCodes.PROPERTY_MISSING.create("mailcache.ccf");
        }
        try {
            ServerServiceRegistry.getInstance().getService(CacheService.class).loadConfiguration((InputStream)new FileInputStream(cacheConfigFile));
        }
        catch (FileNotFoundException e) {
            throw MailExceptionCode.IO_ERROR.create(e, e.getMessage());
        }
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.warn((Object)(MailCacheConfiguration.class.getSimpleName() + " has already been started. Aborting."));
        }
        this.configure();
    }

    public void stop() {
        CacheService cacheService;
        if (!this.started.compareAndSet(true, false)) {
            LOG.warn((Object)(MailCacheConfiguration.class.getSimpleName() + " has already been stopped. Aborting."));
        }
        if (null != (cacheService = ServerServiceRegistry.getInstance().getService(CacheService.class))) {
            try {
                cacheService.freeCache("MailMessageCache");
            }
            catch (OXException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }
}

