/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.i18n.tools.replacement;

import com.openexchange.i18n.tools.TemplateReplacement;
import com.openexchange.i18n.tools.TemplateToken;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TimeZone;

public class StringReplacement
implements TemplateReplacement {
    private final TemplateToken token;
    private String replacement;
    private boolean changed;
    private static final EnumSet<TemplateToken> IRRELEVANT = EnumSet.of(TemplateToken.FOLDER_ID, TemplateToken.FOLDER_NAME, TemplateToken.LINK, TemplateToken.UI_WEB_PATH);

    public StringReplacement(TemplateToken token, String replacement) {
        this(token, replacement, false);
    }

    public StringReplacement(TemplateToken token, String replacement, boolean changed) {
        this.token = token;
        this.replacement = replacement;
        this.changed = changed;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public TemplateReplacement getClone() throws CloneNotSupportedException {
        return (TemplateReplacement)this.clone();
    }

    @Override
    public String getReplacement() {
        return this.replacement;
    }

    @Override
    public TemplateToken getToken() {
        return this.token;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    public boolean relevantChange() {
        return !IRRELEVANT.contains((Object)this.token);
    }

    @Override
    public TemplateReplacement setChanged(boolean changed) {
        this.changed = changed;
        return this;
    }

    @Override
    public TemplateReplacement setLocale(Locale locale) {
        return this;
    }

    @Override
    public TemplateReplacement setTimeZone(TimeZone timeZone) {
        return this;
    }

    @Override
    public boolean merge(TemplateReplacement other) {
        if (!StringReplacement.class.isInstance(other)) {
            return false;
        }
        if (!this.getToken().equals((Object)other.getToken())) {
            return false;
        }
        if (!other.changed()) {
            return false;
        }
        StringReplacement o = (StringReplacement)other;
        this.replacement = o.replacement;
        this.changed = true;
        return true;
    }
}

