/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.userconfiguration;

import com.openexchange.configuration.SystemConfig;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.userconfiguration.CachingUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.RdbUserConfigurationStorage;
import com.openexchange.groupware.userconfiguration.UserConfigurationCodes;
import com.openexchange.groupware.userconfiguration.UserConfigurationStorage;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.server.Initialization;
import java.util.concurrent.atomic.AtomicBoolean;

public final class UserConfigurationStorageInit
implements Initialization {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(UserConfigurationStorageInit.class));
    private static UserConfigurationStorageInit instance = new UserConfigurationStorageInit();
    private final AtomicBoolean started = new AtomicBoolean();

    public static UserConfigurationStorageInit getInstance() {
        return instance;
    }

    private UserConfigurationStorageInit() {
    }

    private static String getUserConfigurationImpl(String alias) {
        UserConfigurationImpl[] arr = UserConfigurationImpl.values();
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].alias.equalsIgnoreCase(alias)) continue;
            return arr[i].impl;
        }
        return null;
    }

    public void start() throws OXException {
        if (!this.started.compareAndSet(false, true)) {
            LOG.error((Object)(UserConfigurationStorageInit.class.getName() + " already started"));
            return;
        }
        String classNameProp = SystemConfig.getProperty(SystemConfig.Property.USER_CONF_STORAGE);
        if (null == classNameProp) {
            throw UserConfigurationCodes.MISSING_SETTING.create(SystemConfig.Property.USER_CONF_STORAGE.getPropertyName());
        }
        try {
            String className = UserConfigurationStorageInit.getUserConfigurationImpl(classNameProp);
            Class<UserConfigurationStorage> implementingClass = Class.forName(className == null ? classNameProp : className).asSubclass(UserConfigurationStorage.class);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("UserConfigurationStorage implementation: " + implementingClass.getName()));
            }
            UserConfigurationStorage.setInstance(implementingClass.newInstance());
            this.started.set(true);
        }
        catch (ClassNotFoundException e) {
            throw UserConfigurationCodes.CLASS_NOT_FOUND.create(e, classNameProp);
        }
        catch (ClassCastException e) {
            throw UserConfigurationCodes.CLASS_NOT_FOUND.create(e, classNameProp);
        }
        catch (InstantiationException e) {
            throw UserConfigurationCodes.CLASS_NOT_FOUND.create(e, classNameProp);
        }
        catch (IllegalAccessException e) {
            throw UserConfigurationCodes.CLASS_NOT_FOUND.create(e, classNameProp);
        }
    }

    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.error((Object)(UserConfigurationStorageInit.class.getName() + " cannot be stopped since it has not been started before"));
            return;
        }
        UserConfigurationStorage.releaseInstance();
    }

    private static enum UserConfigurationImpl {
        CACHING("Caching", CachingUserConfigurationStorage.class.getName()),
        DB("DB", RdbUserConfigurationStorage.class.getName());

        private final String alias;
        private final String impl;

        private UserConfigurationImpl(String alias, String impl) {
            this.alias = alias;
            this.impl = impl;
        }

        public String getAlias() {
            return this.alias;
        }

        public String getImpl() {
            return this.impl;
        }
    }
}

