/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tools.console;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.tools.Constants;
import com.openexchange.management.console.JMXAuthenticatorImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public final class UpdateTaskResetVersionCLT {
    private static final Options toolkitOptions = new Options();

    private static void printHelp() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("resetVersion", toolkitOptions);
    }

    private UpdateTaskResetVersionCLT() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        PosixParser parser = new PosixParser();
        int contextId = -1;
        String schemaName = null;
        try {
            HashMap<String, JMXAuthenticatorImpl> environment;
            String optionValue;
            String val;
            CommandLine cmd = parser.parse(toolkitOptions, args);
            if (cmd.hasOption('h')) {
                UpdateTaskResetVersionCLT.printHelp();
                System.exit(0);
            }
            int port = 9999;
            if (cmd.hasOption('p') && null != (val = cmd.getOptionValue('p'))) {
                try {
                    port = Integer.parseInt(val.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + val);
                    UpdateTaskResetVersionCLT.printHelp();
                    System.exit(0);
                }
                if (port < 1 || port > 65535) {
                    System.err.println("Port parameter is out of range: " + val + ". Valid range is from 1 to 65535.");
                    UpdateTaskResetVersionCLT.printHelp();
                    System.exit(0);
                }
            }
            int version2 = -1;
            if (!cmd.hasOption('v')) {
                System.err.println("Missing version number.");
                UpdateTaskResetVersionCLT.printHelp();
                System.exit(0);
            } else {
                optionValue = cmd.getOptionValue('v');
                try {
                    version2 = Integer.parseInt(optionValue.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Port parameter is not a number: " + optionValue);
                    System.exit(0);
                }
            }
            if (!cmd.hasOption('c')) {
                if (!cmd.hasOption('n')) {
                    System.err.println("Missing context/schema identifier.");
                    UpdateTaskResetVersionCLT.printHelp();
                    System.exit(0);
                }
                schemaName = cmd.getOptionValue('n');
            } else {
                optionValue = cmd.getOptionValue('c');
                try {
                    contextId = Integer.parseInt(optionValue.trim());
                }
                catch (NumberFormatException e) {
                    System.err.println("Context parameter is not a number: " + optionValue);
                    UpdateTaskResetVersionCLT.printHelp();
                    System.exit(0);
                }
            }
            String jmxLogin = null;
            if (cmd.hasOption('l')) {
                jmxLogin = cmd.getOptionValue('l');
            }
            String jmxPassword = null;
            if (cmd.hasOption('s')) {
                jmxPassword = cmd.getOptionValue('s');
            }
            if (jmxLogin == null || jmxPassword == null) {
                environment = null;
            } else {
                environment = new HashMap<String, JMXAuthenticatorImpl>(1);
                environment.put("jmx.remote.authenticator", new JMXAuthenticatorImpl(jmxLogin, jmxPassword));
            }
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:" + port + "/server");
            JMXConnector jmxConnector = JMXConnectorFactory.connect(url, environment);
            try {
                MBeanServerConnection mbsc = jmxConnector.getMBeanServerConnection();
                String param = null == schemaName ? String.valueOf(contextId) : schemaName;
                mbsc.invoke(Constants.OBJECT_NAME, "resetVersion", new Object[]{version2, param}, null);
                if (cmd.hasOption('r')) {
                    mbsc.invoke(Constants.OBJECT_NAME, "runUpdate", new Object[]{param}, null);
                }
            }
            finally {
                jmxConnector.close();
            }
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line: " + e.getMessage());
            UpdateTaskResetVersionCLT.printHelp();
        }
        catch (MalformedURLException e) {
            System.err.println("URL to connect to server is invalid: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to communicate with the server: " + e.getMessage());
        }
        catch (InstanceNotFoundException e) {
            System.err.println("Instance is not available: " + e.getMessage());
        }
        catch (MBeanException e) {
            Throwable t = e.getCause();
            String message = null == t ? e.getMessage() : (t instanceof OXException ? "Cannot find context " + contextId : t.getMessage());
            System.err.println(null == message ? "Unexpected error." : "Unexpected error: " + message);
        }
        catch (ReflectionException e) {
            System.err.println("Problem with reflective type handling: " + e.getMessage());
        }
        catch (RuntimeException e) {
            System.err.println("Problem in runtime: " + e.getMessage());
            UpdateTaskResetVersionCLT.printHelp();
        }
    }

    static {
        toolkitOptions.addOption("h", "help", false, "Prints a help text");
        toolkitOptions.addOption("v", "version", true, "The version number to set");
        toolkitOptions.addOption("c", "context", true, "A valid context identifier contained in target schema");
        toolkitOptions.addOption("n", "name", true, "A valid schema name. This option is a substitute for '-c/--context' option. If both are present '-c/--context' is preferred.");
        toolkitOptions.addOption("r", "run", false, "A flag indicating whether to trigger update process for target schema after version reset.");
        toolkitOptions.addOption("p", "port", true, "The optional JMX port (default:9999)");
        toolkitOptions.addOption("l", "login", true, "The optional JMX login (if JMX has authentication enabled)");
        toolkitOptions.addOption("s", "password", true, "The optional JMX password (if JMX has authentication enabled)");
    }
}

