/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.Schema;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTask;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MailAccountCreateTablesTask
implements UpdateTask {
    private static final org.apache.commons.logging.Log LOG = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(MailAccountCreateTablesTask.class));
    private static final String[] types = new String[]{"TABLE"};

    @Override
    public int addedWithVersion() {
        return 40;
    }

    @Override
    public int getPriority() {
        return UpdateTask.UpdateTaskPriority.HIGHEST.priority;
    }

    private static final String getCreateMailAccount() {
        return "CREATE TABLE `user_mail_account` (id INT4 unsigned NOT NULL,cid INT4 unsigned NOT NULL,user INT4 unsigned NOT NULL,name VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,url VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,login varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,password VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,primary_addr VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,personal VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,replyTo VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,default_flag TINYINT unsigned NOT NULL default 0,spam_handler VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,trash VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,sent VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,drafts VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,spam VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,confirmed_spam VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,confirmed_ham VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,unified_inbox TINYINT unsigned default 0,trash_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,sent_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,drafts_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,spam_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,confirmed_spam_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,confirmed_ham_fullname VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY  (cid, id, user),INDEX (cid, user)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    private static final String getCreateTransportAccount() {
        return "CREATE TABLE `user_transport_account` (id INT4 unsigned NOT NULL,cid INT4 unsigned NOT NULL,user INT4 unsigned NOT NULL,name VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,url VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,login varchar(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,password VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,send_addr VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,personal VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,replyTo VARCHAR(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,default_flag TINYINT unsigned NOT NULL default 0,unified_inbox TINYINT unsigned default 0,PRIMARY KEY  (cid, id, user),INDEX (cid, user)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    private static final String getCreateMailAccountProperties() {
        return "CREATE TABLE user_mail_account_properties (id INT4 unsigned NOT NULL,cid INT4 unsigned NOT NULL,user INT4 unsigned NOT NULL,name VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,value VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY  (cid, id, user, name)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getCreateTransportAccountProperties() {
        return "CREATE TABLE user_transport_account_properties (id INT4 unsigned NOT NULL,cid INT4 unsigned NOT NULL,user INT4 unsigned NOT NULL,name VARCHAR(128) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,value VARCHAR(256) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL,PRIMARY KEY  (cid, id, user, name)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;";
    }

    private static final String getCreateSequence() {
        return "CREATE TABLE sequence_mail_service (cid INT4 unsigned NOT NULL,id INT4 unsigned NOT NULL,PRIMARY KEY (cid)) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci";
    }

    @Override
    public void perform(Schema schema, int contextId) throws OXException {
        MailAccountCreateTablesTask.createTable("sequence_mail_service", MailAccountCreateTablesTask.getCreateSequence(), contextId);
        MailAccountCreateTablesTask.createTable("user_mail_account", MailAccountCreateTablesTask.getCreateMailAccount(), contextId);
        MailAccountCreateTablesTask.createTable("user_mail_account_properties", MailAccountCreateTablesTask.getCreateMailAccountProperties(), contextId);
        MailAccountCreateTablesTask.createTable("user_transport_account", MailAccountCreateTablesTask.getCreateTransportAccount(), contextId);
        MailAccountCreateTablesTask.createTable("user_transport_account_properties", MailAccountCreateTablesTask.getCreateTransportAccountProperties(), contextId);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"UpdateTask 'MailAccountCreateTablesTask' successfully performed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTable(String tablename, String sqlCreate, int contextId) throws OXException {
        PreparedStatement stmt;
        Connection writeCon;
        block5: {
            writeCon = Database.get(contextId, true);
            stmt = null;
            if (!MailAccountCreateTablesTask.tableExists(tablename, writeCon.getMetaData())) break block5;
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
            return;
        }
        try {
            try {
                stmt = writeCon.prepareStatement(sqlCreate);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                throw MailAccountCreateTablesTask.createSQLError(e);
            }
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(null, stmt);
            Database.back(contextId, true, writeCon);
            throw throwable;
        }
        DBUtils.closeSQLStuff(null, stmt);
        Database.back(contextId, true, writeCon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean tableExists(String tableName, DatabaseMetaData dbmd) throws SQLException {
        boolean bl;
        ResultSet resultSet = null;
        try {
            resultSet = dbmd.getTables(null, null, tableName, types);
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(resultSet, null);
            throw throwable;
        }
        DBUtils.closeSQLStuff(resultSet, null);
        return bl;
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

