/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update.tasks;

import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.log.Log;
import com.openexchange.log.LogFactory;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;

public final class FolderAddIndex2LastModified
extends UpdateTaskAdapter {
    @Override
    public String[] getDependencies() {
        return new String[0];
    }

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = Database.getNoTimeout(contextId, true);
        try {
            con.setAutoCommit(false);
            this.createMyIndex(con, new String[]{"oxfolder_tree", "del_oxfolder_tree"}, "lastModifiedIndex");
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw FolderAddIndex2LastModified.createSQLError(e);
        }
        finally {
            DBUtils.autocommit(con);
            Database.backNoTimeout(contextId, true, con);
        }
    }

    private void createMyIndex(Connection con, String[] tables, String name) {
        org.apache.commons.logging.Log log = Log.valueOf((org.apache.commons.logging.Log)LogFactory.getLog(FolderAddIndex2LastModified.class));
        String[] columns = new String[]{"cid", "changing_date", "module"};
        StringBuilder sb = new StringBuilder(64);
        for (String table : tables) {
            try {
                String indexName = Tools.existsIndex(con, table, columns);
                if (null == indexName) {
                    if (log.isInfoEnabled()) {
                        sb.setLength(0);
                        sb.append("Creating new index named \"");
                        sb.append(name);
                        sb.append("\" with columns (cid, changing_date, module) on table ");
                        sb.append(table);
                        sb.append('.');
                        log.info((Object)sb.toString());
                    }
                    Tools.createIndex(con, table, name, columns, false);
                    continue;
                }
                if (!log.isInfoEnabled()) continue;
                sb.setLength(0);
                sb.append("New index named \"");
                sb.append(indexName);
                sb.append("\" with columns (cid, changing_date, module)");
                sb.append(" already exists on table ");
                sb.append(table);
                sb.append('.');
                log.info((Object)sb.toString());
            }
            catch (SQLException e) {
                log.error((Object)("Problem adding index " + name + " on table " + table + '.'), (Throwable)e);
            }
        }
    }

    private static OXException createSQLError(SQLException e) {
        return UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
    }
}

