/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;

public enum UpdateExceptionCodes implements OXExceptionCode
{
    ONLY_REDUCE("The current version number %1$s is already lower than or equal to the desired version number %2$s.", Category.CATEGORY_USER_INPUT, 13),
    SQL_PROBLEM("A SQL problem occurred: %1$s.", Category.CATEGORY_ERROR, 14),
    LOADING_TASK_FAILED("Error loading update task \"%1$s\".", Category.CATEGORY_USER_INPUT, 15),
    UNKNOWN_SCHEMA("Unknown schema name: %1$s.", Category.CATEGORY_USER_INPUT, 16),
    UNKNOWN_CONCURRENCY("Update task %1$s returned an unknown concurrency level. Running as blocking task.", Category.CATEGORY_ERROR, 17),
    RESET_FORBIDDEN("The version can not be set back if the update tasks handling has been migrated to the Remember Executed Update Tasks concept on schema %1$s.", Category.CATEGORY_USER_INPUT, 18),
    UNRESOLVABLE_DEPENDENCIES("Unable to determine next update task to execute. Executed: %1$s. Enqueued: %2$s. Scheduled: %3$s.", Category.CATEGORY_ERROR, 19),
    OTHER_PROBLEM("%1$s", Category.CATEGORY_ERROR, 20),
    WRONG_ROW_COUNT("Processed a wrong number of rows in database. Expected %1$d rows but worked on %2$d rows.", Category.CATEGORY_ERROR, 21),
    UPDATE_FAILED("Updating schema %1$s failed. Cause: %2$s.", Category.CATEGORY_ERROR, 22),
    BLOCKING_FIRST("Blocking tasks (%1$s) must be executed before background tasks can be executed (%2$s).", Category.CATEGORY_ERROR, 23),
    UNKNOWN_TASK("Unknown task: %1$s.", Category.CATEGORY_CONFIGURATION, 24),
    COLUMN_NOT_FOUND("Column \"%1$s\" not found in table %2$s.", Category.CATEGORY_ERROR, 25),
    UNEXPECTED_ERROR("An error occurred: %1$s", Category.CATEGORY_ERROR, 26);

    final String message;
    final Category category;
    final int number;

    private UpdateExceptionCodes(String message, Category category, int number) {
        this.message = message;
        this.category = category;
        this.number = number;
    }

    public String getPrefix() {
        return "UPD";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.number;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

