/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class SimpleTableCreationTask
extends UpdateTaskAdapter {
    private final DatabaseService dbService;

    public SimpleTableCreationTask(DatabaseService dbService) {
        this.dbService = dbService;
    }

    protected abstract String getStatement();

    protected abstract String getTableName();

    @Override
    public void perform(PerformParameters params) throws OXException {
        int contextId = params.getContextId();
        Connection con = this.dbService.getForUpdateTask(contextId);
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        try {
            this.innerPerform(con);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        finally {
            DBUtils.autocommit(con);
            this.dbService.backForUpdateTask(contextId, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void innerPerform(Connection con) throws SQLException {
        if (Tools.tableExists(con, this.getTableName())) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = con.createStatement();
            stmt.execute(this.getStatement());
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    public DatabaseService getDbService() {
        return this.dbService;
    }
}

