/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.tasks;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tasks.FolderStorage;
import com.openexchange.groupware.tasks.Permission;
import com.openexchange.groupware.tasks.StorageType;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.groupware.tasks.TaskStorage;
import com.openexchange.groupware.tasks.Tools;
import com.openexchange.groupware.userconfiguration.UserConfiguration;

public class TaskAuthorization
implements AttachmentAuthorization {
    @Override
    public void checkMayAttach(int folderId, int taskId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        FolderStorage foldStor = FolderStorage.getInstance();
        Task task = storage.selectTask(ctx, taskId, StorageType.ACTIVE);
        task.setParentFolderID(folderId);
        FolderObject folder = Tools.getFolder(ctx, folderId);
        Permission.checkWriteInFolder(ctx, user, userConfig, folder, task);
        foldStor.selectFolderById(ctx, taskId, folderId, StorageType.ACTIVE);
    }

    @Override
    public void checkMayDetach(int folderId, int taskId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        this.checkMayAttach(folderId, taskId, user, userConfig, ctx);
    }

    @Override
    public void checkMayReadAttachments(int folderId, int taskId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        TaskStorage storage = TaskStorage.getInstance();
        FolderObject folder = Tools.getFolder(ctx, folderId);
        Task task = storage.selectTask(ctx, taskId, StorageType.ACTIVE);
        Permission.canReadInFolder(ctx, user, userConfig, folder, task);
    }
}

