/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.settings.IValueHandler;
import com.openexchange.groupware.settings.Setting;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.mail.usersetting.UserSettingMail;
import com.openexchange.mail.usersetting.UserSettingMailStorage;
import com.openexchange.session.Session;

public abstract class AbstractMailFuncs
implements IValueHandler {
    protected AbstractMailFuncs() {
    }

    @Override
    public void getValue(Session session, Context ctx, User user, UserConfiguration userConfig, Setting setting) throws OXException {
        UserSettingMail settings;
        try {
            settings = UserSettingMailStorage.getInstance().loadUserSettingMail(user.getId(), ctx);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        if (userConfig.hasWebMail()) {
            setting.setSingleValue(this.isSet(settings));
        }
    }

    protected abstract Object isSet(UserSettingMail var1);

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public void writeValue(Session session, Context ctx, User user, Setting setting) throws OXException {
        UserSettingMailStorage storage = UserSettingMailStorage.getInstance();
        int userId = user.getId();
        UserSettingMail settings = storage.loadUserSettingMail(userId, ctx);
        this.setValue(settings, setting.getSingleValue().toString());
        storage.saveUserSettingMailBits(settings, userId, ctx);
    }

    protected abstract void setValue(UserSettingMail var1, String var2);

    @Override
    public int getId() {
        return -1;
    }
}

