/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.settings;

import com.openexchange.exception.Category;
import com.openexchange.exception.OXException;
import com.openexchange.exception.OXExceptionCode;
import com.openexchange.exception.OXExceptionFactory;
import com.openexchange.groupware.settings.SettingExceptionMessage;

public enum SettingExceptionCodes implements OXExceptionCode
{
    NO_CONNECTION("Cannot get connection to database.", Category.CATEGORY_SERVICE_DOWN, 1),
    SQL_ERROR(SettingExceptionMessage.SQL_ERROR, Category.CATEGORY_ERROR, 2),
    NO_WRITE("Writing the setting %1$s is not permitted.", Category.CATEGORY_PERMISSION_DENIED, 3),
    UNKNOWN_PATH("Unknown setting path %1$s.", Category.CATEGORY_ERROR, 4),
    NOT_LEAF("Setting \"%1$s\" is not a leaf.", Category.CATEGORY_ERROR, 5),
    JSON_READ_ERROR("Exception while parsing JSON.", Category.CATEGORY_ERROR, 6),
    INIT("Problem while initialising configuration tree.", Category.CATEGORY_ERROR, 8),
    INVALID_VALUE("Invalid value %s written to setting %s.", Category.CATEGORY_USER_INPUT, 9),
    DUPLICATE_ID("Found duplicate database identifier %d. Not adding preferences item.", Category.CATEGORY_ERROR, 10),
    DUPLICATE_PATH("Found duplicate path %s.", Category.CATEGORY_ERROR, 12),
    SUBSYSTEM("Error during use of a subsystem", Category.CATEGORY_SERVICE_DOWN, 13),
    NOT_ALLOWED("Not allowed operation.", Category.CATEGORY_ERROR, 14),
    MAX_RETRY("Reached maximum retries for writing the setting %s.", Category.CATEGORY_TRY_AGAIN, 15);

    private final String message;
    private final Category category;
    private final int detailNumber;

    private SettingExceptionCodes(String message, Category category, int detailNumber) {
        this.message = message;
        this.category = category;
        this.detailNumber = detailNumber;
    }

    public String getPrefix() {
        return "USS";
    }

    public Category getCategory() {
        return this.category;
    }

    public int getNumber() {
        return this.detailNumber;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(OXException e) {
        return OXExceptionFactory.getInstance().equals((OXExceptionCode)this, e);
    }

    public OXException create() {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, new Object[0]);
    }

    public OXException create(Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, (Throwable)null, args);
    }

    public OXException create(Throwable cause, Object ... args) {
        return OXExceptionFactory.getInstance().create((OXExceptionCode)this, cause, args);
    }
}

