/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.ldap;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.impl.IDGenerator;
import com.openexchange.groupware.ldap.LdapExceptionCode;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserExceptionCode;
import com.openexchange.groupware.ldap.UserImpl;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.mail.mime.QuotedInternetAddress;
import com.openexchange.passwordchange.PasswordMechanism;
import com.openexchange.server.impl.DBPool;
import com.openexchange.tools.Collections;
import com.openexchange.tools.StringCollection;
import com.openexchange.tools.arrays.Arrays;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class RdbUserStorage
extends UserStorage {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(RdbUserStorage.class));
    private static final String SELECT_ALL_USER = "SELECT id,userPassword,mailEnabled,imapServer,imapLogin,smtpServer,mailDomain,shadowLastChange,mail,timeZone,preferredLanguage,passwordMech,contactId FROM user WHERE user.cid=?";
    private static final String SELECT_USER = "SELECT id,userPassword,mailEnabled,imapServer,imapLogin,smtpServer,mailDomain,shadowLastChange,mail,timeZone,preferredLanguage,passwordMech,contactId FROM user WHERE user.cid=? AND id IN (";
    private static final String SELECT_ATTRS = "SELECT id,name,value FROM user_attribute WHERE cid=? AND id IN (";
    private static final String SELECT_CONTACT = "SELECT intfield01,field03,field02,field01 FROM prg_contacts WHERE cid=? AND intfield01 IN (";
    private static final String SELECT_ID = "SELECT id FROM login2user WHERE cid=? AND uid=?";
    private static final String SELECT_LOGIN = "SELECT id,uid FROM login2user where cid=? AND id IN (";
    private static final String SELECT_IMAPLOGIN = "SELECT id FROM user WHERE cid=? AND imapLogin=?";
    private static final String SQL_UPDATE_PASSWORD = "UPDATE user SET userPassword = ?, shadowLastChange = ? WHERE cid = ? AND id = ?";
    private static final String INSERT_USER = "INSERT INTO user (cid, id, imapServer, imapLogin, mail, mailDomain, mailEnabled, preferredLanguage, shadowLastChange, smtpServer, timeZone, userPassword, contactId, passwordMech, uidNumber, gidNumber, homeDirectory, loginShell) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String INSERT_ATTRIBUTES = "INSERT INTO user_attribute (cid, id, name, value) VALUES (?, ?, ?, ?)";
    private static final String INSERT_LOGIN_INFO = "INSERT INTO login2user (cid, id, uid) VALUES (?, ?, ?)";
    private static final int MAX_RETRY = 3;

    @Override
    public int getUserId(String uid, Context context) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (OXException e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        int userId = -1;
        try {
            stmt = con.prepareStatement(SELECT_ID);
            stmt.setInt(1, context.getContextId());
            stmt.setString(2, uid);
            result = stmt.executeQuery();
            if (!result.next()) {
                throw LdapExceptionCode.USER_NOT_FOUND.create(uid, Autoboxing.I((int)context.getContextId())).setPrefix("USR");
            }
            userId = result.getInt(1);
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return userId;
    }

    @Override
    public int createUser(Connection con, Context context, User user) throws OXException {
        int n;
        PreparedStatement stmt = null;
        try {
            int userId = IDGenerator.getId(context, 130, con);
            stmt = con.prepareStatement(INSERT_USER);
            int i = 1;
            stmt.setInt(i++, context.getContextId());
            stmt.setInt(i++, userId);
            this.setStringOrNull(i++, stmt, user.getImapServer());
            this.setStringOrNull(i++, stmt, user.getImapLogin());
            this.setStringOrNull(i++, stmt, user.getMail());
            this.setStringOrNull(i++, stmt, user.getMailDomain());
            stmt.setInt(i++, 1);
            this.setStringOrNull(i++, stmt, user.getPreferredLanguage());
            stmt.setInt(i++, user.getShadowLastChange());
            this.setStringOrNull(i++, stmt, user.getSmtpServer());
            this.setStringOrNull(i++, stmt, user.getTimeZone());
            this.setStringOrNull(i++, stmt, user.getUserPassword());
            stmt.setInt(i++, user.getContactId());
            this.setStringOrNull(i++, stmt, user.getPasswordMech());
            stmt.setInt(i++, 0);
            stmt.setInt(i++, 0);
            this.setStringOrNull(i++, stmt, "/home/" + user.getGivenName());
            this.setStringOrNull(i++, stmt, "/bin/bash");
            stmt.executeUpdate();
            this.writeLoginInfo(con, user, context, userId);
            this.writeUserAttributes(con, user, context, userId);
            n = userId;
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, new Object[0]);
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(stmt);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLoginInfo(Connection con, User user, Context context, int userId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_LOGIN_INFO);
            stmt.setInt(1, context.getContextId());
            stmt.setInt(2, userId);
            stmt.setString(3, user.getLoginInfo());
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUserAttributes(Connection con, User user, Context context, int userId) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(INSERT_ATTRIBUTES);
            Map<String, Set<String>> attributes = user.getAttributes();
            for (String key : attributes.keySet()) {
                Set<String> valueSet = attributes.get(key);
                for (String value : valueSet) {
                    stmt.setInt(1, context.getContextId());
                    stmt.setInt(2, userId);
                    stmt.setString(3, key);
                    stmt.setString(4, value);
                    stmt.addBatch();
                }
            }
            stmt.executeBatch();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int createUser(Context context, User user) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
            int n = this.createUser(con, context, user);
            return n;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    private void setStringOrNull(int parameter, PreparedStatement stmt, String value) throws SQLException {
        if (value == null) {
            stmt.setNull(parameter, 12);
        } else {
            stmt.setString(parameter, value);
        }
    }

    @Override
    public User getUser(int userId, Context context) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup(context);
        }
        catch (OXException e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
        }
        try {
            User e = this.getUser(context, con, new int[]{userId})[0];
            return e;
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    @Override
    public User getUser(Context ctx, int userId, Connection con) throws OXException {
        return this.getUser(ctx, con, new int[]{userId})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User[] getUser(Context ctx, Connection con, int[] userIds) throws OXException {
        int length = userIds.length;
        if (0 == length) {
            return new User[0];
        }
        HashMap<Integer, UserImpl> users = new HashMap<Integer, UserImpl>(length);
        try {
            for (int i = 0; i < userIds.length; i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int[] currentUserIds = Arrays.extract((int[])userIds, (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_USER, currentUserIds.length));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    for (int userId : currentUserIds) {
                        stmt.setInt(pos++, userId);
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        UserImpl user = new UserImpl();
                        pos = 1;
                        user.setId(result.getInt(pos++));
                        user.setUserPassword(result.getString(pos++));
                        user.setMailEnabled(result.getBoolean(pos++));
                        user.setImapServer(result.getString(pos++));
                        user.setImapLogin(result.getString(pos++));
                        user.setSmtpServer(result.getString(pos++));
                        user.setMailDomain(result.getString(pos++));
                        user.setShadowLastChange(result.getInt(pos++));
                        if (result.wasNull()) {
                            user.setShadowLastChange(-1);
                        }
                        user.setMail(result.getString(pos++));
                        user.setTimeZone(result.getString(pos++));
                        user.setPreferredLanguage(result.getString(pos++));
                        user.setPasswordMech(result.getString(pos++));
                        user.setContactId(result.getInt(pos++));
                        users.put(Autoboxing.I((int)user.getId()), user);
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.LOAD_FAILED.create(e, e.getMessage());
        }
        for (int userId : userIds) {
            if (users.containsKey(Autoboxing.I((int)userId))) continue;
            throw UserExceptionCode.USER_NOT_FOUND.create(Autoboxing.I((int)userId), Autoboxing.I((int)ctx.getContextId()));
        }
        this.loadLoginInfo(ctx, con, users);
        this.loadContact(ctx, con, users);
        this.loadGroups(ctx, con, users);
        this.loadAttributes(ctx, con, users);
        User[] retval = new User[users.size()];
        for (int i = 0; i < length; ++i) {
            retval[i] = (User)users.get(Autoboxing.I((int)userIds[i]));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User[] getUser(Context ctx) throws OXException {
        Connection con;
        try {
            con = DBPool.pickup(ctx);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        try {
            User[] userArray = this.getUser(ctx, con, this.listAllUser(ctx, con));
            return userArray;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User[] getUser(Context ctx, int[] userIds) throws OXException {
        Connection con;
        if (0 == userIds.length) {
            return new User[0];
        }
        try {
            con = DBPool.pickup(ctx);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        try {
            User[] userArray = this.getUser(ctx, con, userIds);
            return userArray;
        }
        finally {
            DBPool.closeReaderSilent(ctx, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLoginInfo(Context context, Connection con, Map<Integer, UserImpl> users) throws OXException {
        try {
            Iterator<Integer> iter = users.keySet().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_LOGIN, length));
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    for (int j = 0; j < length; ++j) {
                        stmt.setInt(pos++, Autoboxing.i((Integer)iter.next()));
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        users.get(Autoboxing.I((int)result.getInt(1))).setLoginInfo(result.getString(2));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadContact(Context ctx, Connection con, Map<Integer, UserImpl> users) throws OXException {
        try {
            Iterator<UserImpl> iter = users.values().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_CONTACT, length));
                    int pos = 1;
                    stmt.setInt(pos++, ctx.getContextId());
                    HashMap<Integer, UserImpl> userByContactId = new HashMap<Integer, UserImpl>(length, 1.0f);
                    for (int j = 0; j < length; ++j) {
                        UserImpl user = iter.next();
                        stmt.setInt(pos++, user.getContactId());
                        userByContactId.put(Autoboxing.I((int)user.getContactId()), user);
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        pos = 1;
                        UserImpl user = (UserImpl)userByContactId.get(Autoboxing.I((int)result.getInt(pos++)));
                        user.setGivenName(result.getString(pos++));
                        user.setSurname(result.getString(pos++));
                        user.setDisplayName(result.getString(pos++));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGroups(Context context, Connection con, Map<Integer, UserImpl> users) throws OXException {
        HashMap tmp = new HashMap(users.size(), 1.0f);
        for (UserImpl user : users.values()) {
            ArrayList<Integer> userGroups = new ArrayList<Integer>();
            userGroups.add(Autoboxing.I((int)0));
            tmp.put(Autoboxing.I((int)user.getId()), userGroups);
        }
        try {
            Iterator<Integer> iter = users.keySet().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int length = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    String sql = DBUtils.getIN("SELECT member,id FROM groups_member WHERE cid=? AND member IN (", length);
                    stmt = con.prepareStatement(sql);
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    for (int j = 0; j < length; ++j) {
                        stmt.setInt(pos++, Autoboxing.i((Integer)iter.next()));
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        ((List)tmp.get(Autoboxing.I((int)result.getInt(1)))).add(Autoboxing.I((int)result.getInt(2)));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        for (UserImpl user : users.values()) {
            user.setGroups(Autoboxing.I2i((Collection)((Collection)tmp.get(Autoboxing.I((int)user.getId())))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAttributes(Context context, Connection con, Map<Integer, UserImpl> users) throws OXException {
        HashMap usersAttrs = new HashMap();
        try {
            Iterator<Integer> iter = users.keySet().iterator();
            for (int i = 0; i < users.size(); i += 1000) {
                PreparedStatement stmt = null;
                ResultSet result = null;
                try {
                    int n = Arrays.determineRealSize((int)users.size(), (int)i, (int)1000);
                    stmt = con.prepareStatement(DBUtils.getIN(SELECT_ATTRS, n));
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    for (int j = 0; j < n; ++j) {
                        int userId = Autoboxing.i((Integer)iter.next());
                        stmt.setInt(pos++, userId);
                        usersAttrs.put(Autoboxing.I((int)userId), new HashMap());
                    }
                    result = stmt.executeQuery();
                    while (result.next()) {
                        String name;
                        Map attrs = (Map)usersAttrs.get(Autoboxing.I((int)result.getInt(1)));
                        HashSet<String> set = (HashSet<String>)attrs.get(name = result.getString(2));
                        if (null == set) {
                            set = new HashSet<String>();
                            attrs.put(name, set);
                        }
                        set.add(result.getString(3));
                    }
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
                DBUtils.closeSQLStuff(result, stmt);
            }
        }
        catch (SQLException e) {
            throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
        }
        for (UserImpl user : users.values()) {
            Map attrs = (Map)usersAttrs.get(Autoboxing.I((int)user.getId()));
            Set aliases = (Set)attrs.get("alias");
            if (aliases == null) {
                user.setAliases(new String[0]);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>(aliases.size());
                for (String alias : aliases) {
                    try {
                        arrayList.add(new QuotedInternetAddress(alias, false).toUnicodeString());
                    }
                    catch (Exception e) {
                        arrayList.add(alias);
                    }
                }
                user.setAliases(arrayList.toArray(new String[arrayList.size()]));
            }
            for (Map.Entry entry : attrs.entrySet()) {
                entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
            }
            user.setAttributes(Collections.unmodifiableMap(attrs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateUserInternal(User user, Context context) throws OXException {
        int contextId = context.getContextId();
        int userId = user.getId();
        String timeZone = user.getTimeZone();
        String preferredLanguage = user.getPreferredLanguage();
        String password = user.getUserPassword();
        String mech = user.getPasswordMech();
        int shadowLastChanged = user.getShadowLastChange();
        try {
            DBUtils.TransactionRollbackCondition condition = new DBUtils.TransactionRollbackCondition(3);
            do {
                Connection con;
                try {
                    con = DBPool.pickupWriteable(context);
                }
                catch (OXException e) {
                    throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
                }
                condition.resetTransactionRollbackException();
                try {
                    int pos;
                    DBUtils.startTransaction(con);
                    if (null != timeZone && null != preferredLanguage) {
                        PreparedStatement stmt = null;
                        try {
                            String sql = "UPDATE user SET timeZone=?,preferredLanguage=? WHERE cid=? AND id=?";
                            stmt = con.prepareStatement("UPDATE user SET timeZone=?,preferredLanguage=? WHERE cid=? AND id=?");
                            pos = 1;
                            stmt.setString(pos++, timeZone);
                            stmt.setString(pos++, preferredLanguage);
                            stmt.setInt(pos++, contextId);
                            stmt.setInt(pos++, userId);
                            stmt.execute();
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(stmt);
                            throw throwable;
                        }
                        DBUtils.closeSQLStuff(stmt);
                    }
                    if (null != user.getAttributes()) {
                        this.updateAttributes(context, user, con);
                    }
                    if (null != password && null != mech) {
                        String encodedPassword = null;
                        PreparedStatement stmt = null;
                        try {
                            encodedPassword = PasswordMechanism.getEncodedPassword(mech, password);
                            stmt = con.prepareStatement(SQL_UPDATE_PASSWORD);
                            pos = 1;
                            stmt.setString(pos++, encodedPassword);
                            stmt.setInt(pos++, shadowLastChanged);
                            stmt.setInt(pos++, contextId);
                            stmt.setInt(pos++, userId);
                            stmt.execute();
                        }
                        catch (UnsupportedEncodingException e) {
                            try {
                                throw new SQLException(e.toString());
                                catch (NoSuchAlgorithmException e2) {
                                    throw new SQLException(e2.toString());
                                }
                            }
                            catch (Throwable throwable) {
                                DBUtils.closeSQLStuff(stmt);
                                throw throwable;
                            }
                        }
                        DBUtils.closeSQLStuff(stmt);
                    }
                    con.commit();
                }
                catch (SQLException e) {
                    DBUtils.rollback(con);
                    if (condition.isFailedTransactionRollback(e)) continue;
                    throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                }
                catch (OXException e) {
                    DBUtils.rollback(con);
                    throw new OXException(e);
                }
                finally {
                    DBUtils.autocommit(con);
                    DBPool.closeWriterSilent(context, con);
                }
            } while (condition.checkRetry());
            return;
        }
        catch (SQLException e) {
            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
    }

    @Override
    public void setUserAttribute(String name, String value, int userId, Context context) throws OXException {
        if (null == name) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
        }
        String attrName = "attr_" + name;
        this.setAttribute(attrName, value, userId, context);
    }

    @Override
    public void setAttribute(String name, String value, int userId, Context context) throws OXException {
        Connection con;
        if (null == name) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
        }
        try {
            con = DBPool.pickupWriteable(context);
        }
        catch (OXException e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
        }
        try {
            con.setAutoCommit(false);
            this.setAttribute(context.getContextId(), con, userId, name, value);
            con.commit();
        }
        catch (SQLException e) {
            DBUtils.rollback(con);
            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
        catch (Exception e) {
            DBUtils.rollback(con);
            throw LdapExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
        finally {
            DBUtils.autocommit(con);
            DBPool.closeWriterSilent(context, con);
        }
    }

    private void setAttribute(int contextId, Connection con, int userId, String name, String value) throws SQLException {
        this.setAttribute(contextId, con, userId, name, value, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttribute(int contextId, Connection con, int userId, String name, String value, int retryCount) throws SQLException {
        int pos;
        PreparedStatement stmt = null;
        boolean retry = false;
        try {
            stmt = con.prepareStatement("SELECT value FROM user_attribute WHERE cid=? AND id=? AND name=? FOR UPDATE");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos, name);
            stmt.executeQuery();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            stmt = null;
        }
        try {
            stmt = con.prepareStatement("DELETE FROM user_attribute WHERE cid=? AND id=? AND name=?");
            pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos, name);
            stmt.executeUpdate();
        }
        finally {
            DBUtils.closeSQLStuff(stmt);
            stmt = null;
        }
        if (null != value) {
            try {
                stmt = con.prepareStatement("INSERT INTO user_attribute (cid,id,name,value) VALUES (?,?,?,?)");
                pos = 1;
                stmt.setInt(pos++, contextId);
                stmt.setInt(pos++, userId);
                stmt.setString(pos++, name);
                stmt.setString(pos, value);
                try {
                    stmt.executeUpdate();
                }
                catch (SQLException e) {
                    if (retryCount > 3) {
                        throw e;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Detected concurrent insertion of a user's attribute.", (Throwable)e);
                    }
                    retry = true;
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        if (retry) {
            this.setAttribute(contextId, con, userId, name, value, retryCount + 1);
        }
    }

    @Override
    public String getUserAttribute(String name, int userId, Context context) throws OXException {
        if (null == name) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create("Attribute name is null.").setPrefix("USR");
        }
        Connection con = DBPool.pickup(context);
        try {
            String attrName = "attr_" + name;
            String string = this.getAttribute(context.getContextId(), con, userId, attrName);
            return string;
        }
        catch (SQLException e) {
            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
        catch (Exception e) {
            throw LdapExceptionCode.UNEXPECTED_ERROR.create(e, e.getMessage()).setPrefix("USR");
        }
        finally {
            DBPool.closeWriterSilent(context, con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAttribute(int contextId, Connection con, int userId, String name) throws SQLException {
        String string;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT value FROM user_attribute WHERE cid=? AND id=? AND name=?");
            int pos = 1;
            stmt.setInt(pos++, contextId);
            stmt.setInt(pos++, userId);
            stmt.setString(pos, name);
            rs = stmt.executeQuery();
            string = rs.next() ? rs.getString(1) : null;
        }
        catch (Throwable throwable) {
            DBUtils.closeSQLStuff(rs, stmt);
            throw throwable;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAttributes(Context ctx, User user, Connection con) throws SQLException, OXException {
        OXException e;
        int lines;
        int[] mLines;
        int size;
        int contextId = ctx.getContextId();
        int userId = user.getId();
        UserImpl load = new UserImpl();
        load.setId(userId);
        HashMap<Integer, UserImpl> loadMap = new HashMap<Integer, UserImpl>(1);
        loadMap.put(Autoboxing.I((int)userId), load);
        this.loadAttributes(ctx, con, loadMap);
        Map<String, Set<String>> oldAttributes = load.getAttributes();
        Map<String, Set<String>> attributes = user.getAttributes();
        HashMap<String, Set<String>> added = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> removed = new HashMap<String, Set<String>>();
        HashMap<String, Set<String[]>> changed = new HashMap<String, Set<String[]>>();
        RdbUserStorage.calculateDifferences(oldAttributes, attributes, added, removed, changed);
        PreparedStatement stmt = null;
        if (!added.isEmpty()) {
            try {
                stmt = con.prepareStatement("INSERT INTO user_attribute (cid,id,name,value) VALUES (?,?,?,?)");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                size = 0;
                for (Map.Entry entry : added.entrySet()) {
                    for (String value : (Set)entry.getValue()) {
                        stmt.setString(3, (String)entry.getKey());
                        stmt.setString(4, value);
                        stmt.addBatch();
                        ++size;
                    }
                }
                mLines = stmt.executeBatch();
                lines = 0;
                for (int mLine : mLines) {
                    lines += mLine;
                }
                if (size != lines) {
                    e = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                    LOG.error((Object)String.format("Old: %1$s, New: %2$s, Added: %3$s, Removed: %4$s, Changed: %5$s.", oldAttributes, attributes, added, removed, this.toString(changed)), (Throwable)e);
                    throw e;
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        if (!removed.isEmpty()) {
            try {
                stmt = con.prepareStatement("DELETE FROM user_attribute WHERE cid=? AND id=? AND name=? AND value=?");
                stmt.setInt(1, contextId);
                stmt.setInt(2, userId);
                size = 0;
                for (Map.Entry entry : removed.entrySet()) {
                    for (String value : (Set)entry.getValue()) {
                        stmt.setString(3, (String)entry.getKey());
                        stmt.setString(4, value);
                        stmt.addBatch();
                        ++size;
                    }
                }
                mLines = stmt.executeBatch();
                lines = 0;
                for (int mLine : mLines) {
                    lines += mLine;
                }
                if (size != lines) {
                    e = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                    LOG.error((Object)String.format("Old: %1$s, New: %2$s, Added: %3$s, Removed: %4$s, Changed: %5$s.", oldAttributes, attributes, added, removed, this.toString(changed)), (Throwable)e);
                    throw e;
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
        if (!changed.isEmpty()) {
            try {
                stmt = con.prepareStatement("UPDATE user_attribute SET value=? WHERE cid=? AND id=? AND name=? AND value=?");
                stmt.setInt(2, contextId);
                stmt.setInt(3, userId);
                size = 0;
                for (Map.Entry entry : changed.entrySet()) {
                    for (String[] value : (Set)entry.getValue()) {
                        stmt.setString(4, (String)entry.getKey());
                        stmt.setString(5, value[0]);
                        stmt.setString(1, value[1]);
                        stmt.addBatch();
                        ++size;
                    }
                }
                mLines = stmt.executeBatch();
                int lines2 = 0;
                for (int mLine : mLines) {
                    lines2 += mLine;
                }
                if (size != lines2) {
                    boolean onlyLogins = true;
                    for (String name : changed.keySet()) {
                        if (name.startsWith("client:")) continue;
                        onlyLogins = false;
                        break;
                    }
                    if (!onlyLogins) {
                        OXException e2 = UserExceptionCode.UPDATE_ATTRIBUTES_FAILED.create(Autoboxing.I((int)contextId), Autoboxing.I((int)userId));
                        LOG.error((Object)String.format("Old: %1$s, New: %2$s, Added: %3$s, Removed: %4$s, Changed: %5$s.", oldAttributes, attributes, added, removed, this.toString(changed)), (Throwable)e2);
                        throw e2;
                    }
                }
            }
            finally {
                DBUtils.closeSQLStuff(stmt);
            }
        }
    }

    private String toString(Map<String, Set<String[]>> changed) {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry<String, Set<String[]>> entry : changed.entrySet()) {
            sb.append(entry.getKey());
            sb.append("=[");
            for (String[] value : entry.getValue()) {
                sb.append(value[0]);
                sb.append("=>");
                sb.append(value[1]);
                sb.append(',');
            }
            sb.setCharAt(sb.length() - 1, ']');
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, '}');
        return sb.toString();
    }

    static void calculateDifferences(Map<String, Set<String>> oldAttributes, Map<String, Set<String>> newAttributes, Map<String, Set<String>> added, Map<String, Set<String>> removed, Map<String, Set<String[]>> changed) {
        added.putAll(newAttributes);
        for (String key : oldAttributes.keySet()) {
            added.remove(key);
        }
        removed.putAll(oldAttributes);
        for (String key : newAttributes.keySet()) {
            removed.remove(key);
        }
        for (String key : newAttributes.keySet()) {
            if (!oldAttributes.containsKey(key)) continue;
            RdbUserStorage.compareValues(key, oldAttributes.get(key), newAttributes.get(key), added, removed, changed);
        }
    }

    private static void compareValues(String name, Set<String> oldSet, Set<String> newSet, Map<String, Set<String>> added, Map<String, Set<String>> removed, Map<String, Set<String[]>> changed) {
        HashSet<String> addedValues = new HashSet<String>();
        HashSet<String> removedValues = new HashSet<String>();
        addedValues.addAll(newSet);
        addedValues.removeAll(oldSet);
        removedValues.addAll(oldSet);
        removedValues.removeAll(newSet);
        Iterator addedIter = addedValues.iterator();
        Iterator removedIter = removedValues.iterator();
        while (addedIter.hasNext() && removedIter.hasNext()) {
            Set<String[]> values = changed.get(name);
            if (null == values) {
                values = new HashSet<String[]>();
                changed.put(name, values);
            }
            values.add(new String[]{(String)removedIter.next(), (String)addedIter.next()});
        }
        while (addedIter.hasNext()) {
            RdbUserStorage.add(added, name, (String)addedIter.next());
        }
        while (removedIter.hasNext()) {
            RdbUserStorage.add(removed, name, (String)removedIter.next());
        }
    }

    private static void add(Map<String, Set<String>> attributes, String name, String value) {
        Set<String> values = attributes.get(name);
        if (null == values) {
            values = new HashSet<String>();
            attributes.put(name, values);
        }
        values.add(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User[] searchUserByName(String name, Context context, int searchType) throws OXException {
        if (0 == searchType) {
            return new User[0];
        }
        Connection con = DBPool.pickup(context);
        try {
            TIntHashSet userIds;
            block22: {
                boolean searchDisplayName;
                boolean searchLoginName;
                ResultSet result;
                PreparedStatement stmt;
                int contextId;
                String pattern;
                block23: {
                    pattern = StringCollection.prepareForSearch(name, false, true);
                    contextId = context.getContextId();
                    userIds = new TIntHashSet();
                    stmt = null;
                    result = null;
                    searchLoginName = (searchType & 1) > 0;
                    boolean bl = searchDisplayName = (searchType & 2) > 0;
                    if (!searchDisplayName || !searchLoginName) break block23;
                    try {
                        stmt = con.prepareStatement("SELECT con.userid FROM prg_contacts con JOIN login2user lu ON con.userid = lu.id AND con.cid = lu.cid WHERE con.cid = ? AND (lu.uid LIKE ? OR con.field01 LIKE ?)");
                        stmt.setInt(1, contextId);
                        stmt.setString(2, pattern);
                        stmt.setString(3, pattern);
                        result = stmt.executeQuery();
                        while (result.next()) {
                            userIds.add(result.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                    }
                    DBUtils.closeSQLStuff(result, stmt);
                    break block22;
                }
                if (searchLoginName) {
                    try {
                        stmt = con.prepareStatement("SELECT id FROM login2user WHERE cid=? AND uid LIKE ?");
                        stmt.setInt(1, contextId);
                        stmt.setString(2, pattern);
                        result = stmt.executeQuery();
                        while (result.next()) {
                            userIds.add(result.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                    }
                    DBUtils.closeSQLStuff(result, stmt);
                }
                if (searchDisplayName) {
                    try {
                        stmt = con.prepareStatement("SELECT userid FROM prg_contacts WHERE cid=? AND fid=? AND userid IS NOT NULL AND field01 LIKE ?");
                        stmt.setInt(1, contextId);
                        stmt.setInt(2, 6);
                        stmt.setString(3, pattern);
                        result = stmt.executeQuery();
                        while (result.next()) {
                            userIds.add(result.getInt(1));
                        }
                    }
                    catch (SQLException e) {
                        try {
                            throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                        }
                        catch (Throwable throwable) {
                            DBUtils.closeSQLStuff(result, stmt);
                            throw throwable;
                        }
                    }
                    DBUtils.closeSQLStuff(result, stmt);
                }
            }
            User[] userArray = this.getUser(context, userIds.toArray());
            return userArray;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public User searchUser(String email, Context context) throws OXException {
        String sql = "SELECT id FROM user WHERE cid=? AND mail LIKE ?";
        Connection con = DBPool.pickup(context);
        try {
            String pattern = StringCollection.prepareForSearch(email, false, true);
            PreparedStatement stmt = null;
            ResultSet result = null;
            int userId = -1;
            try {
                stmt = con.prepareStatement(sql);
                stmt.setInt(1, context.getContextId());
                stmt.setString(2, pattern);
                result = stmt.executeQuery();
                if (result.next()) {
                    userId = result.getInt(1);
                }
            }
            catch (SQLException e) {
                try {
                    throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
                }
                catch (Throwable throwable) {
                    DBUtils.closeSQLStuff(result, stmt);
                    throw throwable;
                }
            }
            DBUtils.closeSQLStuff(result, stmt);
            try {
                if (userId == -1) {
                    sql = "SELECT id FROM user_attribute WHERE cid=? AND name=? AND value LIKE ?";
                    stmt = con.prepareStatement(sql);
                    int pos = 1;
                    stmt.setInt(pos++, context.getContextId());
                    stmt.setString(pos++, "alias");
                    stmt.setString(pos++, pattern);
                    result = stmt.executeQuery();
                    if (result.next()) {
                        userId = result.getInt(1);
                    }
                }
                if (userId == -1) {
                    throw LdapExceptionCode.NO_USER_BY_MAIL.create(email).setPrefix("USR");
                }
                User pos = this.getUser(context, con, new int[]{userId})[0];
                return pos;
            }
            catch (SQLException e) {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            finally {
                DBUtils.closeSQLStuff(result, stmt);
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    @Override
    public User[] searchUserByMailLogin(String login, Context context) throws OXException {
        User[] userArray;
        String sql = "SELECT id FROM user WHERE cid=? AND imapLogin LIKE ?";
        Connection con = DBPool.pickup(context);
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            String pattern = StringCollection.prepareForSearch(login, false, true);
            stmt = con.prepareStatement(sql);
            stmt.setInt(1, context.getContextId());
            stmt.setString(2, pattern);
            result = stmt.executeQuery();
            TIntHashSet userIds = new TIntHashSet();
            while (result.next()) {
                userIds.add(result.getInt(1));
            }
            userArray = this.getUser(context, userIds.toArray());
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return userArray;
    }

    @Override
    public int[] listModifiedUser(Date modifiedSince, Context context) throws OXException {
        int[] users;
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw LdapExceptionCode.NO_CONNECTION.create(e, new Object[0]).setPrefix("USR");
        }
        String sql = "SELECT id FROM user LEFT JOIN prg_contacts ON (user.cid=prg_contacts.cid AND user.contactId=prg_contacts.intfield01) WHERE cid=? AND changing_date>=?";
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM user LEFT JOIN prg_contacts ON (user.cid=prg_contacts.cid AND user.contactId=prg_contacts.intfield01) WHERE cid=? AND changing_date>=?");
            stmt.setInt(1, context.getContextId());
            stmt.setTimestamp(2, new Timestamp(modifiedSince.getTime()));
            result = stmt.executeQuery();
            ArrayList<Integer> tmp = new ArrayList<Integer>();
            while (result.next()) {
                tmp.add(Autoboxing.I((int)result.getInt(1)));
            }
            users = new int[tmp.size()];
            for (int i = 0; i < users.length; ++i) {
                users[i] = (Integer)tmp.get(i);
            }
        }
        catch (SQLException e) {
            try {
                throw LdapExceptionCode.SQL_ERROR.create(e, e.getMessage()).setPrefix("USR");
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] listAllUser(Context context) throws OXException {
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw UserExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        try {
            int[] nArray = this.listAllUser(context, con);
            return nArray;
        }
        finally {
            DBPool.closeReaderSilent(context, con);
        }
    }

    private int[] listAllUser(Context ctx, Connection con) throws OXException {
        int[] users;
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement("SELECT id FROM user WHERE user.cid=?");
            stmt.setInt(1, ctx.getContextId());
            result = stmt.executeQuery();
            TIntArrayList tmp = new TIntArrayList();
            while (result.next()) {
                tmp.add(result.getInt(1));
            }
            users = tmp.toArray();
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        return users;
    }

    @Override
    public int[] resolveIMAPLogin(String imapLogin, Context context) throws OXException {
        int[] users;
        Connection con = null;
        try {
            con = DBPool.pickup(context);
        }
        catch (Exception e) {
            throw UserExceptionCode.NO_CONNECTION.create(e, new Object[0]);
        }
        PreparedStatement stmt = null;
        ResultSet result = null;
        try {
            stmt = con.prepareStatement(SELECT_IMAPLOGIN);
            int cid = context.getContextId();
            stmt.setInt(1, cid);
            stmt.setString(2, imapLogin);
            result = stmt.executeQuery();
            Collections.SmartIntArray sia = new Collections.SmartIntArray(4);
            if (result.next()) {
                do {
                    sia.append(result.getInt(1));
                } while (result.next());
            } else {
                throw UserExceptionCode.USER_NOT_FOUND.create(imapLogin, Autoboxing.I((int)cid));
            }
            users = sia.toArray();
        }
        catch (SQLException e) {
            try {
                throw UserExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(result, stmt);
                DBPool.closeReaderSilent(context, con);
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(result, stmt);
        DBPool.closeReaderSilent(context, con);
        return users;
    }

    @Override
    public void invalidateUser(Context ctx, int userId) {
    }

    @Override
    protected void startInternal() {
    }

    @Override
    protected void stopInternal() {
    }
}

