/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.webdav;

import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.webdav.EntityLockManager;
import com.openexchange.groupware.infostore.webdav.Lock;
import com.openexchange.groupware.infostore.webdav.LockManager;
import com.openexchange.groupware.infostore.webdav.LockManagerImpl;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import java.util.Arrays;
import java.util.List;

public class EntityLockManagerImpl
extends LockManagerImpl<Lock>
implements EntityLockManager {
    public EntityLockManagerImpl(String tablename) {
        super(tablename);
    }

    public EntityLockManagerImpl(DBProvider provider, String tablename) {
        super(provider, tablename);
    }

    @Override
    protected Lock newLock() {
        return new Lock();
    }

    @Override
    public List<Lock> findLocks(int entity, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.findLocksByEntity(Arrays.asList(entity), ctx).get(entity);
    }

    @Override
    public boolean isLocked(int entity, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.existsLockForEntity(Arrays.asList(entity), ctx);
    }

    @Override
    public int lock(int entity, long timeout, LockManager.Scope scope, LockManager.Type type, String ownerDesc, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        return this.createLock(entity, timeout, scope, type, ownerDesc, ctx, user, new Object[0]);
    }

    @Override
    public void unlock(int id, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.removeLock(id, ctx);
    }

    @Override
    public void removeAll(int entity, Context context, User userObject, UserConfiguration userConfiguration) throws OXException {
        this.removeAllFromEntity(entity, context);
    }

    @Override
    public void relock(int lockId, long timeout, LockManager.Scope scope, LockManager.Type write, String owner, Context context, User userObject, UserConfiguration userConfiguration) throws OXException {
        this.updateLock(lockId, timeout, scope, write, owner, context, new Object[0]);
    }

    @Override
    public void insertLock(int entity, Lock lock, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        this.createLockForceId(entity, lock.getId(), lock.getTimeout(), lock.getScope(), lock.getType(), lock.getOwnerDescription(), ctx, user, new Object[0]);
    }

    @Override
    public void transferLocks(Context ctx, int from_user, int to_user) throws OXException {
        this.reassign(ctx, from_user, to_user);
    }
}

