/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.infostore.search.impl;

import com.openexchange.configuration.ServerConfig;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.database.tx.DBService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.EnumComponent;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.infostore.DocumentMetadata;
import com.openexchange.groupware.infostore.InfostoreExceptionCodes;
import com.openexchange.groupware.infostore.InfostoreSearchEngine;
import com.openexchange.groupware.infostore.database.impl.DocumentMetadataImpl;
import com.openexchange.groupware.infostore.database.impl.InfostoreSecurityImpl;
import com.openexchange.groupware.infostore.utils.Metadata;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.tools.iterator.FolderObjectIterator;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorAdapter;
import com.openexchange.tools.iterator.SearchIteratorExceptionCodes;
import com.openexchange.tools.oxfolder.OXFolderIteratorSQL;
import com.openexchange.tools.sql.SearchStrings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import org.apache.commons.logging.Log;

public class SearchEngineImpl
extends DBService
implements InfostoreSearchEngine {
    static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(SearchEngineImpl.class));
    private final InfostoreSecurityImpl security = new InfostoreSecurityImpl();
    private static final String[] SEARCH_FIELDS = new String[]{"infostore_document.title", "infostore_document.url", "infostore_document.description", "infostore_document.categories", "infostore_document.filename", "infostore_document.file_version_comment"};

    public SearchEngineImpl() {
        super(null);
    }

    public SearchEngineImpl(DBProvider provider) {
        super(provider);
        this.security.setProvider(provider);
    }

    @Override
    public void setProvider(DBProvider provider) {
        super.setProvider(provider);
        if (this.security != null) {
            this.security.setProvider(provider);
        }
    }

    @Override
    public SearchIterator<DocumentMetadata> search(String query, Metadata[] cols, int folderId, Metadata sortedBy, int dir, int start, int end, Context ctx, User user, UserConfiguration userConfig) throws OXException {
        String[] orderColumn;
        List<Integer> all = new ArrayList<Integer>();
        List<Integer> own = new ArrayList<Integer>();
        boolean addQuery = false;
        try {
            int userId = user.getId();
            if (folderId == -11 || folderId == -10) {
                Queue<FolderObject> queue = ((FolderObjectIterator)OXFolderIteratorSQL.getAllVisibleFoldersIteratorOfModule(userId, user.getGroups(), userConfig.getAccessibleModules(), 8, ctx)).asQueue();
                for (FolderObject folder : queue) {
                    EffectivePermission perm = this.security.getFolderPermission(folder.getObjectID(), ctx, user, userConfig);
                    if (perm.canReadOwnObjects() && !perm.canReadAllObjects()) {
                        own.add(folder.getObjectID());
                        continue;
                    }
                    if (!perm.canReadAllObjects()) continue;
                    all.add(folder.getObjectID());
                }
            } else {
                EffectivePermission perm = this.security.getFolderPermission(folderId, ctx, user, userConfig);
                if (perm.canReadOwnObjects() && !perm.canReadAllObjects()) {
                    own.add(folderId);
                } else if (perm.canReadAllObjects()) {
                    all.add(folderId);
                } else {
                    return SearchIteratorAdapter.emptyIterator();
                }
            }
            all = Collections.unmodifiableList(all);
            own = Collections.unmodifiableList(own);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        if (all.isEmpty() && own.isEmpty()) {
            return SearchIteratorAdapter.emptyIterator();
        }
        StringBuilder SQL_QUERY = new StringBuilder();
        SQL_QUERY.append(this.getResultFieldsSelect(cols));
        SQL_QUERY.append(" FROM infostore JOIN infostore_document ON infostore_document.cid = infostore.cid AND infostore_document.infostore_id = infostore.id AND infostore_document.version_number = infostore.version WHERE infostore.cid = ").append(ctx.getContextId());
        boolean needOr = false;
        if (!all.isEmpty()) {
            SQL_QUERY.append(" AND ((infostore.folder_id IN (").append(this.join(all)).append("))");
            needOr = true;
        }
        if (!own.isEmpty()) {
            if (needOr) {
                SQL_QUERY.append(" OR ");
            } else {
                SQL_QUERY.append(" AND (");
            }
            SQL_QUERY.append("(infostore.created_by = ").append(user.getId()).append(" AND infostore.folder_id in (").append(this.join(own)).append(")))");
        } else {
            SQL_QUERY.append(')');
        }
        if (!query.equals("") && !query.equals("*")) {
            SearchEngineImpl.checkPatternLength(query);
            boolean containsWildcard = query.contains("*");
            addQuery = true;
            query = query.replaceAll("\\\\", "\\\\\\\\");
            query = query.replaceAll("%", "\\\\%");
            query = query.replace('*', '%');
            query = query.replace('?', '_');
            query = query.replaceAll("'", "\\\\'");
            if (!containsWildcard) {
                query = "%" + query + "%";
            }
            StringBuffer SQL_QUERY_OBJECTS = new StringBuffer();
            for (String currentField : SEARCH_FIELDS) {
                if (SQL_QUERY_OBJECTS.length() > 0) {
                    SQL_QUERY_OBJECTS.append(" OR ");
                }
                SQL_QUERY_OBJECTS.append(currentField);
                SQL_QUERY_OBJECTS.append(" LIKE (?)");
            }
            if (SQL_QUERY_OBJECTS.length() > 0) {
                SQL_QUERY.append(" AND (");
                SQL_QUERY.append(SQL_QUERY_OBJECTS);
                SQL_QUERY.append(") ");
            }
        }
        if (sortedBy != null && dir != -11 && (orderColumn = this.switchMetadata2DBColumns(new Metadata[]{sortedBy})) != null && orderColumn[0] != null) {
            if (dir == -1) {
                SQL_QUERY.append(" ORDER BY ");
                SQL_QUERY.append(orderColumn[0]);
                SQL_QUERY.append(" DESC");
            } else if (dir == 1) {
                SQL_QUERY.append(" ORDER BY ");
                SQL_QUERY.append(orderColumn[0]);
                SQL_QUERY.append(" ASC");
            }
        }
        if (start != -11 && end != -11) {
            if (end >= start) {
                SQL_QUERY.append(" LIMIT ");
                SQL_QUERY.append(start);
                SQL_QUERY.append(", ");
                SQL_QUERY.append(end + 1 - start);
            }
        } else {
            if (start != -11) {
                SQL_QUERY.append(" LIMIT ");
                SQL_QUERY.append(start);
                SQL_QUERY.append(",200");
            }
            if (end != -11) {
                SQL_QUERY.append(" LIMIT ");
                SQL_QUERY.append(end + 1);
            }
        }
        Connection con = this.getReadConnection(ctx);
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(SQL_QUERY.toString());
            if (addQuery) {
                for (int i = 0; i < SEARCH_FIELDS.length; ++i) {
                    stmt.setString(i + 1, query);
                }
            }
            return new InfostoreSearchIterator(stmt.executeQuery(), this, cols, ctx, con, stmt);
        }
        catch (SQLException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw InfostoreExceptionCodes.SQL_PROBLEM.create(e, SQL_QUERY.toString());
        }
        catch (OXException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw InfostoreExceptionCodes.PREFETCH_FAILED.create(e, new Object[0]);
        }
    }

    public static void checkPatternLength(String pattern) throws OXException {
        int minimumSearchCharacters = ServerConfig.getInt(ServerConfig.Property.MINIMUM_SEARCH_CHARACTERS);
        if (0 == minimumSearchCharacters) {
            return;
        }
        if (null != pattern && SearchStrings.lengthWithoutWildcards(pattern) < minimumSearchCharacters) {
            throw InfostoreExceptionCodes.PATTERN_NEEDS_MORE_CHARACTERS.create(Autoboxing.I((int)minimumSearchCharacters));
        }
    }

    private String join(List<Integer> all) {
        StringBuffer joined = new StringBuffer();
        for (Integer i : all) {
            joined.append(i.toString());
            joined.append(',');
        }
        joined.setLength(joined.length() - 1);
        return joined.toString();
    }

    @Override
    public void index(DocumentMetadata document, Context ctx, User user, UserConfiguration userConfig) {
    }

    @Override
    public void unIndex0r(int id, Context ctx, User user, UserConfiguration userConfig) {
    }

    private String[] switchMetadata2DBColumns(Metadata[] columns) {
        ArrayList<String> retval = new ArrayList<String>();
        block23: for (Metadata current : columns) {
            switch (current.getId()) {
                default: {
                    continue block23;
                }
                case 5: {
                    retval.add("infostore.last_modified");
                    continue block23;
                }
                case 6: {
                    retval.add("infostore.last_modified");
                    continue block23;
                }
                case 4: {
                    retval.add("infostore.creating_date");
                    continue block23;
                }
                case 3: {
                    retval.add("infostore.changed_by");
                    continue block23;
                }
                case 20: {
                    retval.add("infostore.folder_id");
                    continue block23;
                }
                case 700: {
                    retval.add("infostore_document.title");
                    continue block23;
                }
                case 705: {
                    retval.add("infostore.version");
                    continue block23;
                }
                case 750: {
                    retval.add("infostore_document.description");
                    continue block23;
                }
                case 702: {
                    retval.add("infostore_document.filename");
                    continue block23;
                }
                case 751: {
                    retval.add("infostore.id");
                    continue block23;
                }
                case 1: {
                    retval.add("infostore.id");
                    continue block23;
                }
                case 704: {
                    retval.add("infostore_document.file_size");
                    continue block23;
                }
                case 703: {
                    retval.add("infostore_document.file_mimetype");
                    continue block23;
                }
                case 706: {
                    retval.add("infostore_document.description");
                    continue block23;
                }
                case 707: {
                    retval.add("infostore.locked_until");
                    continue block23;
                }
                case 701: {
                    retval.add("infostore_document.url");
                    continue block23;
                }
                case 2: {
                    retval.add("infostore.created_by");
                    continue block23;
                }
                case 100: {
                    retval.add("infostore_document.categories");
                    continue block23;
                }
                case 708: {
                    retval.add("infostore_document.file_md5sum");
                    continue block23;
                }
                case 709: {
                    retval.add("infostore_document.file_version_comment");
                    continue block23;
                }
                case 102: {
                    retval.add("infostore.color_label");
                }
            }
        }
        return retval.toArray(new String[0]);
    }

    private String getResultFieldsSelect(Metadata[] RESULT_FIELDS) {
        String[] DB_RESULT_FIELDS = this.switchMetadata2DBColumns(RESULT_FIELDS);
        StringBuilder selectFields = new StringBuilder();
        boolean id = false;
        for (String currentField : DB_RESULT_FIELDS) {
            if (currentField.equals("infostore.id")) {
                currentField = "infostore.id";
                id = true;
            }
            selectFields.append(currentField);
            selectFields.append(", ");
        }
        if (!id) {
            selectFields.append("infostore.id,");
        }
        String retval = "";
        if (selectFields.length() > 0) {
            retval = "SELECT DISTINCT " + selectFields.toString();
            retval = retval.substring(0, retval.lastIndexOf(", "));
        }
        return retval;
    }

    public static class InfostoreSearchIterator
    implements SearchIterator<DocumentMetadata> {
        private DocumentMetadata next;
        private ResultSet rs;
        private final Metadata[] columns;
        private final SearchEngineImpl s;
        private final Context ctx;
        private Connection readCon;
        private Statement stmt;
        private final List<OXException> warnings = new ArrayList<OXException>(2);

        public InfostoreSearchIterator(ResultSet rs, SearchEngineImpl s, Metadata[] columns, Context ctx, Connection readCon, Statement stmt) throws OXException {
            this.rs = rs;
            this.s = s;
            this.columns = columns;
            this.ctx = ctx;
            this.readCon = readCon;
            this.stmt = stmt;
            try {
                if (rs.next()) {
                    this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), columns, rs);
                } else {
                    this.close();
                }
            }
            catch (Exception e) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)e, new Object[]{EnumComponent.INFOSTORE});
            }
        }

        public boolean hasNext() throws OXException {
            return this.next != null;
        }

        public DocumentMetadata next() throws OXException, OXException {
            try {
                DocumentMetadata retval = null;
                retval = this.next;
                if (this.rs.next()) {
                    this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    while (this.next == null && this.rs.next()) {
                        this.next = this.fillDocumentMetadata(new DocumentMetadataImpl(), this.columns, this.rs);
                    }
                    if (this.next == null) {
                        this.close();
                    }
                } else {
                    this.close();
                }
                return retval;
            }
            catch (Exception exc) {
                throw SearchIteratorExceptionCodes.SQL_ERROR.create((Throwable)exc, new Object[]{EnumComponent.INFOSTORE});
            }
        }

        public void close() throws OXException {
            this.next = null;
            try {
                if (this.rs != null) {
                    this.rs.close();
                }
                this.rs = null;
            }
            catch (SQLException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
                this.stmt = null;
            }
            catch (SQLException e) {
                LOG.debug((Object)"", (Throwable)e);
            }
            if (null != this.readCon) {
                this.s.releaseReadConnection(this.ctx, this.readCon);
                this.readCon = null;
            }
        }

        public int size() {
            return -1;
        }

        public boolean hasSize() {
            return false;
        }

        public void addWarning(OXException warning) {
            this.warnings.add(warning);
        }

        public OXException[] getWarnings() {
            return this.warnings.isEmpty() ? null : this.warnings.toArray(new OXException[this.warnings.size()]);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }

        private DocumentMetadataImpl fillDocumentMetadata(DocumentMetadataImpl retval, Metadata[] columns, ResultSet result) throws SQLException {
            block23: for (int i = 0; i < columns.length; ++i) {
                switch (columns[i].getId()) {
                    default: {
                        continue block23;
                    }
                    case 5: {
                        retval.setLastModified(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 6: {
                        retval.setLastModified(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 4: {
                        retval.setCreationDate(new Date(result.getLong(i + 1)));
                        continue block23;
                    }
                    case 3: {
                        retval.setModifiedBy(result.getInt(i + 1));
                        continue block23;
                    }
                    case 20: {
                        retval.setFolderId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 700: {
                        retval.setTitle(result.getString(i + 1));
                        continue block23;
                    }
                    case 705: {
                        retval.setVersion(result.getInt(i + 1));
                        continue block23;
                    }
                    case 750: {
                        retval.setDescription(result.getString(i + 1));
                        continue block23;
                    }
                    case 702: {
                        retval.setFileName(result.getString(i + 1));
                        continue block23;
                    }
                    case 751: {
                        retval.setId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 1: {
                        retval.setId(result.getInt(i + 1));
                        continue block23;
                    }
                    case 704: {
                        retval.setFileSize(result.getInt(i + 1));
                        continue block23;
                    }
                    case 703: {
                        retval.setFileMIMEType(result.getString(i + 1));
                        continue block23;
                    }
                    case 706: {
                        retval.setDescription(result.getString(i + 1));
                        continue block23;
                    }
                    case 707: {
                        retval.setLockedUntil(new Date(result.getLong(i + 1)));
                        if (!result.wasNull()) continue block23;
                        retval.setLockedUntil(null);
                        continue block23;
                    }
                    case 701: {
                        retval.setURL(result.getString(i + 1));
                        continue block23;
                    }
                    case 2: {
                        retval.setCreatedBy(result.getInt(i + 1));
                        continue block23;
                    }
                    case 100: {
                        retval.setCategories(result.getString(i + 1));
                        continue block23;
                    }
                    case 708: {
                        retval.setFileMD5Sum(result.getString(i + 1));
                        continue block23;
                    }
                    case 709: {
                        retval.setVersionComment(result.getString(i + 1));
                        continue block23;
                    }
                    case 102: {
                        retval.setColorLabel(result.getInt(i + 1));
                    }
                }
            }
            retval.setIsCurrentVersion(true);
            return retval;
        }
    }
}

