/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.datahandler;

import com.openexchange.ajax.writer.AppointmentWriter;
import com.openexchange.ajax.writer.TaskWriter;
import com.openexchange.api2.AppointmentSQLInterface;
import com.openexchange.configuration.ServerConfig;
import com.openexchange.conversion.Data;
import com.openexchange.conversion.DataArguments;
import com.openexchange.conversion.DataExceptionCodes;
import com.openexchange.conversion.DataHandler;
import com.openexchange.data.conversion.ical.ConversionError;
import com.openexchange.data.conversion.ical.ConversionWarning;
import com.openexchange.data.conversion.ical.ICalParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.calendar.AppointmentSqlFactoryService;
import com.openexchange.groupware.calendar.CalendarCollectionService;
import com.openexchange.groupware.calendar.CalendarDataObject;
import com.openexchange.groupware.calendar.OXCalendarExceptionCodes;
import com.openexchange.groupware.calendar.RecurringResultInterface;
import com.openexchange.groupware.calendar.RecurringResultsInterface;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextStorage;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tasks.Task;
import com.openexchange.log.LogFactory;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.TimeZoneUtils;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import com.openexchange.tools.stream.UnsynchronizedByteArrayInputStream;
import com.openexchange.tools.stream.UnsynchronizedByteArrayOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ICalJSONDataHandler
implements DataHandler {
    private static final Log LOG = com.openexchange.log.Log.valueOf((Log)LogFactory.getLog(ICalJSONDataHandler.class));
    private static final Class<?>[] TYPES = new Class[]{InputStream.class};
    private static final String[] ARGS = new String[0];
    private static final int LIMIT = 0x100000;

    public String[] getRequiredArguments() {
        return ARGS;
    }

    public Class<?>[] getTypes() {
        return TYPES;
    }

    public Object processData(Data<? extends Object> data, DataArguments dataArguments, Session session) throws OXException {
        List<Task> tasks2;
        List<CalendarDataObject> appointments;
        long size;
        Context ctx;
        try {
            ctx = ContextStorage.getStorageContext(session);
        }
        catch (OXException e) {
            throw new OXException(e);
        }
        ICalParser iCalParser = ServerServiceRegistry.getInstance().getService(ICalParser.class);
        if (iCalParser == null) {
            throw new OXException(ServiceExceptionCode.SERVICE_UNAVAILABLE.create(new Object[]{ICalParser.class.getName()}));
        }
        try {
            size = Long.parseLong(data.getDataProperties().get("com.openexchange.conversion.size"));
        }
        catch (NumberFormatException e) {
            size = 0L;
        }
        InputStreamCopy inputStreamCopy = ICalJSONDataHandler.copyStream((InputStream)data.getData(), size);
        String timeZoneId = dataArguments.get("com.openexchange.groupware.calendar.timezone");
        TimeZone timeZone = TimeZoneUtils.getTimeZone(null == timeZoneId ? UserStorage.getStorageUser(session.getUserId(), ctx).getTimeZone() : timeZoneId);
        try {
            ArrayList<ConversionError> conversionErrors = new ArrayList<ConversionError>(4);
            ArrayList<ConversionWarning> conversionWarnings = new ArrayList<ConversionWarning>(4);
            appointments = this.parseAppointmentStream(ctx, iCalParser, inputStreamCopy, conversionErrors, conversionWarnings, timeZone);
            this.resolveUid(appointments, dataArguments, session);
            conversionErrors.clear();
            conversionWarnings.clear();
            tasks2 = this.parseTaskStream(ctx, iCalParser, inputStreamCopy, conversionErrors, conversionWarnings, timeZone);
        }
        catch (ConversionError e) {
            throw new OXException((OXException)e);
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
        finally {
            inputStreamCopy.close();
        }
        JSONArray objects = new JSONArray();
        if (!appointments.isEmpty()) {
            try {
                int recurrencePosition;
                AppointmentWriter appointmentwriter = new AppointmentWriter(timeZone);
                CalendarCollectionService recColl = ServerServiceRegistry.getInstance().getService(CalendarCollectionService.class);
                String recPosArg = "com.openexchange.groupware.calendar.recurrencePosition";
                String recPosStr = dataArguments.get("com.openexchange.groupware.calendar.recurrencePosition");
                if (null == recPosStr) {
                    recurrencePosition = 0;
                } else {
                    int tmp = 0;
                    try {
                        tmp = Integer.parseInt(recPosStr.trim());
                    }
                    catch (NumberFormatException e) {
                        LOG.error((Object)MessageFormat.format("Data argument \"{0}\" is not a number: {1}", "com.openexchange.groupware.calendar.recurrencePosition", recPosStr), (Throwable)e);
                        tmp = 0;
                    }
                    recurrencePosition = tmp;
                }
                for (CalendarDataObject appointment : appointments) {
                    JSONObject jsonAppointment = new JSONObject();
                    if (appointment.getRecurrenceType() != 0 && recurrencePosition > 0) {
                        RecurringResultsInterface recuResults = recColl.calculateRecurring(appointment, 0L, 0L, recurrencePosition, 999, true);
                        if (recuResults.size() == 0) {
                            if (LOG.isWarnEnabled()) {
                                LOG.warn((Object)new StringBuilder(32).append("No occurrence at position ").append(recurrencePosition));
                            }
                            OXCalendarExceptionCodes.UNKNOWN_RECURRENCE_POSITION.create(recurrencePosition);
                        }
                        RecurringResultInterface result = recuResults.getRecurringResult(0);
                        appointment.setStartDate(new Date(result.getStart()));
                        appointment.setEndDate(new Date(result.getEnd()));
                        appointment.setRecurrencePosition(result.getPosition());
                        appointmentwriter.writeAppointment(appointment, jsonAppointment);
                    } else {
                        appointmentwriter.writeAppointment(appointment, jsonAppointment);
                    }
                    objects.put((Object)jsonAppointment);
                }
            }
            catch (OXException e) {
                throw new OXException(e);
            }
            catch (JSONException e) {
                throw new OXException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]));
            }
        }
        if (!tasks2.isEmpty()) {
            try {
                for (Task task : tasks2) {
                    TaskWriter taskWriter = new TaskWriter(timeZone);
                    JSONObject jsonTask = new JSONObject();
                    taskWriter.writeTask(task, jsonTask);
                    objects.put((Object)jsonTask);
                }
            }
            catch (JSONException e) {
                throw new OXException(OXJSONExceptionCodes.JSON_WRITE_ERROR.create(e, new Object[0]));
            }
        }
        return objects;
    }

    private void resolveUid(List<CalendarDataObject> appointments, DataArguments dataArguments, Session session) throws OXException {
        String key = "com.openexchange.groupware.calendar.searchobject";
        if (!dataArguments.containsKey("com.openexchange.groupware.calendar.searchobject") || !Boolean.parseBoolean(dataArguments.get("com.openexchange.groupware.calendar.searchobject"))) {
            return;
        }
        AppointmentSQLInterface appointmentSql = ServerServiceRegistry.getInstance().getService(AppointmentSqlFactoryService.class).createAppointmentSql(session);
        for (CalendarDataObject calendarData : appointments) {
            if (!calendarData.containsUid()) continue;
            try {
                int id = appointmentSql.resolveUid(calendarData.getUid());
                if (id == 0) continue;
                int folder = appointmentSql.getFolder(id);
                if (folder != 0) {
                    calendarData.setParentFolderID(folder);
                }
                calendarData.setObjectID(id);
            }
            catch (OXException e) {
                throw new OXException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CalendarDataObject> parseAppointmentStream(Context ctx, ICalParser iCalParser, InputStreamCopy inputStreamCopy, List<ConversionError> conversionErrors, List<ConversionWarning> conversionWarnings, TimeZone defaultZone) throws IOException, ConversionError {
        InputStream inputStream = inputStreamCopy.getInputStream();
        try {
            List<CalendarDataObject> list = iCalParser.parseAppointments(inputStream, defaultZone, ctx, conversionErrors, conversionWarnings);
            return list;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Task> parseTaskStream(Context ctx, ICalParser iCalParser, InputStreamCopy inputStreamCopy, List<ConversionError> conversionErrors, List<ConversionWarning> conversionWarnings, TimeZone defaultZone) throws IOException, ConversionError {
        InputStream inputStream = inputStreamCopy.getInputStream();
        try {
            List<Task> list = iCalParser.parseTasks(inputStream, defaultZone, ctx, conversionErrors, conversionWarnings);
            return list;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing input stream", (Throwable)e);
            }
        }
    }

    private static InputStreamCopy copyStream(InputStream orig, long size) throws OXException {
        try {
            return new InputStreamCopy(orig, size <= 0L || size > 0x100000L);
        }
        catch (IOException e) {
            throw DataExceptionCodes.ERROR.create((Throwable)e, new Object[]{e.getMessage()});
        }
    }

    private static final class InputStreamCopy {
        private static final int DEFAULT_BUF_SIZE = 8192;
        private static final String FILE_PREFIX = "openexchange";
        private byte[] bytes;
        private File file;
        private final long size;

        public InputStreamCopy(InputStream orig, boolean createFile) throws IOException {
            this.size = createFile ? this.copy2File(orig) : (long)this.copy2ByteArr(orig);
        }

        public InputStream getInputStream() throws IOException {
            return this.bytes == null ? (this.file == null ? null : new BufferedInputStream(new FileInputStream(this.file), 8192)) : new UnsynchronizedByteArrayInputStream(this.bytes);
        }

        public long getSize() {
            return this.size;
        }

        public void close() {
            if (this.file != null) {
                if (this.file.exists()) {
                    this.file.delete();
                }
                this.file = null;
            }
            if (this.bytes != null) {
                this.bytes = null;
            }
        }

        private int copy2ByteArr(InputStream in) throws IOException {
            int len;
            UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(16384);
            byte[] bbuf = new byte[8192];
            while ((len = in.read(bbuf)) != -1) {
                out.write(bbuf, 0, len);
            }
            out.flush();
            this.bytes = out.toByteArray();
            return this.bytes.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long copy2File(InputStream in) throws IOException {
            long totalBytes = 0L;
            File tmpFile = File.createTempFile(FILE_PREFIX, null, new File(ServerConfig.getProperty(ServerConfig.Property.UploadDirectory)));
            tmpFile.deleteOnExit();
            OutputStream out = null;
            try {
                int len;
                out = new BufferedOutputStream(new FileOutputStream(tmpFile), 8192);
                byte[] bbuf = new byte[8192];
                while ((len = in.read(bbuf)) != -1) {
                    out.write(bbuf, 0, len);
                    totalBytes += (long)len;
                }
                out.flush();
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            this.file = tmpFile;
            return totalBytes;
        }
    }
}

