/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contexts.impl;

import com.openexchange.caching.dynamic.OXObjectFactory;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.impl.CachingContextStorage;
import com.openexchange.groupware.contexts.impl.ContextExtended;
import com.openexchange.groupware.update.UpdateStatus;
import com.openexchange.groupware.update.Updater;
import com.openexchange.groupware.update.internal.SchemaExceptionCodes;
import com.openexchange.java.Autoboxing;
import com.openexchange.log.LogFactory;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;

public class ContextExtendedFactory
implements OXObjectFactory<ContextExtended> {
    private static final long serialVersionUID = 7796462639896914733L;
    private static final Log LOG = LogFactory.getLog(ContextExtendedFactory.class);
    public static volatile CachingContextStorage parent;
    private final int contextId;

    public ContextExtendedFactory(int contextId) {
        this.contextId = contextId;
    }

    public Serializable getKey() {
        return Autoboxing.I((int)this.contextId);
    }

    public ContextExtended load() throws OXException {
        ContextExtended retval;
        block3: {
            retval = parent.getPersistantImpl().loadContext(this.contextId);
            Updater updater = Updater.getInstance();
            try {
                UpdateStatus status = updater.getStatus(retval);
                retval.setUpdating(status.blockingUpdatesRunning() || status.needsBlockingUpdates());
                if ((status.needsBlockingUpdates() || status.needsBackgroundUpdates()) && !status.blockingUpdatesRunning() && !status.backgroundUpdatesRunning()) {
                    updater.startUpdate(retval);
                }
            }
            catch (OXException e) {
                if (!SchemaExceptionCodes.DATABASE_DOWN.equals(e)) break block3;
                LOG.warn((Object)("Switching to read only mode for context " + this.contextId + " because master database is down."), (Throwable)e);
                retval.setReadOnly(true);
            }
        }
        return retval;
    }

    public Lock getCacheLock() {
        return parent.getCacheLock();
    }
}

