/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.container;

import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.container.Differ;
import java.util.HashSet;
import java.util.Set;

public class Appointment
extends CalendarObject
implements Cloneable {
    private static final long serialVersionUID = 8822932551489524746L;
    public static final int LOCATION = 400;
    public static final int FULL_TIME = 401;
    public static final int SHOWN_AS = 402;
    public static final int TIMEZONE = 408;
    public static final int RECURRENCE_START = 410;
    public static final int[] ALL_COLUMNS = new int[]{400, 401, 402, 408, 410, 200, 201, 202, 203, 204, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 220, 221, 226, 222, 223, 224, 225, 227, 228, 229, 100, 101, 102, 103, 104, 20, 1, 2, 3, 4, 5, 6};
    public static final int RESERVED = 1;
    public static final int TEMPORARY = 2;
    public static final int ABSENT = 3;
    public static final int FREE = 4;
    protected int DEFAULTFOLDER = -1;
    protected String location;
    protected boolean fulltime;
    protected int shown_as;
    protected int alarm;
    protected long recurring_start;
    protected boolean ignoreConflicts;
    protected String timezone;
    protected boolean b_location;
    protected boolean b_fulltime;
    protected boolean b_shown_as;
    protected boolean b_Alarm;
    protected boolean b_timezone;
    protected boolean b_recurring_start;
    public static Set<Differ<? super Appointment>> differ = new HashSet<Differ<? super Appointment>>();

    public String getLocation() {
        return this.location;
    }

    public boolean getFullTime() {
        return this.fulltime;
    }

    public int getShownAs() {
        return this.shown_as;
    }

    public int getAlarm() {
        return this.alarm;
    }

    public boolean getIgnoreConflicts() {
        return this.ignoreConflicts;
    }

    public final long getRecurringStart() {
        return this.recurring_start;
    }

    public String getTimezone() {
        return this.timezone;
    }

    @Deprecated
    public String getTimezoneFallbackUTC() {
        if (this.timezone != null) {
            return this.timezone;
        }
        return "UTC";
    }

    public final void setRecurringStart(long recurring_start) {
        this.recurring_start = recurring_start - recurring_start % 86400000L;
        this.b_recurring_start = true;
    }

    public void setLocation(String location) {
        this.location = location;
        this.b_location = true;
    }

    public void setFullTime(boolean fulltime) {
        this.fulltime = fulltime;
        this.b_fulltime = true;
    }

    public void setShownAs(int shown_as) {
        this.shown_as = shown_as;
        this.b_shown_as = true;
    }

    public void setAlarm(int alarm) {
        this.alarm = alarm;
        this.b_Alarm = true;
    }

    public void setIgnoreConflicts(boolean ignoreConflicts) {
        this.ignoreConflicts = ignoreConflicts;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
        this.b_timezone = true;
    }

    public void removeLocation() {
        this.location = null;
        this.b_location = false;
    }

    public void removeFullTime() {
        this.fulltime = false;
        this.b_fulltime = false;
    }

    public void removeShownAs() {
        this.shown_as = 0;
        this.b_shown_as = false;
    }

    public void removeAlarm() {
        this.alarm = 0;
        this.b_Alarm = false;
    }

    public void removeTimezone() {
        this.timezone = null;
        this.b_timezone = false;
    }

    public void removeRecurringStart() {
        this.recurring_start = 0L;
        this.b_recurring_start = false;
    }

    public boolean containsRecurringStart() {
        return this.b_recurring_start;
    }

    public boolean containsLocation() {
        return this.b_location;
    }

    public boolean containsFullTime() {
        return this.b_fulltime;
    }

    public boolean containsShownAs() {
        return this.b_shown_as;
    }

    public boolean containsAlarm() {
        return this.b_Alarm;
    }

    public boolean containsTimezone() {
        return this.b_timezone;
    }

    @Override
    public void reset() {
        super.reset();
        this.location = null;
        this.fulltime = false;
        this.shown_as = 0;
        this.alarm = 0;
        this.timezone = null;
        this.b_location = false;
        this.b_fulltime = false;
        this.b_shown_as = false;
        this.b_Alarm = false;
        this.b_timezone = false;
    }

    public int hashCode() {
        return this.objectId;
    }

    public boolean equals(Object o) {
        if (o instanceof Appointment) {
            return ((Appointment)o).hashCode() == this.hashCode();
        }
        return false;
    }

    @Override
    public Appointment clone() {
        Appointment appointmentobject = (Appointment)super.clone();
        for (int field : ALL_COLUMNS) {
            if (!this.contains(field)) continue;
            appointmentobject.set(field, this.get(field));
        }
        if (this.containsLabel()) {
            appointmentobject.setLabel(this.getLabel());
        }
        if (this.containsFullTime()) {
            appointmentobject.setFullTime(this.getFullTime());
        }
        if (this.containsLocation()) {
            appointmentobject.setLocation(this.getLocation());
        }
        if (this.containsShownAs()) {
            appointmentobject.setShownAs(this.getShownAs());
        }
        if (this.containsOccurrence()) {
            appointmentobject.setOccurrence(this.getOccurrence());
        }
        if (this.containsTimezone()) {
            appointmentobject.setTimezone(this.getTimezoneFallbackUTC());
        }
        if (this.containsUid()) {
            appointmentobject.setUid(this.getUid());
        }
        if (this.containsOrganizer()) {
            appointmentobject.setOrganizer(this.getOrganizer());
        }
        if (this.containsPrincipal()) {
            appointmentobject.setPrincipal(this.getPrincipal());
        }
        if (this.containsOrganizerId()) {
            appointmentobject.setOrganizerId(this.getOrganizerId());
        }
        if (this.containsPrincipalId()) {
            appointmentobject.setPrincipalId(this.getPrincipalId());
        }
        return appointmentobject;
    }

    @Override
    public Set<Integer> findDifferingFields(DataObject dataObject) {
        Set<Integer> differingFields = super.findDifferingFields(dataObject);
        if (!this.getClass().isAssignableFrom(dataObject.getClass())) {
            return differingFields;
        }
        Appointment other = (Appointment)dataObject;
        if (!this.containsAlarm() && other.containsAlarm() || this.containsAlarm() && other.containsAlarm() && this.getAlarm() != other.getAlarm()) {
            differingFields.add(204);
        }
        if (!this.containsFullTime() && other.containsFullTime() || this.containsFullTime() && other.containsFullTime() && this.getFullTime() != other.getFullTime()) {
            differingFields.add(401);
        }
        if (!this.containsLocation() && other.containsLocation() || this.containsLocation() && other.containsLocation() && this.getLocation() != other.getLocation() && (this.getLocation() == null || !this.getLocation().equals(other.getLocation()))) {
            differingFields.add(400);
        }
        if (!this.containsRecurringStart() && other.containsRecurringStart() || this.containsRecurringStart() && other.containsRecurringStart() && this.getRecurringStart() != other.getRecurringStart()) {
            differingFields.add(410);
        }
        if (!this.containsShownAs() && other.containsShownAs() || this.containsShownAs() && other.containsShownAs() && this.getShownAs() != other.getShownAs()) {
            differingFields.add(402);
        }
        if (!this.containsTimezone() && other.containsTimezone() || this.containsTimezone() && other.containsTimezone() && this.getTimezone() != other.getTimezone() && (this.getTimezone() == null || !this.getTimezone().equals(other.getTimezone()))) {
            differingFields.add(408);
        }
        return differingFields;
    }

    @Override
    public void set(int field, Object value) {
        switch (field) {
            case 402: {
                this.setShownAs((Integer)value);
                break;
            }
            case 204: {
                this.setAlarm((Integer)value);
                break;
            }
            case 401: {
                this.setFullTime((Boolean)value);
                break;
            }
            case 408: {
                this.setTimezone((String)value);
                break;
            }
            case 410: {
                this.setRecurringStart((Long)value);
                break;
            }
            case 400: {
                this.setLocation((String)value);
                break;
            }
            default: {
                super.set(field, value);
            }
        }
    }

    @Override
    public Object get(int field) {
        switch (field) {
            case 402: {
                return this.getShownAs();
            }
            case 204: {
                return this.getAlarm();
            }
            case 401: {
                return this.getFullTime();
            }
            case 408: {
                return this.getTimezone();
            }
            case 410: {
                return this.getRecurringStart();
            }
            case 400: {
                return this.getLocation();
            }
        }
        return super.get(field);
    }

    @Override
    public boolean contains(int field) {
        switch (field) {
            case 402: {
                return this.containsShownAs();
            }
            case 204: {
                return this.containsAlarm();
            }
            case 401: {
                return this.containsFullTime();
            }
            case 408: {
                return this.containsTimezone();
            }
            case 410: {
                return this.containsRecurringStart();
            }
            case 400: {
                return this.containsLocation();
            }
        }
        return super.contains(field);
    }

    @Override
    public void remove(int field) {
        switch (field) {
            case 402: {
                this.removeShownAs();
                break;
            }
            case 204: {
                this.removeAlarm();
                break;
            }
            case 401: {
                this.removeFullTime();
                break;
            }
            case 408: {
                this.removeTimezone();
                break;
            }
            case 410: {
                this.removeRecurringStart();
                break;
            }
            case 400: {
                this.removeLocation();
                break;
            }
            default: {
                super.remove(field);
            }
        }
    }

    static {
        differ.addAll(CalendarObject.differ);
    }
}

