/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.contact;

import com.openexchange.contact.ContactService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentAuthorization;
import com.openexchange.groupware.attach.AttachmentEvent;
import com.openexchange.groupware.attach.AttachmentListener;
import com.openexchange.groupware.contact.ContactExceptionCodes;
import com.openexchange.groupware.contact.helpers.ContactField;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.java.Autoboxing;
import com.openexchange.server.impl.EffectivePermission;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.oxfolder.OXFolderAccess;

public class ContactsAttachment
implements AttachmentListener,
AttachmentAuthorization {
    @Override
    public long attached(AttachmentEvent event) throws OXException {
        return ContactsAttachment.modifyAttachmentCount(event.getSession(), String.valueOf(event.getFolderId()), String.valueOf(event.getAttachedId()), 1);
    }

    @Override
    public long detached(AttachmentEvent event) throws OXException {
        return ContactsAttachment.modifyAttachmentCount(event.getSession(), String.valueOf(event.getFolderId()), String.valueOf(event.getAttachedId()), -1 * event.getDetached().length);
    }

    @Override
    public void checkMayAttach(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        ContactsAttachment.checkPermissions(folderId, objectId, user, userConfig, ctx, true, true);
    }

    @Override
    public void checkMayDetach(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        this.checkMayAttach(folderId, objectId, user, userConfig, ctx);
    }

    @Override
    public void checkMayReadAttachments(int folderId, int objectId, User user, UserConfiguration userConfig, Context ctx) throws OXException {
        ContactsAttachment.checkPermissions(folderId, objectId, user, userConfig, ctx, true, false);
    }

    private static void checkPermissions(int folderID, int objectID, final User user, UserConfiguration userConfig, final Context context, boolean needsReadAccess, boolean needsWriteAccess) throws OXException {
        if (needsReadAccess || needsWriteAccess) {
            Session session;
            OXFolderAccess folderAccess = new OXFolderAccess(context);
            EffectivePermission permission = folderAccess.getFolderPermission(folderID, user.getId(), userConfig);
            if (needsReadAccess && !permission.canReadOwnObjects()) {
                throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderID), Autoboxing.I((int)context.getContextId()), Autoboxing.I((int)user.getId()));
            }
            if (needsWriteAccess && !permission.canWriteOwnObjects()) {
                throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Autoboxing.I((int)objectID), Autoboxing.I((int)context.getContextId()));
            }
            ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
            Contact contact = contactService.getContact(session = new Session(){

                public int getContextId() {
                    return context.getContextId();
                }

                public String getLocalIp() {
                    throw new UnsupportedOperationException();
                }

                public void setLocalIp(String ip) {
                    throw new UnsupportedOperationException();
                }

                public String getLoginName() {
                    throw new UnsupportedOperationException();
                }

                public boolean containsParameter(String name) {
                    return false;
                }

                public Object getParameter(String name) {
                    return null;
                }

                public String getPassword() {
                    throw new UnsupportedOperationException();
                }

                public String getRandomToken() {
                    throw new UnsupportedOperationException();
                }

                public String getSecret() {
                    throw new UnsupportedOperationException();
                }

                public String getSessionID() {
                    throw new UnsupportedOperationException();
                }

                public int getUserId() {
                    return user.getId();
                }

                public String getUserlogin() {
                    return user.getLoginInfo();
                }

                public String getLogin() {
                    throw new UnsupportedOperationException();
                }

                public void setParameter(String name, Object value) {
                    throw new UnsupportedOperationException();
                }

                public void removeRandomToken() {
                    throw new UnsupportedOperationException();
                }

                public String getAuthId() {
                    throw new UnsupportedOperationException();
                }

                public String getHash() {
                    throw new UnsupportedOperationException();
                }

                public void setHash(String hash) {
                    throw new UnsupportedOperationException();
                }

                public String getClient() {
                    throw new UnsupportedOperationException();
                }

                public void setClient(String client) {
                    throw new UnsupportedOperationException();
                }
            }, Integer.toString(folderID), Integer.toString(objectID), new ContactField[]{ContactField.CREATED_BY, ContactField.PRIVATE_FLAG});
            if (contact.getCreatedBy() != session.getUserId()) {
                if (contact.getPrivateFlag() || needsReadAccess && !permission.canReadAllObjects()) {
                    throw ContactExceptionCodes.NO_ACCESS_PERMISSION.create(Autoboxing.I((int)folderID), Autoboxing.I((int)context.getContextId()), Autoboxing.I((int)user.getId()));
                }
                if (needsWriteAccess && !permission.canWriteAllObjects()) {
                    throw ContactExceptionCodes.NO_CHANGE_PERMISSION.create(Autoboxing.I((int)objectID), Autoboxing.I((int)context.getContextId()));
                }
            }
        }
    }

    private static long modifyAttachmentCount(Session session, String folderID, String objectID, int delta) throws OXException {
        ContactService contactService = ServerServiceRegistry.getInstance().getService(ContactService.class);
        Contact contact = contactService.getContact(session, folderID, objectID, new ContactField[]{ContactField.NUMBER_OF_ATTACHMENTS, ContactField.LAST_MODIFIED});
        if (0 > contact.getNumberOfAttachments() + delta) {
            throw ContactExceptionCodes.TOO_FEW_ATTACHMENTS.create();
        }
        if (0 != delta) {
            contact.setNumberOfAttachments(contact.getNumberOfAttachments() + delta);
            contactService.updateContact(session, folderID, objectID, contact, contact.getLastModified());
        }
        return contact.getLastModified().getTime();
    }
}

